/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.tags.core.context;

import shohaku.core.lang.Eval;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.tags.AbstractContextTag;

/**
 * コンテキスト属性を削除するタグを提供します。
 */
public class RemoveAttributeTag extends AbstractContextTag {

    private String key = null;

    protected Object execute() {

        if (Eval.isBlank(key)) {
            throw new GinkgoException("key is blank." + key);
        }

        return getTagContext().getDocumentContext().removeAttribute(key);
    }

    /**
     * key 属性を格納します。
     * 
     * @param key
     *            key属性
     */
    public void setKey(String key) {
        this.key = key;
    }

    /**
     * type 属性を返却します。
     * 
     * @return type 属性
     */
    public String getKey() {
        return this.key;
    }

}
