/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.tags.core.io;

import java.io.File;

import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.tags.AbstractValueTag;

/**
 * ファイル型のデータを表す値タグを提供します。<br>
 * テキストをファイルパスとして抽象パスに変換します。属性が空文字列の場合、結果は空の抽象パス名になります。
 */
public class FileTag extends AbstractValueTag {

    /* ファイルオブジェクト */
    private File textValue;

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {
        if (textValue == null) {
            throw new GinkgoException("file path is null.");
        }
        return textValue;
    }

    /**
     * 変換されたテキストを格納します。
     * 
     * @param textValue
     *            変換されたテキスト
     */
    public void setTextTransferValue(File textValue) {
        this.textValue = textValue;
    }
}
