/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.tags.core.logic;

import shohaku.ginkgo.EvaluationTag;
import shohaku.ginkgo.tags.AbstractLogicTag;
import shohaku.ginkgo.type.EvaluationValue;

/**
 * コンテンツを評価するか検証するタグを提供します。
 */
public class IfThenTag extends AbstractLogicTag {

    /* 本文を評価するか検証する機能 */
    private EvaluationValue test = null;

    public int doEvalBody() {
        return END_BODY;
    }

    public int doInitBody() {
        // 本文を評価するか検証する
        if (test.evaluate().booleanValue()) {
            return EvaluationTag.INIT_BODY;
        } else {
            return EvaluationTag.SKIP_BODY;
        }
    }

    /**
     * 検証機能を格納します。
     * 
     * @param test
     *            検証機能
     */
    protected void setTest(EvaluationValue test) {
        this.test = test;
    }

}
