/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.tags.core.resource;

import shohaku.core.resource.IOResource;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.tags.AbstractValueTag;

/**
 * ファイルやネットワーク上のリソースを表現する値タグを提供します。 shohaku.core.io.IOResource 型のデータを生成します。<br>
 * path 属性をリソースパスとして IOResource を生成します。
 * 
 * @see shohaku.core.resource.IOResource
 */
public class ResourceTag extends AbstractValueTag {

    /* IOリソース */
    private IOResource path;

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {
        if (path == null) {
            throw new GinkgoException("resource path is null.");
        }
        return path;
    }

    /**
     * リソースのパスから生成されるIOリソースを格納します。
     * 
     * @param path
     *            IOリソース
     */
    public void setPath(IOResource path) {
        this.path = path;
    }

    /**
     * リソースのパスから生成されるIOリソースを返却します。
     * 
     * @return IOリソース
     */
    public IOResource getPath() {
        return this.path;
    }
}
