/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.tags.core.util;

import java.util.Date;

import shohaku.core.helpers.HCnv;
import shohaku.core.lang.Eval;
import shohaku.core.lang.ValueOf;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.tags.AbstractValueTag;

/**
 * 日付型のデータを表す値タグを提供します。
 */
public class DateTimeTag extends AbstractValueTag {

    /* テキストから自動変換されたデータを格納する */
    private String textValue;

    private String format = null;

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {

        if (Eval.isBlank(textValue)) {
            throw new GinkgoException("text is blank." + textValue);
        }

        Date date = null;
        if (Eval.isBlank(format)) {
            date = HCnv.asDataObject(ValueOf.decodeDateTime(textValue));
        } else {
            date = HCnv.toDateTime(textValue, format);
        }
        if (date == null) {
            throw new GinkgoException("illegal Date format. " + textValue + ", " + format);
        }
        return date;
    }

    /**
     * format 属性を格納します。
     * 
     * @param format
     *            format 属性
     */
    public void setFormat(String format) {
        this.format = format;
    }

    /**
     * format 属性を返却します。
     * 
     * @return format 属性
     */
    public String getFormat() {
        return this.format;
    }

    /**
     * 変換されたテキストを格納します。
     * 
     * @param textValue
     *            変換されたテキスト
     */
    public void setTextTransferValue(String textValue) {
        this.textValue = textValue;
    }

}
