/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.tags.core.util;

import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.tags.AbstractValueTag;
import shohaku.ginkgo.type.ExpressionValue;

/**
 * 組み込み式としてデータ解析する値タグを提供します、デフォルトではOGDL式が使用されます。
 * 
 * @see shohaku.ginkgo.type.ExpressionValue
 */
public class ExpressionTag extends AbstractValueTag {

    /* テキストから自動変換されたデータを格納する */
    private ExpressionValue textValue;

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {
        if (textValue == null) {
            throw new GinkgoException("text is null.");
        }
        return textValue.getResultValue();
    }

    /**
     * 変換されたテキストを格納します。
     * 
     * @param textValue
     *            変換されたテキスト
     */
    public void setTextTransferValue(ExpressionValue textValue) {
        this.textValue = textValue;
    }

}