/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.tags.core.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import shohaku.ginkgo.tags.AbstractValueTag;

/**
 * Properties 型のデータを表す値タグを提供します。
 */
public class PropertiesTag extends AbstractValueTag {

    /* プロパティセット */
    private Properties path = null;

    private final List elements = new LinkedList();

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {
        Properties props = (null == path) ? new Properties() : path;
        for (Iterator i = elements.iterator(); i.hasNext();) {
            props.putAll((Map) i.next());
        }
        return props;
    }

    /**
     * プロパティセットを格納します。
     * 
     * @param path
     *            プロパティセット
     */
    public void setPath(Properties path) {
        this.path = path;
    }

    /**
     * プロパティセットを返却します。
     * 
     * @return プロパティセット
     */
    public Properties getPath() {
        return this.path;
    }

    /**
     * エレメントを追加します。
     * 
     * @param element
     *            エレメント
     */
    public void addElementTransferValue(Map element) {
        elements.add(element);
    }

}