/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.type;

import shohaku.core.lang.Predicate;

/**
 * 評価を実行して Boolean を返す値オブジェクトです。
 */
public class EvaluationValue {

    private final Predicate predicate;

    /**
     * 評価を実行するクロージャを格納して初期化します。
     * 
     * @param predicate
     *            クロージャ
     */
    public EvaluationValue(Predicate predicate) {
        super();
        this.predicate = predicate;
    }

    /**
     * 評価を実行して結果を返却します。
     * 
     * @return 評価の結果
     */
    public Boolean evaluate() {
        return Boolean.valueOf(predicate.evaluate(null));
    }

    /**
     * 評価を実行するクロージャを格納します。<br>
     * また Predicate.evaluate(Object) の引数には null が渡されます。
     * 
     * @return クロージャ
     */
    public Predicate getPredicate() {
        return this.predicate;
    }

}
