/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.type;

/**
 * 式言語の評価結果を表現する値オブジェクトです。
 */
public class ExpressionValue {

    /* 評価の基となる文字列 */
    private final String source;

    /* 式の評価結果 */
    private final Object resultValue;

    /**
     * プロパティを格納して初期化します。
     * 
     * @param source
     *            評価の基となる文字列
     * @param resultValue
     *            式の評価結果
     */
    public ExpressionValue(String source, Object resultValue) {
        this.source = source;
        this.resultValue = resultValue;
    }

    /**
     * 式の評価結果を返却します。
     * 
     * @return 式の評価結果
     */
    public Object getResultValue() {
        return resultValue;
    }

    /**
     * 評価の基となる文字列を返却します。
     * 
     * @return 評価の基となる文字列
     */
    public String getSource() {
        return source;
    }

}
