/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.type;

import java.util.Iterator;

import shohaku.core.collections.IteratorUtils;

/**
 * 反復子を生成する値オブジェクトです。
 */
public class IterateValue {

    /* 反復子の生成基と為るオブジェクト */
    protected final Object source;

    /**
     * 反復子の生成基と為るオブジェクトを格納して初期化します。
     * 
     * @param source
     *            反復子の生成基と為るオブジェクト
     */
    public IterateValue(Object source) {
        this.source = source;
    }

    /**
     * 反復子の生成基と為るオブジェクトを返却します。
     * 
     * @return 反復子の生成基と為るオブジェクト
     */
    public Object getSource() {
        return source;
    }

    /**
     * 反復子を生成して返却します。<br>
     * 必要に応じてオーバーライドしてください。
     * 
     * @return 反復子
     */
    public Iterator iterator() {
        return IteratorUtils.collectionIterator(source);
    }

}
