/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.type;

/**
 * 参照の値を表現する値オブジェクトです。
 */
public class ReferenceValue {

    /* 評価の基となる文字列 */
    private final String source;

    /* 式の評価結果 */
    private final Object resultValue;

    /**
     * プロパティを格納して初期化します。
     * 
     * @param source
     *            参照要求の基となる文字列
     * @param resultValue
     *            参照の値
     */
    public ReferenceValue(String source, Object resultValue) {
        this.source = source;
        this.resultValue = resultValue;
    }

    /**
     * 参照の値を返却します。
     * 
     * @return 参照の値
     */
    public Object getResultValue() {
        return resultValue;
    }

    /**
     * 参照要求の基となる文字列を返却します。
     * 
     * @return 参照要求の基となる文字列
     */
    public String getSource() {
        return source;
    }

}
