/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import jdbcacsess.gui.CellMode;
import jdbcacsess.sql.column.Binary;
import jdbcacsess.sql.column.DenyEditInCell;
import jdbcacsess.sql.column.GetColumnBinary;

class CellInfo {
    private boolean cellEditable = true;
    private CellMode mode = CellMode.CELL_NON;
    private Object value = null;
    private boolean defaultInsert = false;

    CellInfo() {
    }

    public CellInfo copy() {
        CellInfo cellInfo = new CellInfo();
        cellInfo.value = this.value;
        if (this.value instanceof GetColumnBinary && !((GetColumnBinary)this.value).isFullData()) {
            cellInfo.value = new Binary();
        }
        cellInfo.cellEditable = true;
        cellInfo.mode = CellMode.CELL_INSERT;
        cellInfo.defaultInsert = this.defaultInsert;
        return cellInfo;
    }

    public CellMode getMode() {
        return this.mode;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isCellEditable() {
        return this.cellEditable;
    }

    public void setMode(CellMode mode) {
        switch (mode) {
            case CELL_DELETE: {
                this.cellEditable = false;
                break;
            }
            case CELL_DELETE_COMPLETE: {
                this.cellEditable = false;
                break;
            }
            case CELL_DENYEDIT_IN_CELL: {
                this.cellEditable = false;
                break;
            }
            default: {
                this.cellEditable = true;
            }
        }
        this.mode = mode;
    }

    public void setInitialValue(Object value) {
        this.setMode(CellMode.CELL_NON);
        this.setValue(value);
    }

    public void setUpdateCompleteValue(Object value) {
        this.setMode(CellMode.CELL_UPDATE_COMPLETE);
        this.setValue(value);
    }

    public void setInsertValue(Object value) {
        this.setMode(CellMode.CELL_INSERT);
        this.setValue(value);
    }

    private void setValue(Object value) {
        this.value = value;
        if (value instanceof DenyEditInCell) {
            this.setMode(CellMode.CELL_DENYEDIT_IN_CELL);
        }
        if (value instanceof String) {
            String str = (String)value;
            int i = 0;
            while (i < str.length()) {
                char c = str.charAt(i);
                if (c == '\n' || c == '\r') {
                    this.setMode(CellMode.CELL_DENYEDIT_IN_CELL);
                    break;
                }
                ++i;
            }
        }
        if (value instanceof GetColumnBinary && !((GetColumnBinary)value).isFullData()) {
            this.setMode(CellMode.CELL_DENYEDIT_IN_CELL);
        }
    }

    public boolean isDefaultInsert() {
        return this.defaultInsert;
    }

    public void setDefaultInsert(boolean defaultInsert) {
        this.defaultInsert = defaultInsert;
    }
}

