/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jdbcacsess.ColumnWidth;
import jdbcacsess.JFrameBase;
import jdbcacsess.gui.JDialogMessage;
import jdbcacsess.gui.JTableHexViewerModel;
import jdbcacsess.gui.Viewer;

public class JFrameViewerHex
extends JFrameBase
implements Viewer {
    private static final long serialVersionUID = -6595776140691157849L;
    private static final String TITLE = "\u30d0\u30a4\u30ca\u30ea\u30d3\u30e5\u30fc\u30ef";
    private JPanel jContentPane = null;
    private JScrollPane jScrollPane = null;
    private JTable jTableHexViewer = null;
    private static JFrameViewerHex jFrameViewer = null;
    private JTableHexViewerModel model;
    private InputStream is;
    private JLabel jLabel = null;

    public static JFrameViewerHex getInstance() {
        if (jFrameViewer == null) {
            jFrameViewer = new JFrameViewerHex();
        }
        return jFrameViewer;
    }

    private JFrameViewerHex() {
        this.initialize();
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.setTitle(TITLE);
        this.setSize(new Dimension(600, 400));
        super.init();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JFrameViewerHex.this.frameClosing();
            }
        });
    }

    private void frameClosing() {
        jFrameViewer = null;
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException e) {
                JDialogMessage.errorDialog(e);
            }
        }
        if (this.model != null) {
            this.model.clear();
        }
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText("JLabel");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJScrollPane(), "Center");
            this.jContentPane.add((Component)this.jLabel, "South");
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTableHexViewer());
        }
        return this.jScrollPane;
    }

    private JTable getJTableHexViewer() {
        if (this.jTableHexViewer == null) {
            this.jTableHexViewer = new JTable();
            this.jTableHexViewer.setCellSelectionEnabled(true);
        }
        return this.jTableHexViewer;
    }

    public void setInputStream(InputStream is, long size, String title) {
        this.setTitle("\u30d0\u30a4\u30ca\u30ea\u30d3\u30e5\u30fc\u30ef [" + title + "]");
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException e) {
                JDialogMessage.errorDialog(e);
            }
        }
        this.setDataSize(size);
        this.is = is;
        this.model = new JTableHexViewerModel(is, size, this);
        this.jTableHexViewer.setModel(this.model);
        this.jTableHexViewer.getColumnModel().getColumn(0).setCellRenderer(this.jTableHexViewer.getTableHeader().getDefaultRenderer());
        ColumnWidth.setHeaderWidthResizeOff(this.jTableHexViewer, 7);
        int w = this.jTableHexViewer.getColumn("0F").getPreferredWidth();
        this.jTableHexViewer.getColumn("0F").setPreferredWidth((int)((double)w * 1.5));
        this.setVisible(true);
    }

    public void setDataSize(long size) {
        String msg = "";
        if (size == -1L) {
            msg = "\u5168\u4f53\u30d0\u30a4\u30c8\u6570\u306f\u4e0d\u660e\u3067\u3059";
        } else {
            long kByte = size / 1024L;
            msg = String.valueOf(size) + "\u30d0\u30a4\u30c8 " + (kByte > 0L ? "(" + size / 1024L + "KB)" : "");
            msg = String.valueOf(msg) + "   0x" + Long.toHexString(size).toUpperCase() + "\u30d0\u30a4\u30c8 " + (kByte > 0L ? "(0x" + Long.toHexString(size / 1024L).toUpperCase() + "KB)" : "");
        }
        this.jLabel.setText(msg);
    }
}

