/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.sql.column;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.sql.ResultSet;
import jdbcacsess.sql.column.BinaryInputStream;
import jdbcacsess.sql.column.GetColumnBinary;

public class GetColumnBytesOrBinaryStream
extends GetColumnBinary {
    public GetColumnBytesOrBinaryStream() {
    }

    public GetColumnBytesOrBinaryStream(int binaryDataSize) {
        super(binaryDataSize);
    }

    private GetColumnBytesOrBinaryStream(byte[] bytes, boolean fullData) {
        super(bytes, fullData);
    }

    public GetColumnBytesOrBinaryStream getData(ResultSet resultSet, int i) throws Exception {
        byte[] b = null;
        boolean fullData = true;
        if (this.binaryDataSize == 0) {
            b = resultSet.getBytes(i);
            if (resultSet.wasNull() || b == null) {
                return null;
            }
        } else {
            InputStream is = resultSet.getBinaryStream(i);
            if (resultSet.wasNull() || is == null) {
                return null;
            }
            BufferedInputStream bis = new BufferedInputStream(is);
            try {
                b = BinaryInputStream.readBytes(bis, this.binaryDataSize);
                if (bis.read() != -1) {
                    fullData = false;
                }
            }
            finally {
                bis.close();
            }
        }
        return new GetColumnBytesOrBinaryStream(b, fullData);
    }
}

