/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui.cell;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.PlainDocument;
import jdbcacsess.gui.common.ComponentProperty;
import jdbcacsess.gui.common.JComboBoxLineSeparator;
import jdbcacsess.gui.common.JPopupMenuEdit;

public class JDialogTextEditer
extends JDialog {
    private static final long serialVersionUID = -7455394030874059074L;
    private JPanel jContentPane = null;
    private JPanel jPanel = null;
    private JButton jButtonUpdate = null;
    private JButton jButtonCancel = null;
    private JScrollPane jScrollPane = null;
    private JTextArea jTextArea = null;
    private JComboBoxLineSeparator jComboBoxLineSeparator = null;
    private JPanel jPanel1 = null;
    boolean tableUpdate;
    private JCheckBox jCheckBoxLineWrap = null;
    private JPanel jPanel2 = null;
    private JRadioButton jRadioButtonTab2 = null;
    private JRadioButton jRadioButtonTab3 = null;
    private JRadioButton jRadioButtonTab4 = null;
    private JRadioButton jRadioButtonTab8 = null;

    public JDialogTextEditer() throws HeadlessException {
        this.initialize();
    }

    private void initialize() {
        new ComponentProperty().restoreWindowPosition(this, 600, 400);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JDialogTextEditer.this.dialogClosing();
            }
        });
        this.setTitle("\u30c6\u30ad\u30b9\u30c8\u7de8\u96c6");
        this.setModal(true);
        this.setContentPane(this.getJContentPane());
        this.jComboBoxLineSeparator.setSelectedItem(this.getLineSeparatorFromProperty());
        int tabSize = this.getTabSizeFromProperty();
        switch (tabSize) {
            case 2: {
                this.jRadioButtonTab2.setSelected(true);
                break;
            }
            case 3: {
                this.jRadioButtonTab3.setSelected(true);
                break;
            }
            case 4: {
                this.jRadioButtonTab4.setSelected(true);
                break;
            }
            case 8: {
                this.jRadioButtonTab8.setSelected(true);
            }
        }
        this.jTextArea.setTabSize(this.getTabSizeFromProperty());
        this.jCheckBoxLineWrap.setSelected(this.getLineWrapProperty());
        new JPopupMenuEdit(this.jTextArea);
    }

    public void dialogClosing() {
        ComponentProperty cp = new ComponentProperty();
        cp.storeWindowPosition(this);
        cp.put(this.getClass(), "lineSeparator", this.jComboBoxLineSeparator.getSelectedItem().toString());
        cp.put(this.getClass(), "tabSize", this.jTextArea.getTabSize());
        cp.put(this.getClass(), "lineWrap", new Boolean(this.jTextArea.getLineWrap()).toString());
        this.tableUpdate = false;
        this.setVisible(false);
    }

    private JComboBoxLineSeparator.LineSeparator getLineSeparatorFromProperty() {
        String rtn = new ComponentProperty().getToString(this.getClass(), "lineSeparator");
        return JComboBoxLineSeparator.LineSeparator.defaultValueOf(rtn);
    }

    private int getTabSizeFromProperty() {
        Integer rtn = new ComponentProperty().getToInteger(this.getClass(), "tabSize");
        if (rtn == null) {
            return 4;
        }
        return rtn;
    }

    private boolean getLineWrapProperty() {
        String rtn = new ComponentProperty().getToString(this.getClass(), "lineWrap");
        if (rtn.equals("")) {
            rtn = "false";
        }
        return new Boolean(rtn);
    }

    public void setText(String text) {
        if (text == null) {
            return;
        }
        StringReader sr = new StringReader(text);
        try {
            this.jTextArea.read(sr, new PlainDocument());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.jTextArea.setTabSize(this.getTabSizeFromProperty());
        this.jTextArea.setLineWrap(this.getLineWrapProperty());
        this.jTextArea.setCaretPosition(0);
    }

    public String getText() {
        String lineSeparator = this.jComboBoxLineSeparator.getSelectedItem().getLineSeparator();
        StringBuilder sb = new StringBuilder();
        String str = this.jTextArea.getText();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '\n') {
                sb.append(lineSeparator);
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public boolean isTableUpdate() {
        return this.tableUpdate;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJPanel(), "South");
            this.jContentPane.add((Component)this.getJScrollPane(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.add((Component)this.getJPanel2(), null);
            this.jPanel.add((Component)this.getJCheckBoxLineWrap(), null);
            this.jPanel.add((Component)this.getJPanel1(), null);
            this.jPanel.add((Component)this.getJButton(), null);
            this.jPanel.add((Component)this.getJButton1(), null);
        }
        return this.jPanel;
    }

    private JButton getJButton() {
        if (this.jButtonUpdate == null) {
            this.jButtonUpdate = new JButton();
            this.jButtonUpdate.setText("DB\u66f4\u65b0");
            this.jButtonUpdate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JDialogTextEditer.this.tableUpdate = true;
                    JDialogTextEditer.this.setVisible(false);
                }
            });
        }
        return this.jButtonUpdate;
    }

    private JButton getJButton1() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setText("\u9589\u3058\u308b");
            this.jButtonCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JDialogTextEditer.this.dialogClosing();
                }
            });
        }
        return this.jButtonCancel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTextArea());
        }
        return this.jScrollPane;
    }

    private JTextArea getJTextArea() {
        if (this.jTextArea == null) {
            this.jTextArea = new JTextArea();
        }
        return this.jTextArea;
    }

    private JComboBoxLineSeparator getJComboBoxLineSeparator() {
        if (this.jComboBoxLineSeparator == null) {
            this.jComboBoxLineSeparator = new JComboBoxLineSeparator();
        }
        return this.jComboBoxLineSeparator;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new BorderLayout());
            this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "\u66f4\u65b0\u6642\u306e\u6539\u884c", 0, 0, null, null));
            this.jPanel1.setMinimumSize(new Dimension(0, 0));
            this.jPanel1.add((Component)this.getJComboBoxLineSeparator(), "Center");
        }
        return this.jPanel1;
    }

    private JCheckBox getJCheckBoxLineWrap() {
        if (this.jCheckBoxLineWrap == null) {
            this.jCheckBoxLineWrap = new JCheckBox();
            this.jCheckBoxLineWrap.setText("\u884c\u6298\u308a\u8fd4\u3057");
            this.jCheckBoxLineWrap.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    JDialogTextEditer.this.jTextArea.setLineWrap(JDialogTextEditer.this.jCheckBoxLineWrap.isSelected());
                }
            });
        }
        return this.jCheckBoxLineWrap;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setVgap(0);
            flowLayout.setHgap(0);
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(flowLayout);
            this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "\u30bf\u30d6\u306e\u8868\u793a\u30ab\u30e9\u30e0\u6570", 0, 0, null, null));
            this.jPanel2.add((Component)this.getJRadioButtonTab2(), null);
            this.jPanel2.add((Component)this.getJRadioButtonTab3(), null);
            this.jPanel2.add((Component)this.getJRadioButtonTab4(), null);
            this.jPanel2.add((Component)this.getJRadioButtonTab8(), null);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.jRadioButtonTab2);
            bg.add(this.jRadioButtonTab3);
            bg.add(this.jRadioButtonTab4);
            bg.add(this.jRadioButtonTab8);
        }
        return this.jPanel2;
    }

    private JRadioButton getJRadioButtonTab2() {
        if (this.jRadioButtonTab2 == null) {
            this.jRadioButtonTab2 = new JRadioButton();
            this.jRadioButtonTab2.setText("2");
            this.jRadioButtonTab2.setMargin(new Insets(0, 0, 0, 0));
            this.jRadioButtonTab2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JDialogTextEditer.this.jTextArea.setTabSize(2);
                }
            });
        }
        return this.jRadioButtonTab2;
    }

    private JRadioButton getJRadioButtonTab3() {
        if (this.jRadioButtonTab3 == null) {
            this.jRadioButtonTab3 = new JRadioButton();
            this.jRadioButtonTab3.setText("3");
            this.jRadioButtonTab3.setMargin(new Insets(0, 0, 0, 0));
            this.jRadioButtonTab3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JDialogTextEditer.this.jTextArea.setTabSize(3);
                }
            });
        }
        return this.jRadioButtonTab3;
    }

    private JRadioButton getJRadioButtonTab4() {
        if (this.jRadioButtonTab4 == null) {
            this.jRadioButtonTab4 = new JRadioButton();
            this.jRadioButtonTab4.setText("4");
            this.jRadioButtonTab4.setMargin(new Insets(0, 0, 0, 0));
            this.jRadioButtonTab4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JDialogTextEditer.this.jTextArea.setTabSize(4);
                }
            });
        }
        return this.jRadioButtonTab4;
    }

    private JRadioButton getJRadioButtonTab8() {
        if (this.jRadioButtonTab8 == null) {
            this.jRadioButtonTab8 = new JRadioButton();
            this.jRadioButtonTab8.setText("8");
            this.jRadioButtonTab8.setMargin(new Insets(0, 0, 0, 0));
            this.jRadioButtonTab8.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JDialogTextEditer.this.jTextArea.setTabSize(8);
                }
            });
        }
        return this.jRadioButtonTab8;
    }
}

