{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: ChatForm

 private messages window

*********************************************************}
unit ChatForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Classes2, Graphics, Controls, Forms,
    Dialogs, StdCtrls, ExtCtrls, ComCtrls, Menus;

type
  TSlavaNapChatWindow = class(TForm)
    Panel_Bottom: TPanel;
    Edit: TEdit;
    Panel_Left: TPanel;
    Log: TRichEdit;
    MainMenu1: TMainMenu;
    Mnu_Close: TMenuItem;
    Mnu_Hotlist: TMenuItem;
    Mnu_Friend: TMenuItem;
    Mnu_Whois: TMenuItem;
    Mnu_Ignore: TMenuItem;
    Timer1: TTimer;
    Popup_Log: TPopupMenu;
    Mnu_Log_Clear: TMenuItem;
    Mnu_Log_Copy: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure Panel_BottomResize(Sender: TObject);
    procedure LogChange(Sender: TObject);
    procedure CreateParams(var Params: TCreateParams); override;
    procedure editKeyPress(Sender: TObject; var Key: Char);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure editKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure Mnu_Draw(Sender: TObject; ACanvas: TCanvas; ARect: TRect;
      Selected: Boolean);
    procedure Mnu_CloseClick(Sender: TObject);
    procedure Mnu_HotlistClick(Sender: TObject);
    procedure Mnu_FriendClick(Sender: TObject);
    procedure Mnu_WhoisClick(Sender: TObject);
    procedure Mnu_IgnoreClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure MyWndProc(var Message: TMessage);
    procedure logMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Mnu_Log_ClearClick(Sender: TObject);
    procedure Mnu_Log_CopyClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    User: string;
    History: TMyStringList;
    Last: Integer;
    Flash_Count: Integer;
    procedure AddMessage(Color: Integer; Text: string);
    procedure ChangeColors;
  end;

var
  SlavaNapChatWindow: TSlavaNapChatWindow;

implementation

uses STypes, Vars, Constants, Lang, SlavaMenu, Languages;

{$R *.DFM}

procedure TSlavaNapChatWindow.Panel_BottomResize(Sender: TObject);
var
  I, J: Integer;
begin
  Edit.Width := Panel_Bottom.Width - 4;
end;

procedure TSlavaNapChatWindow.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  Params.ExStyle := Params.ExStyle and not WS_EX_TOOLWINDOW or WS_EX_APPWINDOW;
end;

procedure TSlavaNapChatWindow.FormCreate(Sender: TObject);
var
  R: TRect;
begin
  SystemParametersInfo(SPI_GETWORKAREA, 0, @R, 0);
  Top := (R.Top + R.Bottom - Height) div 2;
  Left := (R.Right + R.Left - Width - 4) div 2;
  History := TMyStringList.Create;
  WindowProc := MyWndProc;
  Flash_Count := 100;
  SetActiveWindow(Handle);
  Log.Lines.Clear;
  Edit.Text := '';
  SetFont(Self.Font);
  ChangeColors;
  if Chat_Mini then
    WindowState := wsMinimized;
end;

procedure TSlavaNapChatWindow.LogChange(Sender: TObject);
var
  C1: TRichEdit;
begin
  if Sender Is TRichEdit then
  begin
    C1 := Sender as TRichEdit;
    C1.SelStart := C1.Perform(EM_LINEINDEX, C1.Lines.Count, 0);
    C1.Perform(EM_SCROLLCARET, 0, 0);
    Exit;
  end;
end;

procedure TSlavaNapChatWindow.EditKeyPress(Sender: TObject;
  var Key: Char);
begin
  if Key = #13 then
    Key := #0;
end;

procedure TSlavaNapChatWindow.AddMessage(Color: Integer; Text: string);
begin
  try
    if Log.Lines.Count > 300 then
    begin
      Log.Lines.BeginUpdate;
      while Log.Lines.Count > 300 do
        Log.Lines.Delete(0);
      Log.Lines.EndUpdate;
    end;
    Log.SelLength := 0;
    Log.SelStart := Length(Log.Text);
    Log.SelAttributes.Color := Color;
    // Log.Lines.Add(GetLogTime + Text);
    Log.Lines.Add(Text);
    LogChange(Log);
    if Chat_Flash then
      Flash_Count := 0;
  except
  end;
  try
    if Switch_Chat then
      Edit.SetFocus;
  except
  end;
end;

procedure TSlavaNapChatWindow.FormDestroy(Sender: TObject);
var
  I: Integer;
begin
  History.Free;
  History := nil;
  if Cons_Chat <> nil then
    for I := Cons_Chat.Count - 1 downto 0 do
      if Cons_Chat.Items[I] = Self then
        Cons_Chat.Delete(I);
end;

procedure TSlavaNapChatWindow.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TSlavaNapChatWindow.EditKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  Str: string;
  B: Boolean;
begin
  case Key of
    13:
      try
        if not Running then Exit;
        Str := Edit.Text;
        Cmd_List.AddDoubleCmd(MSG_CLIENT_PRIVMSG, 0, User + ' ' + Str, '');
        Last := History.Add(Str) + 1;
        if History.Count > 100 then
        begin
          History.Delete(0);
          Dec(Last);
        end;
        Edit.Text := '';
      except
      end;
    38:
      begin // Up
        if Last > 0 then
        begin
          Dec(Last);
          Str := History.Strings[Last];
          Edit.SelectAll;
          Edit.SetSelTextBuf(PChar(Str));
        end
        else if History.Count > 0 then
        begin
          Str := History.Strings[0];
          Edit.SelectAll;
          Edit.SetSelTextBuf(PChar(Str));
        end;
      end;
    40:
      begin // Down
        if Last < (History.Count - 1) then
        begin
          Inc(Last);
          Str := History.Strings[Last];
          Edit.SelectAll;
          Edit.SetSelTextBuf(PChar(Str));
        end
        else
        begin
          Last := History.Count;
          Edit.Text := '';
        end;
      end;
  end;
end;

procedure TSlavaNapChatWindow.Mnu_Draw(Sender: TObject; ACanvas: TCanvas;
  ARect: TRect; Selected: Boolean);
begin
  SlavaDrawMainMenu(Self, Sender, ACanvas, ARect, Selected);
end;

procedure TSlavaNapChatWindow.Mnu_CloseClick(Sender: TObject);
begin
  Close;
end;

procedure TSlavaNapChatWindow.Mnu_HotlistClick(Sender: TObject);
begin
  if Running then
    Cmd_List.AddDoubleCmd(MSG_CLIENT_ADD_HOTLIST, 0, User, '');
end;

procedure TSlavaNapChatWindow.Mnu_FriendClick(Sender: TObject);
begin
  if Running then
    Cmd_List.AddDoubleCmd(MSG_CLIENT_FRIENDS, 0, 'Add ' + User, '');
end;

procedure TSlavaNapChatWindow.Mnu_WhoisClick(Sender: TObject);
begin
  if Running then
    Cmd_List.AddDoubleCmd(MSG_CLIENT_WHOIS, 0, User, '');
end;

procedure TSlavaNapChatWindow.Mnu_IgnoreClick(Sender: TObject);
begin
  if Running then
    Cmd_List.AddDoubleCmd(MSG_CLIENT_IGNORE_USER, 0, User, '');
end;

procedure TSlavaNapChatWindow.FormShow(Sender: TObject);
begin
  Mnu_Close.Caption := GetLangI(LNG_CMNU_CLOSE);
  Mnu_Hotlist.Caption := GetLangI(LNG_CMNU_HOTLIST);
  Mnu_Friend.Caption := GetLangI(LNG_CMNU_FRIEND);
  Mnu_Whois.Caption := GetLangI(LNG_CMNU_WHOIS);
  Mnu_Ignore.Caption := GetLangI(LNG_CMNU_IGNORE);
  Mnu_Log_Clear.Caption := GetLangI(LNG_MENU_CLEAR);
  Mnu_Log_Copy.Caption := GetLangI(LNG_MENU_COPY);
end;

procedure TSlavaNapChatWindow.FormResize(Sender: TObject);
begin
  try
    Log.Invalidate;
  except
  end;
end;

procedure TSlavaNapChatWindow.Timer1Timer(Sender: TObject);
begin
  if Flash_Count < 11 then
    FlashWindow(Handle, not Active);
  if Flash_Count = 11 then
    FlashWindow(Handle, False);
  Inc(Flash_Count);
end;

procedure TSlavaNapChatWindow.FormActivate(Sender: TObject);
begin
  Flash_Count := 100;
end;

procedure TSlavaNapChatWindow.MyWndProc(var Message: TMessage);
begin
  WndProc(Message);
  if Message.Msg = WM_ACTIVATE then
    Flash_Count := 100;
end;

procedure TSlavaNapChatWindow.ChangeColors;
begin
  Log.Color := slBackground;
  Log.Font.Color := slText;
  Edit.Color := slBackground;
  Edit.Font.Color := slText;
end;

procedure TSlavaNapChatWindow.LogMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbRight then
  begin
    Popup_Log.Popup(Mouse.CursorPos.X, Mouse.CursorPos.Y);
  end;
end;

procedure TSlavaNapChatWindow.Mnu_Log_ClearClick(Sender: TObject);
begin
  Log.Lines.Clear;
end;

procedure TSlavaNapChatWindow.Mnu_Log_CopyClick(Sender: TObject);
begin
  Log.CopyToClipboard;
end;

end.
