{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: ChanAttr

 Channel Attributes window

*********************************************************}
unit ChanAttr;

interface

uses
  Windows, Messages, SysUtils, Classes2, Graphics, Controls, Forms, Dialogs,
  STypes, Vars, Channels, Handler, Constants, Lang, StdCtrls, SlavaStrings,
  Spin, Classes, Languages;

type
  TSlavaNapChannelAttr = class(TForm)
    Lbl_Topic: TLabel;
    Edit_Topic: TEdit;
    Lbl_Limit: TLabel;
    Lbl_Level: TLabel;
    Lbl_Motd: TLabel;
    Box_Attr: TGroupBox;
    Cb_Registered: TCheckBox;
    Cb_private: TCheckBox;
    Cb_Moderated: TCheckBox;
    Cb_Topic: TCheckBox;
    Edit_Limit: TSpinEdit;
    Edit_Level: TComboBox;
    Edit_Motd: TMemo;
    Btn_Ok: TButton;
    Btn_Cancel: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Btn_CancelClick(Sender: TObject);
    procedure Btn_OkClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Channel: string;
    procedure ShowChannel(Str: string);
  end;

var
  SlavaNapChannelAttr: TSlavaNapChannelAttr;

implementation

{$R *.DFM}

procedure TSlavaNapChannelAttr.ShowChannel(Str: string);
var
  I: Integer;
  Ch: TChannel;
  Item: PStringHashItem;
begin
  try
    Hide;
  except
  end;
  Channel := Str;
  Ch := FindChannel(Str);
  if Ch = nil then Exit;
  Edit_Level.Items.Clear;
  for I := 0 to 5 do
    Edit_Level.Items.Add(Levels[I]);
  Edit_Topic.Text := Ch.Topic;
  Edit_Limit.Value := Ch.Limit;
  Edit_Level.ItemIndex := Ord(Ch.Level);
  Cb_Registered.Checked := chRegistered in Ch.State;
  Cb_private.Checked := chPrivate in Ch.State;
  Cb_Moderated.Checked := chModerated in Ch.State;
  Cb_Topic.Checked := chTopic in Ch.State;
  Edit_Motd.Lines.Clear;
  Item := Ch.Motd.First;
  while Item <> nil do
  begin
    Edit_Motd.Lines.Add(Item^.Data);
    Item := Item^.Next;
  end;
  try
    Show;
    Edit_Topic.SetFocus;
  except
  end;
end;

procedure TSlavaNapChannelAttr.FormCreate(Sender: TObject);
var
  R: TRect;
begin
  SystemParametersInfo(SPI_GETWORKAREA, 0, @R, 0);
  Top := (R.Top + R.Bottom - Height) div 2;
  Left := (R.Right + R.Left - Width - 4) div 2;
end;

procedure TSlavaNapChannelAttr.FormShow(Sender: TObject);
var
  I, J: Integer;
begin
  SetFont(Self.Font);
  Lbl_Topic.Caption := GetLangI(LNG_EDITCH_TOPIC);
  Lbl_Limit.Caption := GetLangI(LNG_EDITCH_LIMIT);
  Lbl_Level.Caption := GetLangI(LNG_EDITCH_LEVEL);
  Box_Attr.Caption := ' ' + GetLangI(LNG_EDITCH_ATTR) + ' ';
  Cb_Registered.Caption := GetLangI(LNG_EDITCH_REGISTERED);
  Cb_private.Caption := GetLangI(LNG_EDITCH_PRIVATE);
  Cb_Moderated.Caption := GetLangI(LNG_EDITCH_MODERATED);
  Cb_Topic.Caption := GetLangI(LNG_EDITCH_TOPICATTR);
  Lbl_Motd.Caption := GetLangI(LNG_EDITCH_MOTD);
  Btn_Ok.Caption := GetLangI(LNG_EDITCH_OK);
  Btn_Cancel.Caption := GetLangI(LNG_EDITCH_CANCEL);
  Caption := GetLangI(LNG_EDITCH_CAPTION, Channel);
  I := Lbl_Topic.Width;
  I := Max(I, Lbl_Limit.Width);
  I := Max(I, Lbl_Level.Width);
  Inc(I, Lbl_Topic.Left + 8);
  J := Edit_Topic.Left + Edit_Topic.Width - I;
  Edit_Topic.Left := I;
  Edit_Topic.Width := J;
  Edit_Limit.Left := I;
  Edit_Limit.Width := J;
  Edit_Level.Left := I;
  Edit_Level.Width := J;
end;

procedure TSlavaNapChannelAttr.Btn_CancelClick(Sender: TObject);
begin
  Close;
end;

procedure TSlavaNapChannelAttr.Btn_OkClick(Sender: TObject);
var
  Str: string;
begin
  Close;
  if not Running then Exit;
  Cmd_List.AddDoubleCmd(MSG_SERVER_TOPIC, 0, Channel + ' ' + Edit_Topic.Text,
    '');
  Cmd_List.AddDoubleCmd(MSG_CLIENT_CHANNEL_LIMIT, 0, Channel + ' ' +
    Edit_Limit.Text, '');
  if Edit_Level.ItemIndex <> -1 then
    Cmd_List.AddDoubleCmd(MSG_CLIENT_SET_CHAN_LEVEL, 0, Channel + ' ' +
      IntToStr(Ord(Edit_Level.ItemIndex)), '');
  if Cb_Registered.Checked then
    Str := ' +REGISTERED'
  else
    Str := ' -REGISTERED';
  if Cb_private.Checked then
    Str := Str + ' +PRIVATE'
  else
    Str := Str + ' -PRIVATE';
  if Cb_Moderated.Checked then
    Str := Str + ' +MODERATED'
  else
    Str := Str + ' -MODERATED';
  if Cb_Topic.Checked then
    Str := Str + ' +TOPIC'
  else
    Str := Str + ' -TOPIC';
  Cmd_List.AddDoubleCmd(MSG_CLIENT_CHANNEL_MODE, 0, Channel + Str, '');
  try
    Edit_Motd.Lines.SaveToFile(ApplicationDir + 'chmotd.' + Channel);
  except
  end;
  Cmd_List.AddDoubleCmd(MSG_CMD_RELOADCHMOTD, 0, Channel, '');
  Cmd_List.AddDoubleCmd(MSG_CMD_LISTCHANNELS, 0, '', '');
end;

end.
