DROP TABLE IF EXISTS ${tblPrefix}LOGIN_LOG;
DROP TABLE IF EXISTS ${tblPrefix}MESSAGE_LOG;
DROP TABLE IF EXISTS ${tblPrefix}AGENT_LIST;
DROP TABLE IF EXISTS ${tblPrefix}LOGIN_LIST;
DROP TABLE IF EXISTS ${tblPrefix}SL_AGENT;
DROP TABLE IF EXISTS ${tblPrefix}USER_INFO;
DROP TABLE IF EXISTS ${tblPrefix}TRANSMIT_QUEUE;
DROP TABLE IF EXISTS ${tblPrefix}CHANNEL_INFO;
DROP TABLE IF EXISTS ${tblPrefix}SEQ_QUEUE_NUMBER;
DROP TABLE IF EXISTS ${tblPrefix}SEQ_USER_NUMBER;
DROP TABLE IF EXISTS ${tblPrefix}SLWEBTUNNEL_SYSTEM;


CREATE TABLE ${tblPrefix}SLWEBTUNNEL_SYSTEM(
	LAST_LOGDUMP DATETIME NOT NULL
) ENGINE = InnoDB DEFAULT CHARACTER SET utf8;
INSERT INTO ${tblPrefix}SLWEBTUNNEL_SYSTEM(LAST_LOGDUMP) VALUES (NOW());

CREATE TABLE ${tblPrefix}SEQ_USER_NUMBER (ID INT NOT NULL);
INSERT INTO ${tblPrefix}SEQ_USER_NUMBER VALUES (0);

CREATE TABLE ${tblPrefix}SEQ_QUEUE_NUMBER (ID INT NOT NULL);
INSERT INTO ${tblPrefix}SEQ_QUEUE_NUMBER VALUES (0);

CREATE TABLE ${tblPrefix}CHANNEL_INFO(
	CHANNEL_NUMBER INTEGER PRIMARY KEY NOT NULL AUTO_INCREMENT, 
	CHANNEL_NAME VARCHAR(100) NOT NULL, 
	LAST_UPDATE DATETIME NOT NULL, 
	LAST_CLEANUP DATETIME NOT NULL, 
	OWNER_ID CHAR(20) UNIQUE NOT NULL, 
	PASSWORD CHAR(50) NOT NULL, 
	UUID CHAR(36)
) ENGINE = InnoDB DEFAULT CHARACTER SET utf8;

CREATE TABLE ${tblPrefix}USER_INFO(
	USER_NUMBER INTEGER PRIMARY KEY NOT NULL AUTO_INCREMENT, 
	USER_ID CHAR(20) UNIQUE NOT NULL, 
	USER_NAME VARCHAR(100) NOT NULL, 
	PASSWORD VARCHAR(50) NOT NULL
) ENGINE = InnoDB DEFAULT CHARACTER SET utf8;

CREATE TABLE ${tblPrefix}SL_AGENT(
	AGENT_NAME CHAR(100) PRIMARY KEY NOT NULL
) ENGINE = InnoDB DEFAULT CHARACTER SET utf8;

CREATE TABLE ${tblPrefix}LOGIN_LIST(
	USER_NUMBER INTEGER NOT NULL, 
	CHANNEL_NUMBER INTEGER NOT NULL, 
	LAST_UPDATE DATETIME NOT NULL, 
	PRIMARY KEY (USER_NUMBER,CHANNEL_NUMBER),
	CONSTRAINT FOREIGN KEY (USER_NUMBER) REFERENCES USER_INFO(USER_NUMBER) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT FOREIGN KEY (CHANNEL_NUMBER)  REFERENCES CHANNEL_INFO(CHANNEL_NUMBER) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE = InnoDB DEFAULT CHARACTER SET utf8;

CREATE TABLE ${tblPrefix}AGENT_LIST(
	AGENT_NAME CHAR(100) NOT NULL, 
	CHANNEL_NUMBER INTEGER NOT NULL, 
	PRIMARY KEY (AGENT_NAME,CHANNEL_NUMBER),
	CONSTRAINT FOREIGN KEY (AGENT_NAME)  REFERENCES SL_AGENT(AGENT_NAME) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT FOREIGN KEY (CHANNEL_NUMBER)  REFERENCES CHANNEL_INFO(CHANNEL_NUMBER) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE = InnoDB DEFAULT CHARACTER SET utf8;

CREATE TABLE ${tblPrefix}MESSAGE_LOG(
	NUMERICAL_ORDER INTEGER PRIMARY KEY NOT NULL AUTO_INCREMENT, 
	USER_NUMBER INTEGER, 
	AGENT_NAME CHAR(100), 
	CHANNEL_NUMBER INTEGER NOT NULL, 
	INSERT_TIME DATETIME NOT NULL, 
	MESSAGE VARCHAR(300) NOT NULL,
	CONSTRAINT FOREIGN KEY (USER_NUMBER)  REFERENCES USER_INFO(USER_NUMBER) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT FOREIGN KEY (AGENT_NAME)  REFERENCES SL_AGENT(AGENT_NAME) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT FOREIGN KEY (CHANNEL_NUMBER)  REFERENCES CHANNEL_INFO(CHANNEL_NUMBER) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE = InnoDB DEFAULT CHARACTER SET utf8;

CREATE TABLE ${tblPrefix}TRANSMIT_QUEUE(
	QUEUE_NUMBER INTEGER PRIMARY KEY NOT NULL, 
	CHANNEL_NUMBER INTEGER NOT NULL, 
	NEXT_QUEUE_NUMBER INTEGER, 
	BODY VARCHAR(2000) NOT NULL, 
	INSERT_DATE DATETIME NOT NULL,
	CONSTRAINT FOREIGN KEY (CHANNEL_NUMBER) REFERENCES CHANNEL_INFO(CHANNEL_NUMBER) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE = InnoDB DEFAULT CHARACTER SET utf8;
