// $Id: SLWebTunnel.lsl 6 2007-12-03 10:26:21Z cattaka $

//Configuration variables
string channelName;
string ownerId;
string tunnelUrl;
string passKey;
string webUrl;

//=================================================================
//valiables for Global
//=================================================================
//valiables for runningState
list userList = [];
list waitingBody;
string sendingBody;
string communicationMode;
list messageList = [];
key httpRequestKey = NULL_KEY;
string receivingQueueNumber;
integer failCount = 0;
float currentUpdateInterval;
integer messageCount;

//valiables for control
key configQueryId;
integer configQueryLine;
integer listenHandle;

//=================================================================
///Parformance Setting
//=================================================================
float RETRY_INTERVAL = 300.0;
integer MAX_FAIL_COUNT = 10;
float SENSOR_RANGE = 20.0;    //default is 20, It's range of Say.
integer MAX_BODY_SIZE = 200;
float MIN_UPDATE_INTERVAL = 10.0;
float MAX_UPDATE_INTERVAL = 60.0;

//=================================================================
///Const
//=================================================================
string CONFIG_FILE = "SLWebTunnel.cfg";
//list HTTP_PARAMS = [HTTP_METHOD,"POST", HTTP_MIMETYPE, "application/x-www-form-urlen
list HTTP_PARAMS = [HTTP_METHOD,"POST"];

//=================================================================
//LSLFLAGS
//=================================================================
string LSLFLAG_USER_REFLESH = "R";
string LSLFLAG_USERNAME = "U";
string LSLFLAG_MESSAGE = "M";
string LSLFLAG_NEXT = "N";
string LSLFLAG_SUCCEED = "S";
string LSLFLAG_FAILED = "F";
string LSLFLAG_END = "E";


//=================================================================
//COMMUNICATION MODE
//=================================================================
string COMMUNICATION_MODE_SEND = "S";
string COMMUNICATION_MODE_RECEIVE = "R";
string COMMUNICATION_MODE_BOTH = "B";

//=================================================================
//Customizable functions
//=================================================================
outputUserList(list arg1){
    string strUserList;
    integer i;
    integer m;
    strUserList = "";
    m = llGetListLength(userList);
    for (i=0;i<m;i++){
        strUserList += llList2String(userList, i);
        if (i+1 < m) {
            strUserList += ",";
        }
    }
    llSetText(
        channelName + "\n"
        + "Members(" + (string)m + ")"
        + strUserList + "\n"
        + "Last update: " + getCurrentTimeString() + "\n"
        , <1,1,1>, 1.0);
}

outputMessage(string userName, string message){
    llSay(0, userName + ":" + message);
}

noteAction(vector noteColor) {
    llParticleSystem([PSYS_PART_FLAGS,
        PSYS_PART_INTERP_SCALE_MASK | PSYS_PART_INTERP_COLOR_MASK |
        PSYS_PART_EMISSIVE_MASK,
        PSYS_SRC_PATTERN, PSYS_SRC_PATTERN_DROP,
        PSYS_SRC_BURST_PART_COUNT, 1,
        PSYS_SRC_BURST_RATE, 1.0,
        PSYS_SRC_BURST_RADIUS, 0.0,
        PSYS_PART_START_ALPHA, 1.0,
        PSYS_PART_END_ALPHA, 1.0,
        PSYS_PART_START_SCALE, <2.0, 2.0, 0>,
        PSYS_PART_END_SCALE, <0.0, 0.0, 0>,
        PSYS_PART_START_COLOR, noteColor,
        PSYS_PART_END_COLOR, noteColor,
        PSYS_PART_MAX_AGE, 1.0,
        PSYS_SRC_MAX_AGE, 0.1]);
}

string getCurrentTimeString() {
    integer sec = (integer)llGetWallclock();
    string result;
    result = (string)(sec/3600) + ":" + (string)((sec%3600)/60) + ":" + (string)(sec % 60);
    return result;
}

//=================================================================
//Functions for System
//=================================================================
key setupTunnel() {
    string requestBody;
    requestBody = escapeString("setupTunnel", ",");
    requestBody += ",," + escapeString(ownerId, ",");
    requestBody += ",," + escapeString(llGetKey(), ",");
    requestBody += ",," + escapeString(passKey, ",");
    requestBody += ",," + escapeString(channelName, ",");

    return llHTTPRequest(tunnelUrl, HTTP_PARAMS, requestBody);
}
createSendingBody() {
    integer i;
    integer m;
    integer bodySize;
    m = llGetListLength(waitingBody);

    bodySize = 0;
    sendingBody = "";
    for (i=0;i<m;i++) {
        string token;
        token = llList2String(waitingBody, i);

        integer tokenSize;
        tokenSize = llStringLength(token);
        if (tokenSize <= MAX_BODY_SIZE) {
            if (bodySize + tokenSize > MAX_BODY_SIZE) {
                waitingBody = llDeleteSubList(waitingBody, 0, i-1);
                jump createSendingBodyBrake;
            }
            sendingBody += token + ",,";
        } else {
            llSay(0, token +  " is ignored. because it is too long");
        }
    }
    waitingBody = [];
    @createSendingBodyBrake;
}
requestTunnel(integer connectFlag) {
    string requestBody;
    if (connectFlag == 0) {
        communicationMode = COMMUNICATION_MODE_BOTH;
        receivingQueueNumber = "";
        createSendingBody();
    } else if (connectFlag == 1) {
        //do nothing
    } else if (connectFlag == 2) {
        integer waitingBodySize = llGetListLength(waitingBody);
        if (receivingQueueNumber != "" && waitingBodySize > 0) {
            communicationMode = COMMUNICATION_MODE_BOTH;
            createSendingBody();
        } else if (waitingBodySize > 0) {
            communicationMode = COMMUNICATION_MODE_SEND;
            receivingQueueNumber = "";
            createSendingBody();
        } else if (receivingQueueNumber != "") {
            communicationMode = COMMUNICATION_MODE_RECEIVE;
            receivingQueueNumber = "";
            sendingBody = "";
        } else {
            // return certainly
            httpRequestKey = NULL_KEY;
            setupSensor();
            return;
        }
    } else {
        // return invalidity
        httpRequestKey = NULL_KEY;
        return;
    }
    
    requestBody = escapeString("tunnel", ",");
    requestBody += ",," + escapeString(ownerId, ",");
    requestBody += ",," + escapeString(llGetKey(), ",");
    requestBody += ",," + escapeString(passKey, ",");
    requestBody += ",," + communicationMode;
    requestBody += ",," + escapeString(receivingQueueNumber, ",");
    requestBody += ",,S,," + sendingBody + "E";
    
    //llOwnerSay((string)connectFlag + " : " +requestBody);
    httpRequestKey = llHTTPRequest(tunnelUrl, HTTP_PARAMS, requestBody);
}

sensorProcess(integer total_number) {
    //llOwnerSay("state_entry:sensor");
    if (httpRequestKey != NULL_KEY) {
        return;
    }
    integer i;
    integer m;
    integer j;
    integer n;
    
    sendingBody = "";
    waitingBody = ["R"];
    
    for (i = 0; i < total_number; i++)
    {
        waitingBody += [escapeString("U" + llDetectedName(i), ",")];
    }
    m = llGetListLength(messageList);
    for (i = 0; i < m; i+=2) {
        string agentKey;
        string agentName;
        string message;
        agentName = llList2String(messageList, i);
        message = llList2String(messageList, i+1);
        
        waitingBody += [escapeString("M" + escapeString(agentName, ":") + "::" + escapeString(message, ":"), ",")];
        @break_rs1;
    }
    messageList = [];
    
    requestTunnel(0);
}

setupSensor() {
    float t;
    t = messageCount + (MAX_UPDATE_INTERVAL / currentUpdateInterval) - 1.0;
    if (t > 0) {
        t = MAX_UPDATE_INTERVAL / t;
        if (t < MIN_UPDATE_INTERVAL) {
            currentUpdateInterval = MIN_UPDATE_INTERVAL;
        } else if (MAX_UPDATE_INTERVAL < t) {
            currentUpdateInterval = MAX_UPDATE_INTERVAL;
        } else {
            currentUpdateInterval = t;
        }
    } else {
        currentUpdateInterval = MAX_UPDATE_INTERVAL;
    }
    messageCount = 0;

    llSensorRepeat("", NULL_KEY, AGENT, SENSOR_RANGE, 2 * PI, currentUpdateInterval);
    //llOwnerSay("U : " + (string)currentUpdateInterval);
}

//Util functions

list parseString(string arg, string delim) {
    list tmpStrs;
    integer l;
    
    tmpStrs = llParseString2List(arg, [delim],[]);
    l = llGetListLength(tmpStrs);
    if (l <= 0){
        return ["",""];
    } else if (l == 1){
        return tmpStrs + [""];
    } else if (l == 2){
        return tmpStrs;
    } else {
        integer i = 0;
        string param;
        string paramValue;
        param = llStringTrim(llList2String(tmpStrs, 0), STRING_TRIM);
        paramValue = llStringTrim(llList2String(tmpStrs, 1), STRING_TRIM);
        for (i = 2;i<l;i++){
            paramValue += delim + llStringTrim(llList2String(tmpStrs, i), STRING_TRIM);
        }
        return [param, paramValue];
    }
}

string escapeString(string arg, string target) {
    list tmpStrs;
    integer i;
    integer m;
    string result;
    tmpStrs = llParseStringKeepNulls(arg, [target],[]);
    m = llGetListLength(tmpStrs);
    
    result = "";
    for (i=0;i<m;i++) {
        result += llList2String(tmpStrs, i);
        if (i+1<m) {
            result += "\\" + target + "\\";
        }
    }
    return result;
}

string replaceString(string arg,string from,string to)
{
    integer pos;
    integer idx;
    integer s;
    pos = llStringLength(from);
    s = llStringLength(to);
    idx = llSubStringIndex(arg,from);
    while(idx!=-1)
    {
        arg = llDeleteSubString(arg, idx, pos + idx - 1);
        arg = llInsertString(arg,idx, to);
        idx = llSubStringIndex(arg, from);
    }
    return arg;
}
//=================================================================
//Status
//=================================================================
default {
    state_entry() {
        noteAction(<1,1,1>);
        llSetText("Click to setup SLWebTunnel", <1,1,1>, 1.0);
    }
    
    touch_start(integer num_detected) {
        if (llDetectedKey(0) == llGetOwner()){
            ownerId = "";
            tunnelUrl = "";
            passKey = "";
            webUrl = "";
            channelName = "";
            configQueryLine = 0;
            configQueryId = llGetNotecardLine(CONFIG_FILE, 0);
        } else {
            llSay(0,"You are not my owner.");
        }
    }
    
    dataserver(key query_id, string data) {
        if (query_id == configQueryId) {
            if (data != EOF) {
                list tmpStrs;
                string param;
                string paramValue;
                tmpStrs = parseString(data, "=");
                param = llStringTrim(llList2String(tmpStrs, 0), STRING_TRIM);
                paramValue = llStringTrim(llList2String(tmpStrs, 1), STRING_TRIM);

                if (param == "channelName") {
                    channelName = paramValue;
                } else if (param == "ownerId") {
                    ownerId = paramValue;
                } else if(param == "tunnelUrl") {
                    tunnelUrl = paramValue;
                } else if(param == "webUrl") {
                    webUrl = paramValue;
                } else if(param == "passKey") {
                    passKey = paramValue;
                }

                ++configQueryLine;
                configQueryId= llGetNotecardLine(CONFIG_FILE, configQueryLine);
            } else {
                if (ownerId == "") {
                    llSay(0, "ERROR : ownerId is not set");
                } else if (tunnelUrl == "") {
                    llSay(0, "ERROR : tunnnelUrl is not set");
                } else if (passKey == "") {
                    llSay(0, "ERROR : passKey is not set");
                } else if (channelName == "") {
                    llSay(0, "ERROR : channelName is not set");
                } else {
                    state setupTunnelState;
                }
            }
        }
    }
}

state setupTunnelState{
    state_entry() {
        llSetText("Setup SLWebTunnel now...", <0,1,0>, 1.0);
        httpRequestKey = setupTunnel();
    }
    state_exit() {
        llSetTimerEvent(0.0);
    }
    on_rez(integer param) {
        state default;
    }
    timer(){
        httpRequestKey = setupTunnel();
    }
    http_response(key request_id, integer status, list metadata, string body)
    {
        if (request_id == httpRequestKey) {
            //llOwnerSay(body);
            httpRequestKey = NULL_KEY;
            if (status != 200) {
                noteAction(<1,1,0>);
                llSetText("status : " + (string)status + "\nSetup is failed. retrying...", <1,1,0>, 1.0);
                llSetTimerEvent(RETRY_INTERVAL);
            } else {
                if (body == LSLFLAG_SUCCEED) {
                    noteAction(<1,1,1>);
                    state runningState;
                } else {
                    noteAction(<1,0,0>);
                    llSetText("Setup is rejected by Server.", <1,0,0>, 1.0);
                    state errorState;
                }
            }
        }
    }
    touch_start(integer num_detected) {
        if (llDetectedKey(0) == llGetOwner()){
            if (httpRequestKey == NULL_KEY){
                llSetTimerEvent(RETRY_INTERVAL);
                httpRequestKey = setupTunnel();
            }
        } else {
            llSay(0,"You are not my owner.");
        }
    }
}

state retrySetupTunnelState {
    state_entry() {
        llSetText("Offline. Retrying setup SLWebTunnel now...", <1,1,0>, 1.0);
        llSetTimerEvent(RETRY_INTERVAL);
    }
    state_exit() {
        llSetTimerEvent(0.0);
    }
    on_rez(integer param) {
        state default;
    }
    timer() {
        state setupTunnelState;
    }
    touch_start(integer num_detected) {
        if (llDetectedKey(0) == llGetOwner()){
            state setupTunnelState;
        } else {
            llSay(0,"You are not my owner.");
        }
    }
}

state errorState{
    state_entry() {
    }
    on_rez(integer param) {
        state default;
    }
    touch_start(integer num_detected) {
        if (llDetectedKey(0) == llGetOwner()){
            state default;
        } else {
            llSay(0,"You are not my owner.");
        }
    }
}

state runningState{
    state_entry() {
        //llOwnerSay("state_entry:runninngState");
        userList = [];
        waitingBody = [];
        sendingBody = "";
        communicationMode = "B";
        messageList = [];
        httpRequestKey = NULL_KEY;
        receivingQueueNumber = "";
        failCount = 0;
        currentUpdateInterval = (MAX_UPDATE_INTERVAL + MIN_UPDATE_INTERVAL) / 2;
        messageCount = 0;

        listenHandle = llListen( 0, "", NULL_KEY, "" );
        llSensor("", NULL_KEY, AGENT, SENSOR_RANGE, 2 * PI);
    }
    state_exit() {
        llListenRemove(listenHandle);
        llSensorRemove();
    }
    on_rez(integer param) {
        state default;
    }
    touch_start(integer num_detected) {
        if (webUrl != "") {
            llSay(0, "My entrance of Web is " + webUrl);
        }
    }

    http_response(key request_id, integer status, list metadata, string body)
    {
        //llOwnerSay("state_entry:httpr_response");
        if (request_id == httpRequestKey) {
            //llOwnerSay(body);
            httpRequestKey = NULL_KEY;
            if (status != 200) {
                llSetText("http error : " + (string)status, <1,1,0>, 1.0);
                noteAction(<1,1,0>);
                failCount += 1;
                if (failCount >= MAX_FAIL_COUNT) {
                    state setupTunnelState;
                }
                requestTunnel(1);
            } else {
                list tokens;
                tokens = llParseString2List(body,[","],[]);
                integer m;
                m = llGetListLength(tokens);
                if (m > 0 && llList2String(tokens, 0) == LSLFLAG_SUCCEED) {
                    sendingBody = "";
                    noteAction(<1,1,1>);
                    integer i;
                    for (i=1;i<m;i++) {
                        string token;
                        string lslflag;
                        string lslbody;
                        token = llList2String(tokens, i);
                        lslflag = llGetSubString(token, 0, 0);
                        lslbody = llGetSubString(token, 1, -1);
                        if (lslflag == LSLFLAG_USER_REFLESH) {
                            userList = [];
                        } else if (lslflag == LSLFLAG_USERNAME) {
                            userList += [llUnescapeURL(lslbody)];
                        } else if (lslflag == LSLFLAG_MESSAGE) {
                            list msgToken;
                            string userName;
                            string message;
                            msgToken = llParseString2List(lslbody,[":"],[]);
                            userName = llUnescapeURL(llList2String(msgToken, 0));
                            message = llUnescapeURL(llList2String(msgToken, 1));
                            messageCount += 1;
                            outputMessage(userName, message);
                        } else if (lslflag == LSLFLAG_NEXT) {
                            receivingQueueNumber = lslbody;
                            jump break;
                        } else if (lslflag == LSLFLAG_END) {
                            receivingQueueNumber = "";
                            jump break;
                        }
                    }
                    @break;
                    failCount = 0;
                    outputUserList(userList);
                    requestTunnel(2);
                } else {
                    noteAction(<1,0,0>);
                    llSetText("Request error.", <1,0,0>, 1.0);
                    state errorState;
                }
            }
        }
    }
    
    listen(integer channel, string name, key id, string message) {
        messageList += [name, message];
        messageCount += 1;
    }

    sensor(integer total_number) {
        sensorProcess(total_number);
    }
    no_sensor() {
        sensorProcess(0);
    }
}
