<?php
/*
 * SlWebTunnel
 * 	Main page
 * $Id: slwebtunnel.php 6 2007-12-03 10:26:21Z cattaka $
 * Created on 2007/10/20
 *
 */
	require_once 'slwebtunnel.ini.php';

 	//preparing grobal valiables
 	$redoFlag = FALSE;
	$displayItems = array();
 	$params = array_merge($_GET, $_POST);
 	
	$command =  $params[PARAM_COMMAND];
	$channelNumber = $params[PARAM_CHANNEL_NUMBER];
	$ownerId = $params[PARAM_OWNER_ID];
	
	//Initialize DataManager
	$dataManager = new SlwtDataManager();
	if (!$dataManager->initialize()) {
	    die(MSG_ERROR_DB_CONNECTION);
	}
	//Checking channelId, if channelNumber is blank, Command is set COMMAND_SELECTCHANNEL 
	if (isBlank($channelNumber)) {
		if ($ownerId) {
			$channelNumber = $dataManager->getChannelNumber($ownerId);
			if ($channelNumber !== FALSE) {
				header("HTTP/1.1 301 Moved Permanently");
				header("Location: " . $_SERVER['SCRIPT_NAME']."?channelNumber=" . $channelNumber);
			} else {
				header("HTTP/1.1 301 Moved Permanently");
				header("Location: " . $_SERVER['SCRIPT_NAME']);
			}
		} else {
			$command = COMMAND_SELECTCHANNEL;
		}
	} else {
		if (isBlank($command)) {
			$command = COMMAND_DISPLAYLOG;
		}
	}

	//do cleanup
	if ($channelNumber != NULL) {
		if ($dataManager->isTimeToCleanup($channelNumber)) {
			$dataManager->beginTransaction();
			$dataManager->execCleanup($channelNumber);
			$dataManager->commit();
		}
	}
	
	if ($dataManager->isTimeToLogDump()) {
		$dataManager->beginTransaction();
		$dataManager->execLogDump();
		$dataManager->commit();
	}
	
	do {
		$redoFlag = FALSE;
		
		//Proccess each page
		if ($command == COMMAND_DISPLAYLOG) {
			$displayItems['USER_LIST'] = $dataManager->getLoginedUserList($channelNumber);
			$displayItems['MESSAGE_LIST'] = $dataManager->getWebLogData($channelNumber, DISPLAY_MESSAGE_NUM);
			$displayItems['AGENT_LIST'] = $dataManager->getLoginedAgentList($channelNumber);
			$displayItems['LAST_UPDATE'] = $dataManager->getChannelInfoLastUpdate($channelNumber);
			$displayItems['LOGIN_FLAG'] = FALSE;
			$displayItems['CHANNEL_NUMBER'] = ($channelNumber);
			includeView($view_dir.VIEW_DISPLAYLOG);
		} elseif ($command == COMMAND_CHAT) {
			session_start();
			$paramMessage = $params[PARAM_MESSAGE];
			$userInfo = $_SESSION[SESSION_USERINFO];
			$redoFlag == FALSE;
			if ($userInfo == NULL) {
				$redoFlag = TRUE;
				$command = COMMAND_LOGOUTPROCESS;
			} else {
				$dataManager->beginTransaction();
				if ($dataManager->updateUserLoginState($channelNumber, $userInfo[USERINFO_USER_NUMBER]) == FALSE) {
					$dataManager->commit();
					$redoFlag = TRUE;
					$command = COMMAND_LOGOUTPROCESS;
				} else {
					$channelNumber = $userInfo['CHANNEL_NUMBER'];
					if (!isBlank($paramMessage)) {
						$dataManager->insertWebMessage($channelNumber, $userInfo[USERINFO_USER_NUMBER], $userInfo[USERINFO_USER_NAME], $paramMessage);
					}
					$dataManager->commit();
					$displayItems['MESSAGE_LIST'] = $dataManager->getWebLogData($channelNumber, DISPLAY_MESSAGE_NUM);
					$displayItems['USER_LIST'] = $dataManager->getLoginedUserList($channelNumber);
					$displayItems['USER_NAME'] = $userInfo[USERINFO_USER_NAME];
					$displayItems['AGENT_LIST'] = $dataManager->getLoginedAgentList($channelNumber);
					$displayItems['LAST_UPDATE'] = $dataManager->getChannelInfoLastUpdate($channelNumber);
					$displayItems['LOGIN_FLAG'] = TRUE;
					$displayItems['CHANNEL_NUMBER'] = ($channelNumber);
					includeView($view_dir.VIEW_DISPLAYLOG);
				}
				
			}
		} elseif ($command == COMMAND_SELECTCHANNEL) {
			$displayItems['CHANNEL_LIST'] = $dataManager->getChannelList();
			includeView($view_dir.VIEW_SELECTCHANNEL);
		} elseif ($command == COMMAND_LOGIN) {
			includeView($view_dir.VIEW_LOGIN);
		} elseif ($command == COMMAND_LOGINPROCESS) {
			$paramUserName = $params[PARAM_USER_NAME];
			$redoFlag = TRUE;
			$command = COMMAND_LOGIN;
			if (!isBlank($paramUserName) && !$dataManager->checkUserNameExistence($channelNumber, $paramUserName)) {
				$dataManager->beginTransaction();
				$newUserId = "USER_".$dataManager->getNextUserNumber();
				if ($dataManager->createUser($newUserId, $paramUserName, "")) {
					$userInfo = $dataManager->loginUser($channelNumber, $newUserId, $_SERVER['REMOTE_ADDR']);
					if ($userInfo) {
						$userInfo[USERINFO_CHANNEL_NUMBER] = $channelNumber;
						session_start();
						$_SESSION[SESSION_USERINFO] = $userInfo;
						$command = COMMAND_CHAT;
					}
				}
				$dataManager->commit();
			}
		} elseif ($command == COMMAND_LOGOUTPROCESS) {
			session_start();
			$redoFlag = TRUE;
			$command = COMMAND_DISPLAYLOG;
			$userInfo = $_SESSION[SESSION_USERINFO];
			if ($userInfo) {
				$dataManager->beginTransaction();
				$dataManager->logoutUser($channelNumber, $userInfo[USERINFO_USER_NUMBER]);
				$dataManager->commit();
				unset($_SESSION[SESSION_USERINFO]);
				session_destroy();
			}
		} else {
			die(MSG_UNKNOWN_COMMAND);
		}
	} while($redoFlag);
	
	$dataManager->dispose();

	/* debug code
 	print_r($_SESSION);
 	print "<br>";
 	print_r($params);
 	*/
?>
