<?php
/*
 * SlWebTunnel
 *  Admin page
 * $Id: slwtadmin.php 6 2007-12-03 10:26:21Z cattaka $
 * Created on 2007/11/06
 *
 */
	require_once 'slwebtunnel.ini.php';

	define('ADMPARM_ADMCMD',			'admcmd');
	define('ADMPARM_ADMPASSKEY',	'admpasskey');
	define('ADMPARM_ACTION',			'action');
	define('ADMPARM_CHANNEL_NUMBER','channelNumber');
	define('ADMPARM_OWNER_ID',		'ownerId');
	define('ADMPARM_PASSKEY',		'passKey');
	define('ADMPARM_LOG_NUMBER',	'logNumber');
	define('ADMPARM_LOG_FILE_NAME',	'logFileName');
	define('ADMPARM_EXEC_FLAG',		'execFlag');
 
	define('ADMCMD_LOGIN',			'login');
	define('ADMCMD_LOGIN_PROCESS',	'loginProcess');
	define('ADMCMD_LOGOUT_PROCESS',	'logoutProcess');
	define('ADMCMD_MENU',			'menu');
	define('ADMCMD_EDIT_CHANNEL',	'editChannel');
	define('ADMCMD_VIEW_LOG',		'viewLog');
	define('ADMCMD_CHECK_CONFIG',	'checkConfig');
	define('ADMCMD_RESET_DB',		'resetDb');
	
	define('ADMACT_ADD',				'add');
	define('ADMACT_DELETE',			'delete');
	define('ADMACT_MODIFY',			'modify');


	//View file
	define('ADMVIEW_LOGIN',			'./admview/admLoginView.php');
	define('ADMVIEW_MENU',			'./admview/admMenuView.php');
	define('ADMVIEW_EDIT_CHANNEL',	'./admview/admEditChannelView.php');
	define('ADMVIEW_VIEW_LOG',		'./admview/admViewLogView.php');
	define('ADMVIEW_CHECK_CONFIG',	'./admview/admCheckConfigView.php');
	define('ADMVIEW_RESET_DB',		'./admview/admResetDbView.php');
		
	session_start();
	
 	//preparing grobal valiables
 	$redoFlag = false;
	$displayItems = array();
	$displayItems['MESSAGE'] = array();
 	$params = array_merge($_GET, $_POST);

	$admcmd =  $params[ADMPARM_ADMCMD];
	$loginFlag = false;
	if (session_id()) {
		if ($_SESSION["LOGIN_FLAG"]) {
			$loginFlag = true;
		}
	}
	
	if ($loginFlag) {
		if (isBlank($admcmd) || $admcmd == ADMCMD_LOGIN || $admcmd == ADMCMD_LOGIN_PROCESS) {
			$admcmd = ADMCMD_MENU;
		}
	} else {
		if ($admcmd != ADMCMD_LOGIN_PROCESS) {
			$admcmd = ADMCMD_LOGIN;
		}
	}
	
	do {
		$redoFlag = false;
		//Proccess each page
		if ($admcmd == ADMCMD_LOGIN) {
			include(ADMVIEW_LOGIN);
		} else if ($admcmd == ADMCMD_LOGIN_PROCESS) {
			$admPassKey = $params[ADMPARM_ADMPASSKEY];
			if ($admPassKey == $adminPassKey) {
				session_start();
				$loginFlag = true;
				$displayItems['MESSAGE'][] = ADMMSG_LOGIN_SUCCEED;
				$_SESSION["LOGIN_FLAG"] = true;
				$admcmd = ADMCMD_MENU;
			} else {
				$admcmd = ADMCMD_LOGIN;
				$displayItems['MESSAGE'][] = ADMMSG_LOGIN_FAILED;
			}
			$redoFlag = true;
		} else if ($admcmd == ADMCMD_LOGOUT_PROCESS) {
			$loginFlag = false;
			session_destroy();
			$admcmd = ADMCMD_LOGIN;
			$redoFlag = true;
		} else if ($admcmd == ADMCMD_MENU) {
			include(ADMVIEW_MENU);
		} else if ($admcmd == ADMCMD_EDIT_CHANNEL) {
			$dataManager = new SlwtDataManager();
			if ($dataManager->initialize()) {
				$action 		= $params[ADMPARM_ACTION];
				$channelNumber 	= $params[ADMPARM_CHANNEL_NUMBER];
				$ownerId 		= $params[ADMPARM_OWNER_ID];
				$passKey 		= $params[ADMPARM_PASSKEY];
				
				if ($action == ADMACT_ADD) {
					if (!isBlank($ownerId) && !isBlank($passKey)) {
						$dataManager->insertChannelInfoForAdmin($ownerId, $passKey);
						$displayItems['MESSAGE'][] = ADMMSG_INSERT_CHANNEL_SUCCEED;
					} else {
						if (isBlank($ownerId)) {
							$displayItems['MESSAGE'][] = ADMMSG_NO_OWNER_ID;
						}
						if (isBlank($passKey)) {
							$displayItems['MESSAGE'][] = ADMMSG_NO_PASSKEY;
						}
					}
				} else if ($action == ADMACT_DELETE) {
					if (!isBlank($channelNumber)) {
						$dataManager->deleteChannelInfoForAdmin($channelNumber);
						$displayItems['MESSAGE'][] = ADMMSG_DELETE_CHANNEL_SUCCEED;
					} else {
						if (isBlank($channelNumber)) {
							$displayItems['MESSAGE'][] = ADMMSG_NO_OWNER_ID;
						}
					}
				} else if ($action == ADMACT_MODIFY) {
					if (!isBlank($channelNumber && !isBlank($ownerId))) {
						$dataManager->updateChannelInfoForAdmin($channelNumber, $ownerId, $passKey);
						$displayItems['MESSAGE'][] = ADMMSG_UPDATE_CHANNEL_SUCCEED;
					} else {
						if (isBlank($channelNumber)) {
							$displayItems['MESSAGE'][] = ADMMSG_NO_CHANNEL_NUMBER;
						}
						if (isBlank($ownerId)) {
							$displayItems['MESSAGE'][] = ADMMSG_NO_OWNER_ID;
						}
					}
				}
				$displayItems['CHANNEL_LIST'] = $dataManager->getChannelInfoForAdmin();
			} else {
				$displayItems['CHANNEL_LIST'] = false;
				$displayItems['MESSAGE'][] = ADMMSG_DB_CONNECTION_FAILED;
			}
			$dataManager->dispose();
			include(ADMVIEW_EDIT_CHANNEL);
		} else if ($admcmd == ADMCMD_VIEW_LOG) {
			$logNumber = $params[ADMPARM_LOG_NUMBER];
			$logFileName = $params[ADMPARM_LOG_FILE_NAME];
			
			$tmps = scandir($logDumpDir);
			$fileList = array();
			foreach($tmps as $tmp) {
				if (ereg('^.*\.log$', $tmp)) {
					$fileList[] = $tmp;
				}
			}
			$displayItems['LOG_FILE_LIST'] = $fileList;
			$displayItems['LOG_CONTENT'] = null;
			if (!isBlank($logNumber) && $fileList[(int)$logNumber] == $logFileName) {
				$displayItems['LOG_CONTENT'] = file($logDumpDir."/".$fileList[(int)$logNumber]);
			}
			
			include(ADMVIEW_VIEW_LOG);
		} else if ($admcmd == ADMCMD_CHECK_CONFIG) {
			$dataManager = new SlwtDataManager();
			$tblResult = $dataManager->checkDatabase();
			foreach($tblResult as $tbl) {
				$displayItems['CHECK_RESULT'][] = $tbl;
			}
			$displayItems['CHECK_RESULT'][] = array(ADMMSG_LOG_DUMP_DIR_EXISTS, file_exists($logDumpDir));
			$displayItems['CHECK_RESULT'][] = array(ADMMSG_LOG_DUMP_DIR_IS_DIR, is_dir($logDumpDir));
			$displayItems['CHECK_RESULT'][] = array(ADMMSG_LOG_DUMP_DIR_WRITABLE, is_writable($logDumpDir));
			
			include(ADMVIEW_CHECK_CONFIG);
		} else if ($admcmd == ADMCMD_RESET_DB) {
			$execFlag = $params[ADMPARM_EXEC_FLAG];
			if ($execFlag) {
				$dataManager = new SlwtDataManager();
				if ($dataManager->initialize()) {
					$sqlResult = $dataManager->initializeDatabase();
					$displayItems['SQL_RESUIT'] = $sqlResult;
					$goflag = true;
					foreach($sqlResult as $r) {
						if ($r[1] === false) {
							$goflag = false;
						}
					}
					if ($goflag) {
						$displayItems['MESSAGE'][] = ADMMSG_RESET_DB_IS_SUCCEED;
					} else {
						$displayItems['MESSAGE'][] = ADMMSG_RESET_DB_IS_FAILED;
					}
				} else {
					$displayItems['SQL_RESUIT'] = null;
					$displayItems['MESSAGE'][] = MSG_ERROR_DB_CONNECTION;
				}
				$dataManager->dispose();
			}
			include(ADMVIEW_RESET_DB);
		}
	} while($redoFlag);

?>
