<?php
/*
 * SlWebTunnel
 * 	Common functions
 * $Id: slwtcommonfunc.php 6 2007-12-03 10:26:21Z cattaka $
 * Created on 2007/10/20
 *
 */
	function isBlank($arg) {
		if ($arg == NULL) {
			return TRUE;
		} else if ($arg == '') {
			return TRUE;
		}
		return FALSE;
	}

	function generateRandomId() {
		return strval(microtime(TRUE));
	}

	class TransmitQueueBuilder{
		var $pdo;
		var $channelNumber;

		var $currentQueueNumber;
		var $buf;
		var $bufLength;
		var $totalLength;
		
		function TransmitQueueBuilder($pdo, $channelNumber) {
			$this->pdo = $pdo;
			$this->channelNumber = $channelNumber;
			$this->currentQueueNumber = $this->pdo->getNextSeqTransmitQueue();
			$this->firstQueueNumber = $this->currentQueueNumber;
			$this->buf = "";
			$this->bufLength = 0;
			$this->totallength = 0;
		}
		function append($arg) {
			$argLength = strlen($arg) + strlen(HTTP_DELIMITER);
			if ($this->bufLength +  $argLength >= MAX_HTTP_SIZE) {
				$this->flushBuffer();
			}
			$this->buf .= $arg.HTTP_DELIMITER; 
			$this->bufLength += $argLength;
			$this->totalLength += $argLength;
		}
		function flushBuffer() {
			if ($this->bufLength > 0) {
				$nextQueueNumber = $this->pdo->getNextSeqTransmitQueue();
				$this->pdo->insertTransmitQueue($this->channelNumber, $this->currentQueueNumber, NULL, $this->buf);
				$this->currentQueueNumber = $nextQueueNumber;
				$this->buf = "";
				$this->bufLength = 0;
			}
		}
		function getTotalLength() {
			return $this->totalLength;
		}
		function getFirstQueueNumber() {
			return $this->firstQueueNumber;
		}
		function dispose() {
			$this->pdo = null;
		}
	}
	
	function escapeString($arg, $target) {
		return str_replace($target, "\\".$target."\\", $arg);
	}

	function unescapeSting($arg, $target) {
		return str_replace("\\".$target."\\", $target, $arg);
	}
	
	function explodeEscaped($arg, $delim) {
		$tmpStrs = explode($delim.$delim, $arg);
		$result = array();

		foreach($tmpStrs as $tmpStr){
			$result[] = unescapeSting($tmpStr, $delim);
		}
		return $result;
	}

	function implodeEscaped($ary, $delim) {
		$tmpStrs = array();
		foreach($ary as $tmpStr){
			$tmpStrs[] = escapeString($tmpStr, $delim);
		}
		return implode($delim.$delim, $tmpStrs);
	}
	function displayMessages() {
		global $displayItems;
		if (count($displayItems['MESSAGE']) > 0) {
			$result = "<font color=\"RED\">\n";
			foreach($displayItems['MESSAGE'] as $message) {
				$result .= $message."<br/>\n";
			}
			$result .= "</font>\n";
			$result .= "<hr/>\n";
			return $result;
		} else {
			return "";
		}
	}
	function outputLog($channelNumber, $ary) {
		global $logDumpEnabled, $logDumpDir, $logDumpFilePrefix;
		if ($logDumpEnabled) {
			$strDate = date("Ymd");
			$fp = fopen($logDumpDir."/".$logDumpFilePrefix.$channelNumber."_".$strDate.".log", "a");
			if ($fp && flock($fp, LOCK_EX)) {
				return fputcsv($fp, $ary, ",");
			}
		}		
	}
	function strDateToTime($str) {
		$ary = strptime($str, "%Y/%m/%d %H:%M:%S");
		return mktime ($ary[tm_hour], $ary[tm_min], $ary[tm_sec], $ary[tm_mon]+1, $ary[tm_mday], $ary[tm_year] + 1900);
	}

	function isMobile() {
		if( preg_match( "/DoCoMo/", $_SERVER['HTTP_USER_AGENT'] ) ) {
			return true;
		} elseif( preg_match( "/J-PHONE/", $_SERVER['HTTP_USER_AGENT'] ) ) {
			return true;
		} elseif( preg_match( "/UP\.Browser/", $_SERVER['HTTP_USER_AGENT'] ) ) {
			return true;
		} else {
			return false;
		}
	}
	
	function includeView($viewFile) {
		global $displayItems, $script, $channelNumber;
		$scriptParams = array();
		if (!isBlank($channelNumber)) {
			$scriptParams[] = PARAM_CHANNEL_NUMBER."=".$channelNumber;
		}
		if (isMobile() & !isBlank(session_id())) {
			$scriptParams[] = "PHPSESSID=".session_id();
		}
	 	$script = htmlspecialchars($_SERVER['PHP_SELF'])."?".implode("&", $scriptParams);
		include($viewFile);
	}
	
?>
