/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.hokudai.meme.core_smart_gs.searcher;

import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jp.ac.hokudai.meme.core_smart_gs.DSCData;
import jp.ac.hokudai.meme.core_smart_gs.InvalidDataFormatException;
import jp.ac.hokudai.meme.core_smart_gs.io.DSCFileLoader5002;
import jp.ac.hokudai.meme.core_smart_gs.io.IDSCFileLoader;
import jp.ac.hokudai.meme.core_smart_gs.searcher.DocumentSearcherDTW;
import jp.ac.hokudai.meme.core_smart_gs.searcher.DocumentSearcherTerasawa;
import jp.ac.hokudai.meme.core_smart_gs.searcher.FoundIndex;
import jp.ac.hokudai.meme.core_smart_gs.searcher.FoundRect;
import jp.ac.hokudai.meme.core_smart_gs.searcher.IDocumentSearcher;
import jp.ac.hokudai.meme.core_smart_gs.searcher.PagedRect;
import jp.ac.hokudai.meme.core_smart_gs.searcher.QueryRect;
import jp.ac.hokudai.meme.core_smart_gs.searcher.ResultIndex;
import jp.ac.hokudai.meme.core_smart_gs.searcher.ResultRects;

public abstract class DocumentSearcher
implements IDocumentSearcher {
    protected List fileList_ = new ArrayList();
    protected IDSCFileLoader loader_ = null;
    protected DSCData dscData_ = new DSCData();
    protected int searcherType_ = -1;
    private static DocumentSearcher searcher_ = null;
    protected int maxFound_ = 10;

    protected DocumentSearcher() {
        this.loader_ = new DSCFileLoader5002();
    }

    public static IDocumentSearcher getInstance(int type) {
        if (searcher_ == null) {
            switch (type) {
                case 1: {
                    searcher_ = new DocumentSearcherTerasawa();
                    break;
                }
                case 2: {
                    searcher_ = new DocumentSearcherDTW(type);
                    break;
                }
                case 3: {
                    searcher_ = new DocumentSearcherDTW(type);
                    break;
                }
            }
        }
        DocumentSearcher.searcher_.searcherType_ = type;
        return searcher_;
    }

    @Override
    public File[] addDscFile(File[] addFileList) throws IOException, InvalidDataFormatException {
        for (int i = 0; i < addFileList.length; ++i) {
            this.loader_.loadDscFile(this.dscData_, addFileList[i]);
            this.fileList_.add(addFileList[i]);
        }
        return this.fileList_.toArray(new File[0]);
    }

    @Override
    public boolean clearFileList() {
        this.fileList_ = new ArrayList();
        this.dscData_ = new DSCData();
        return true;
    }

    @Override
    public boolean hasDscData() {
        return this.dscData_.hasDscData();
    }

    @Override
    public IDocumentSearcher switchSeacher(int type) {
        DocumentSearcher src = this;
        if (src.searcherType_ == type) {
            return src;
        }
        DocumentSearcher dest = (DocumentSearcher)DocumentSearcher.getInstance(type);
        dest.dscData_ = src.dscData_;
        dest.fileList_ = src.fileList_;
        dest.loader_ = src.loader_;
        return dest;
    }

    @Override
    public ResultRects search(QueryRect query) {
        ResultIndex resultindex = this.searchStart(this.dscData_.getDscData(), this.convertRectToIndex(query.getFirstPRect()));
        return this.convertIndexToRect(resultindex);
    }

    @Override
    public int getSearcherType() {
        return this.searcherType_;
    }

    @Override
    public QueryRect rectConfirm(QueryRect queryRect) {
        int[] rectIndexes = this.convertRectToIndex(queryRect.getFirstPRect());
        PagedRect[] pRects = this.dscData_.convertPieceIndexToRect(rectIndexes);
        QueryRect retQRects = new QueryRect();
        for (int i = 0; i < pRects.length; ++i) {
            retQRects.addQueryPRect(pRects[i]);
        }
        return retQRects;
    }

    protected int[] convertRectToIndex(PagedRect prect) {
        int page = prect.getPageIndex();
        Rectangle bigrect = prect.getRect();
        ArrayList<Integer> intary = new ArrayList<Integer>();
        int cumslitnumprevpage = page == 0 ? 0 : this.dscData_.getCumSlitInPage(page - 1);
        Rectangle[] rectary = this.dscData_.getPageRectangle(page);
        for (int i = 0; i < this.dscData_.getSlitInPage(page); ++i) {
            Rectangle rect = rectary[i];
            if (!rect.intersects(bigrect)) continue;
            intary.add(new Integer(cumslitnumprevpage + i));
        }
        int[] converted = new int[intary.size()];
        for (int i = 0; i < converted.length; ++i) {
            converted[i] = (Integer)intary.get(i);
        }
        return converted;
    }

    protected ResultRects convertIndexToRect(ResultIndex ridx) {
        ResultRects rrect = new ResultRects();
        for (int i = 0; i < ridx.size(); ++i) {
            rrect.addResult(this.convertFoundIndexToRect(ridx.get(i)));
        }
        return rrect;
    }

    protected FoundRect convertFoundIndexToRect(FoundIndex fidx) {
        FoundRect frect = new FoundRect(this.dscData_.convertPieceIndexToRect(fidx.indexList_), fidx.score_);
        return frect;
    }

    @Override
    public void setMaxFound(int maxFound) {
        this.maxFound_ = maxFound;
    }

    protected abstract ResultIndex searchStart(double[][] var1, int[] var2);
}

