/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.all_text_search;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import smart_gs.all_text_search.Position;
import smart_gs.all_text_search.SearchAllDialogManager;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.smleditor.swingui.GSTreeTextEditor;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import sml_editor.swingui.EditorTextPane;

public class SearchTextAllDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JLabel jLabel = null;
    private JTextField searchField = null;
    protected GSEditorToolBar gsEditorToolBar;
    protected JFrame editor;
    private JCheckBox caseCheckBox = null;
    private JCheckBox regularCheckBox = null;
    private JCheckBox noWindowCheckBox = null;
    private JLabel jLabel1 = null;
    private JTextField replaceField = null;
    private JButton replaceButton = null;
    private JPanel jPanel = null;
    private JPanel jPanel1 = null;
    private JRadioButton forwardButton = null;
    private JRadioButton backwordButton = null;
    private JButton findButton = null;
    private JButton replaceFindButton = null;
    private JButton replaceAllButton = null;
    private boolean initflg = true;
    private boolean replaceALL = false;
    protected int startposition = -1;
    protected boolean lastsearchway = false;
    protected int lastpoint = -1;
    protected int regexpoing = -1;
    protected int forwardpoint = 0;
    protected int backwardpoint = 0;

    public SearchTextAllDialog(Frame owner, String title) {
        super(owner, title);
        this.initialize();
    }

    private void initialize() {
        this.setSize(471, 196);
        this.setResizable(false);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jLabel = new JLabel();
            this.jLabel.setBounds(new Rectangle(10, 8, 90, 20));
            this.jLabel.setText("Find:");
            this.jLabel1 = new JLabel();
            this.jLabel1.setBounds(new Rectangle(12, 32, 90, 20));
            this.jLabel1.setText("Replace With:");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.jLabel, null);
            this.jContentPane.add((Component)this.getSearchField(), null);
            this.jContentPane.add((Component)this.jLabel1, null);
            this.jContentPane.add((Component)this.getReplaceField(), null);
            this.jContentPane.add((Component)this.getReplaceButton(), null);
            this.jContentPane.add((Component)this.getJPanel(), null);
            this.jContentPane.add((Component)this.getJPanel1(), null);
            this.jContentPane.add((Component)this.getFindButton(), null);
            this.jContentPane.add((Component)this.getReplaceFindButton(), null);
            this.jContentPane.add((Component)this.getReplaceAllButton(), null);
        }
        return this.jContentPane;
    }

    private JTextField getSearchField() {
        if (this.searchField == null) {
            this.searchField = new JTextField();
            this.searchField.setBounds(new Rectangle(105, 8, 355, 20));
        }
        return this.searchField;
    }

    private JCheckBox getCaseCheckBox() {
        if (this.caseCheckBox == null) {
            this.caseCheckBox = new JCheckBox("Case Sensitive", false);
            this.caseCheckBox.setBounds(new Rectangle(203, 137, 150, 14));
        }
        return this.caseCheckBox;
    }

    private JCheckBox getRegularCheckBox() {
        if (this.regularCheckBox == null) {
            this.regularCheckBox = new JCheckBox("Regular expressions", false);
            this.regularCheckBox.setBounds(new Rectangle(46, 131, 150, 14));
        }
        return this.regularCheckBox;
    }

    private JCheckBox getNoWindowCheckBox() {
        if (this.noWindowCheckBox == null) {
            this.noWindowCheckBox = new JCheckBox("No New Windows", false);
            this.noWindowCheckBox.setBounds(new Rectangle(46, 145, 150, 14));
            this.noWindowCheckBox.setSelected(true);
        }
        return this.noWindowCheckBox;
    }

    private JTextField getReplaceField() {
        if (this.replaceField == null) {
            this.replaceField = new JTextField();
            this.replaceField.setBounds(new Rectangle(105, 32, 355, 20));
        }
        return this.replaceField;
    }

    private JButton getReplaceButton() {
        if (this.replaceButton == null) {
            this.replaceButton = new JButton();
            this.replaceButton.setText("Replace");
            this.replaceButton.setBounds(new Rectangle(236, 132, 110, 24));
            this.replaceButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchTextAllDialog.this.replace();
                }
            });
            this.replaceButton.setEnabled(false);
        }
        return this.replaceButton;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(3);
            this.jPanel = new JPanel();
            this.jPanel.setLayout(gridLayout);
            this.jPanel.setBorder(new TitledBorder("Options"));
            this.jPanel.setBounds(new Rectangle(178, 55, 281, 70));
            this.jPanel.add((Component)this.getRegularCheckBox(), null);
            this.jPanel.add((Component)this.getCaseCheckBox(), null);
            this.jPanel.add((Component)this.getNoWindowCheckBox(), null);
        }
        return this.jPanel;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(2);
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(gridLayout);
            this.jPanel1.setBorder(new TitledBorder("Direction"));
            this.jPanel1.setBounds(new Rectangle(9, 55, 164, 70));
            ButtonGroup group = new ButtonGroup();
            this.jPanel1.add((Component)this.getForwardButton(), null);
            this.jPanel1.add((Component)this.getBackwordButton(), null);
            group.add(this.getForwardButton());
            group.add(this.getBackwordButton());
        }
        return this.jPanel1;
    }

    private JRadioButton getForwardButton() {
        if (this.forwardButton == null) {
            this.forwardButton = new JRadioButton();
            this.forwardButton.setText("Forward");
            this.forwardButton.setSelected(true);
            this.forwardButton.setName("forwardButton");
            this.forwardButton.setBounds(new Rectangle(227, 82, 132, 21));
        }
        return this.forwardButton;
    }

    private JRadioButton getBackwordButton() {
        if (this.backwordButton == null) {
            this.backwordButton = new JRadioButton();
            this.backwordButton.setBounds(new Rectangle(226, 96, 116, 21));
            this.backwordButton.setName("backwordButton");
            this.backwordButton.setText("Backward");
        }
        return this.backwordButton;
    }

    private JButton getFindButton() {
        if (this.findButton == null) {
            this.findButton = new JButton();
            this.findButton.setBounds(new Rectangle(10, 132, 110, 24));
            this.findButton.setText("Find");
            this.findButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean searchway = true;
                    if (SearchTextAllDialog.this.forwardButton.isSelected()) {
                        searchway = true;
                    }
                    if (SearchTextAllDialog.this.backwordButton.isSelected()) {
                        searchway = false;
                    }
                    if (SearchTextAllDialog.this.initflg) {
                        if (SearchTextAllDialog.this.gsEditorToolBar != null) {
                            EditorTextPane editorTextPane = SearchTextAllDialog.this.gsEditorToolBar.getEditorTextPane();
                            int ajust = 0;
                            if (SearchTextAllDialog.this.regularCheckBox.isSelected()) {
                                ajust = 1;
                            }
                            if (searchway) {
                                SearchTextAllDialog.this.lastpoint = SearchTextAllDialog.this.startposition = editorTextPane.getSelectionEnd() - ajust;
                                SearchTextAllDialog.this.regexpoing = SearchTextAllDialog.this.startposition;
                                SearchTextAllDialog.this.forwardpoint = SearchTextAllDialog.this.startposition;
                            } else {
                                SearchTextAllDialog.this.lastpoint = SearchTextAllDialog.this.startposition = editorTextPane.getSelectionStart() - 1;
                                SearchTextAllDialog.this.regexpoing = SearchTextAllDialog.this.startposition;
                                SearchTextAllDialog.this.backwardpoint = SearchTextAllDialog.this.startposition;
                            }
                        }
                        SearchTextAllDialog.this.initflg = false;
                    }
                    if (!SearchTextAllDialog.this.search(searchway, null, false)) {
                        if (searchway) {
                            SearchTextAllDialog.this.save();
                            SearchAllDialogManager.next(null);
                        } else {
                            SearchTextAllDialog.this.save();
                            SearchAllDialogManager.prev(null);
                        }
                    } else if (!SearchTextAllDialog.this.editor.isVisible()) {
                        SearchTextAllDialog.this.editor.setLocationByPlatform(true);
                        SearchTextAllDialog.this.editor.setVisible(true);
                    }
                }
            });
        }
        return this.findButton;
    }

    private JButton getReplaceFindButton() {
        if (this.replaceFindButton == null) {
            this.replaceFindButton = new JButton();
            this.replaceFindButton.setText("Replace/Find");
            this.replaceFindButton.setBounds(new Rectangle(123, 132, 110, 24));
            this.replaceFindButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean searchway = true;
                    if (SearchTextAllDialog.this.forwardButton.isSelected()) {
                        searchway = true;
                    }
                    if (SearchTextAllDialog.this.backwordButton.isSelected()) {
                        searchway = false;
                    }
                    if (SearchTextAllDialog.this.initflg) {
                        if (SearchTextAllDialog.this.gsEditorToolBar != null) {
                            EditorTextPane editorTextPane = SearchTextAllDialog.this.gsEditorToolBar.getEditorTextPane();
                            int ajust = 0;
                            if (SearchTextAllDialog.this.regularCheckBox.isSelected()) {
                                ajust = 1;
                            }
                            if (searchway) {
                                SearchTextAllDialog.this.lastpoint = SearchTextAllDialog.this.startposition = editorTextPane.getSelectionEnd() - ajust;
                                SearchTextAllDialog.this.regexpoing = SearchTextAllDialog.this.startposition;
                                SearchTextAllDialog.this.forwardpoint = SearchTextAllDialog.this.startposition;
                            } else {
                                SearchTextAllDialog.this.lastpoint = SearchTextAllDialog.this.startposition = editorTextPane.getSelectionStart() - 1;
                                SearchTextAllDialog.this.regexpoing = SearchTextAllDialog.this.startposition;
                                SearchTextAllDialog.this.backwardpoint = SearchTextAllDialog.this.startposition;
                            }
                        }
                        SearchTextAllDialog.this.initflg = false;
                    }
                    String replace = SearchTextAllDialog.this.replaceField.getText();
                    SearchTextAllDialog.this.replace();
                    replace = null;
                    if (SearchTextAllDialog.this.gsEditorToolBar != null) {
                        EditorTextPane editorTextPane = SearchTextAllDialog.this.gsEditorToolBar.getEditorTextPane();
                        int ajust = 0;
                        if (SearchTextAllDialog.this.regularCheckBox.isSelected()) {
                            ajust = 1;
                        }
                        if (searchway) {
                            SearchTextAllDialog.this.lastpoint = SearchTextAllDialog.this.startposition = editorTextPane.getSelectionEnd() - ajust;
                            SearchTextAllDialog.this.regexpoing = SearchTextAllDialog.this.startposition;
                            SearchTextAllDialog.this.forwardpoint = SearchTextAllDialog.this.startposition;
                        } else {
                            SearchTextAllDialog.this.lastpoint = SearchTextAllDialog.this.startposition = editorTextPane.getSelectionStart() - 1;
                            SearchTextAllDialog.this.regexpoing = SearchTextAllDialog.this.startposition;
                            SearchTextAllDialog.this.backwardpoint = SearchTextAllDialog.this.startposition;
                        }
                    }
                    if (!SearchTextAllDialog.this.search(searchway, replace, false)) {
                        if (searchway) {
                            SearchTextAllDialog.this.save();
                            SearchAllDialogManager.next(replace);
                        } else {
                            SearchTextAllDialog.this.save();
                            SearchAllDialogManager.prev(replace);
                        }
                    } else if (!SearchTextAllDialog.this.editor.isVisible()) {
                        SearchTextAllDialog.this.editor.setLocationByPlatform(true);
                        SearchTextAllDialog.this.editor.setVisible(true);
                    }
                }
            });
        }
        return this.replaceFindButton;
    }

    private JButton getReplaceAllButton() {
        if (this.replaceAllButton == null) {
            this.replaceAllButton = new JButton();
            this.replaceAllButton.setText("Replace All");
            this.replaceAllButton.setBounds(new Rectangle(350, 132, 110, 24));
            this.replaceAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String replace = SearchTextAllDialog.this.replaceField.getText();
                    SearchTextAllDialog.this.startposition = -1;
                    SearchTextAllDialog.this.lastpoint = -1;
                    SearchTextAllDialog.this.regexpoing = -1;
                    if (SearchTextAllDialog.this.noWindowCheckBox.isSelected()) {
                        SearchAllDialogManager.relaceallnonewwindows(replace);
                    } else if (SearchTextAllDialog.this.regularCheckBox.isSelected()) {
                        Thread thread = new Thread(new ReplaceALLThrad(replace, 1));
                        thread.start();
                    } else {
                        Thread thread = new Thread(new ReplaceALLThrad(replace, 0));
                        thread.start();
                    }
                }
            });
        }
        return this.replaceAllButton;
    }

    public void setEditor(JFrame editor, GSEditorToolBar gsEditorToolBar) {
        this.editor = editor;
        this.gsEditorToolBar = gsEditorToolBar;
        this.startposition = -1;
        this.lastsearchway = false;
        this.lastpoint = -1;
        this.forwardpoint = 0;
        this.backwardpoint = 0;
        this.regexpoing = -1;
        this.initflg = true;
    }

    public GSEditorToolBar getGSEditorToolBar() {
        return this.gsEditorToolBar;
    }

    public boolean search(boolean searchway, String replace, boolean isTextReplaceAll) {
        boolean find = false;
        if (this.gsEditorToolBar != null) {
            EditorTextPane editorTextPane;
            String searchStr = this.searchField.getText();
            if (!searchStr.equals("") && (editorTextPane = this.gsEditorToolBar.getEditorTextPane()) != null) {
                String searchText = null;
                if (this.gsEditorToolBar.getMode() == 0 || this.gsEditorToolBar.getMode() == 1) {
                    searchText = editorTextPane.getPainText();
                } else if (this.gsEditorToolBar.getMode() == 2) {
                    searchText = editorTextPane.getSource();
                }
                searchText = searchText == null ? "" : searchText.replaceAll("\r", "");
                if (this.regularCheckBox.isSelected()) {
                    if (!this.caseCheckBox.isSelected()) {
                        searchText = searchText.toLowerCase();
                    }
                    find = this.searchRegex(editorTextPane, searchText, searchStr, searchway, replace);
                } else {
                    find = this.searchText(editorTextPane, searchText, searchStr, searchway, this.caseCheckBox.isSelected(), replace, isTextReplaceAll);
                }
            }
            this.lastsearchway = searchway;
        }
        return find;
    }

    protected void replace() {
        String searchStr;
        if (this.gsEditorToolBar != null && !(searchStr = this.searchField.getText()).equals("")) {
            EditorTextPane editorTextPane = this.gsEditorToolBar.getEditorTextPane();
            String replaceTerm = this.replaceField.getText();
            editorTextPane.setReplaceSelection(replaceTerm);
            this.backwardpoint = this.forwardpoint = editorTextPane.getSelectionEnd();
            this.regexpoing = this.forwardpoint;
        }
    }

    protected boolean searchText(EditorTextPane editorTextPane, String searchText, String searchStr, boolean searchway, boolean bCaseSensitive, String replaceStr, boolean isTextReplaceAll) {
        boolean find = false;
        if (searchway) {
            int nextpoition;
            if (this.startposition == -1) {
                this.startposition = 0;
                if (!this.lastsearchway) {
                    this.lastsearchway = true;
                }
            }
            if (!this.lastsearchway) {
                this.startposition = this.lastpoint;
            }
            if ((nextpoition = editorTextPane.findText(searchStr, replaceStr, bCaseSensitive, this.startposition, searchway)) != -1 && this.lastpoint == nextpoition) {
                this.startposition = nextpoition - searchStr.length() - 1;
                nextpoition = editorTextPane.findText(searchStr, replaceStr, bCaseSensitive, this.startposition, searchway);
            }
            if (nextpoition == -1) {
                find = false;
            } else {
                this.startposition = nextpoition + 1;
                this.lastpoint = nextpoition - searchStr.length();
                this.replaceButton.setEnabled(true);
                this.replaceFindButton.setEnabled(true);
                find = true;
            }
        } else {
            if (this.startposition == -1) {
                this.startposition = searchText.length();
            } else if (this.lastsearchway) {
                this.startposition = this.lastpoint;
                if (this.startposition < searchStr.length() - 1) {
                    this.startposition = searchText.length();
                }
            }
            int nextpoition = editorTextPane.findText(searchStr, replaceStr, bCaseSensitive, this.startposition, searchway);
            if (nextpoition != -1 && this.lastpoint == nextpoition) {
                this.startposition = this.lastpoint - searchStr.length() + 1;
                nextpoition = editorTextPane.findText(searchStr, replaceStr, bCaseSensitive, this.startposition, searchway);
            }
            if (nextpoition == -1) {
                find = false;
            } else {
                this.startposition = nextpoition - searchStr.length();
                this.lastpoint = nextpoition + searchStr.length();
                this.replaceButton.setEnabled(true);
                this.replaceFindButton.setEnabled(true);
                find = true;
            }
        }
        return find;
    }

    protected boolean searchRegex(EditorTextPane editorTextPane, String searchText, String searchStr, boolean searchway, String replace) {
        boolean find = false;
        Position position = null;
        try {
            Pattern p = Pattern.compile(searchStr);
            String text = null;
            if (this.regexpoing == -1) {
                text = searchText;
                this.regexpoing = searchway ? 0 : text.length();
            } else if (searchway) {
                if (!this.lastsearchway) {
                    this.regexpoing = this.forwardpoint;
                }
            } else if (this.lastsearchway) {
                this.regexpoing = this.backwardpoint;
            }
            try {
                text = searchway ? searchText.substring(this.regexpoing, searchText.length()) : searchText.substring(0, this.regexpoing);
            }
            catch (Exception e) {
                return false;
            }
            Matcher m = p.matcher(text);
            if (searchway) {
                if (m.find()) {
                    position = new Position(m.start() + 1, m.end() + 1);
                }
                if (position != null) {
                    if (replace != null) {
                        int pos = editorTextPane.setReplaceSelection(this.regexpoing + position.getStart(), this.regexpoing + position.getEnd(), replace);
                        this.forwardpoint = this.regexpoing = pos - 1;
                        this.backwardpoint = this.regexpoing - (pos - 1);
                    } else {
                        editorTextPane.setSelection(this.regexpoing + position.getStart(), this.regexpoing + position.getEnd());
                        this.regexpoing += position.getEnd() - 1;
                        this.forwardpoint = this.regexpoing;
                        this.backwardpoint = this.regexpoing - (position.getEnd() - 1);
                    }
                    find = true;
                    this.replaceButton.setEnabled(true);
                    this.replaceFindButton.setEnabled(true);
                } else {
                    this.startposition = -1;
                    this.regexpoing = 0;
                    this.forwardpoint = 0;
                    this.backwardpoint = 0;
                    editorTextPane.setSelection(0, 0);
                    this.replaceButton.setEnabled(false);
                    this.replaceFindButton.setEnabled(false);
                }
            } else {
                while (m.find()) {
                    position = new Position(m.start() + 1, m.end() + 1);
                }
                if (position != null) {
                    if (replace != null) {
                        int pos = editorTextPane.setReplaceSelection(position.getStart(), position.getEnd(), replace);
                        this.regexpoing = pos + replace.length();
                        this.forwardpoint = pos;
                        this.backwardpoint = this.regexpoing;
                    } else {
                        editorTextPane.setSelection(position.getStart(), position.getEnd());
                        this.regexpoing = position.getStart() - 1;
                        this.forwardpoint = position.getEnd() - 1;
                        this.backwardpoint = this.regexpoing;
                    }
                    find = true;
                    this.replaceButton.setEnabled(true);
                    this.replaceFindButton.setEnabled(true);
                } else {
                    this.startposition = -1;
                    this.regexpoing = 0;
                    this.forwardpoint = 0;
                    this.backwardpoint = 0;
                    editorTextPane.setSelection(0, 0);
                    this.replaceButton.setEnabled(false);
                    this.replaceFindButton.setEnabled(false);
                }
            }
        }
        catch (Exception e) {
            editorTextPane.setSelection(0, 0);
            this.startposition = -1;
        }
        return find;
    }

    protected boolean regexReplaceAll() {
        EditorTextPane editorTextPane;
        String searchStr;
        boolean find = false;
        if (this.gsEditorToolBar != null && !(searchStr = this.searchField.getText()).equals("") && (editorTextPane = this.gsEditorToolBar.getEditorTextPane()) != null) {
            String searchText = null;
            int ajust = 1;
            if (this.gsEditorToolBar.getMode() == 0 || this.gsEditorToolBar.getMode() == 1) {
                searchText = editorTextPane.getPainText();
            } else if (this.gsEditorToolBar.getMode() == 2) {
                ajust = 0;
                searchText = editorTextPane.getSource();
            }
            searchText = searchText == null ? "" : searchText.replaceAll("\r", "");
            String replaceTerm = this.replaceField.getText();
            Position position = null;
            try {
                Pattern p = Pattern.compile(searchStr);
                String text = null;
                if (this.regexpoing == -1) {
                    text = searchText;
                    this.regexpoing = 0;
                }
                if (this.regexpoing == 0) {
                    text = searchText;
                } else if (this.regexpoing >= searchText.length()) {
                    text = searchText;
                    this.regexpoing = 0;
                } else {
                    text = searchText.substring(this.regexpoing, searchText.length());
                }
                Matcher m = p.matcher(text);
                if (m.find()) {
                    position = new Position(m.start() + ajust, m.end() + ajust);
                }
                if (position != null) {
                    int pos = editorTextPane.setReplaceSelection(this.regexpoing + position.getStart(), this.regexpoing + position.getEnd(), replaceTerm);
                    this.regexpoing = pos - 1;
                    find = true;
                } else {
                    this.startposition = -1;
                    this.regexpoing = 0;
                    this.forwardpoint = 0;
                    this.backwardpoint = 0;
                    editorTextPane.setSelection(0, 0);
                }
            }
            catch (Exception e) {
                editorTextPane.setSelection(0, 0);
                this.startposition = -1;
                this.forwardpoint = 0;
                this.backwardpoint = 0;
            }
        }
        return find;
    }

    public void setSearchTextField(String text) {
        this.searchField.setText(text);
    }

    public String getSearchTextField() {
        return this.searchField.getText();
    }

    public void setReplaceTextField(String text) {
        this.replaceField.setText(text);
    }

    public String getReplaceTextField() {
        return this.replaceField.getText();
    }

    public void setRegularCheckBox(boolean check) {
        this.regularCheckBox.setSelected(check);
    }

    public boolean isRegularCheckBox() {
        return this.regularCheckBox.isSelected();
    }

    public void setCaseCheckBox(boolean check) {
        this.caseCheckBox.setSelected(check);
    }

    public boolean isCaseCheckBox() {
        return this.caseCheckBox.isSelected();
    }

    public boolean isForwardButton() {
        return this.forwardButton.isSelected();
    }

    public boolean isBackwordButton() {
        return this.backwordButton.isSelected();
    }

    public void clearselect() {
        if (this.gsEditorToolBar != null) {
            EditorTextPane editorTextPane = this.gsEditorToolBar.getEditorTextPane();
            editorTextPane.setSelection(0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save() {
        JFrame jFrame = this.editor;
        synchronized (jFrame) {
            if (this.editor != null) {
                if (this.editor instanceof GSEditor) {
                    ((GSEditor)this.editor).getSMLTabbedPane().save();
                } else if (this.editor instanceof GSTreeTextEditor) {
                    ((GSTreeTextEditor)this.editor).getGSEditorTextPane().save();
                }
            }
        }
    }

    public boolean isReplaceALL() {
        return this.replaceALL;
    }

    class ReplaceALLThrad
    implements Runnable {
        protected String replace;
        protected int mode = 0;

        public ReplaceALLThrad(String replace, int mode) {
            this.replace = replace;
            this.mode = mode;
        }

        @Override
        public void run() {
            SearchAllDialogManager.setstart();
            while (SearchAllDialogManager.nextrelaceall()) {
                SearchTextAllDialog.this.startposition = -1;
                do {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } while (SearchTextAllDialog.this.editor == null || !(SearchTextAllDialog.this.editor instanceof GSEditor ? ((GSEditor)SearchTextAllDialog.this.editor).isOpened() == 1 || ((GSEditor)SearchTextAllDialog.this.editor).isOpened() == 2 : SearchTextAllDialog.this.editor instanceof GSTreeTextEditor && (((GSTreeTextEditor)SearchTextAllDialog.this.editor).isOpened() == 1 || ((GSTreeTextEditor)SearchTextAllDialog.this.editor).isOpened() == 2)));
                if (this.mode == 0) {
                    while (SearchTextAllDialog.this.search(true, this.replace, true)) {
                        SearchTextAllDialog.this.save();
                    }
                } else {
                    while (SearchTextAllDialog.this.regexReplaceAll()) {
                        SearchTextAllDialog.this.save();
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class SearchThrad
    implements Runnable {
        protected String replace;
        protected int mode = 0;

        public SearchThrad(String replace, int mode) {
            this.replace = replace;
            this.mode = mode;
        }

        @Override
        public void run() {
            SearchTextAllDialog.this.startposition = -1;
            while (SearchTextAllDialog.this.editor == null || !(SearchTextAllDialog.this.editor instanceof GSEditor ? ((GSEditor)SearchTextAllDialog.this.editor).isOpened() == 1 || ((GSEditor)SearchTextAllDialog.this.editor).isOpened() == 2 : SearchTextAllDialog.this.editor instanceof GSTreeTextEditor && (((GSTreeTextEditor)SearchTextAllDialog.this.editor).isOpened() == 1 || ((GSTreeTextEditor)SearchTextAllDialog.this.editor).isOpened() == 2))) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.mode == 0) {
                while (SearchTextAllDialog.this.search(true, this.replace, true)) {
                    SearchTextAllDialog.this.save();
                }
            } else {
                while (SearchTextAllDialog.this.regexReplaceAll()) {
                    SearchTextAllDialog.this.save();
                }
            }
        }
    }
}

