/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.connection;

import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JDialog;
import smart_gs.reasoning_web.logical.GS_RWElement;

public abstract class AbstractLinkDialog
extends JDialog
implements ComponentListener,
MouseListener,
MouseMotionListener {
    public static final int LINK = 0;
    public static final int JUMP = 1;
    protected Image image;
    protected Point drawPoint;

    protected AbstractLinkDialog(Frame owner, String title) {
        super(owner, title);
        this.addComponentListener(this);
        this.toFront();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setSize(400, 200);
    }

    public abstract void setLinkableElement(GS_RWElement var1);

    public abstract void notifyRelease(GS_RWElement var1, Point var2);

    protected abstract void finish();

    public void notifyPaint(Image image, Point p) {
        this.image = image;
        this.drawPoint = p;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.image != null && this.drawPoint != null) {
            g.drawImage(this.image, this.drawPoint.x, this.drawPoint.y, this);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.finish();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.image = null;
        this.drawPoint = null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.drawPoint = null;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

