/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool.drawing_mode;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.drawing_mode.DefaultDrawingMode;
import smart_gs.drawing_tool.drawing_mode.DrawingModeAdapter;
import smart_gs.drawing_tool.drawing_mode.Mode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.view.RectangleView;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.region.RectangleRegion;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.util.ImageToolBarSetModeByMouseEvent;

public class RectangleMode
extends DrawingModeAdapter {
    private Component startcomponent = null;
    private boolean out = false;
    private static Mode singleton = new RectangleMode();
    private Point2D start;
    private Point2D end;
    private boolean temporary = false;

    public static Mode getInstance() {
        ((RectangleMode)singleton).reset();
        return singleton;
    }

    private void reset() {
        this.startcomponent = null;
        this.out = false;
        this.start = null;
        this.end = null;
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    @Override
    public void setTemporary(boolean sw) {
        this.temporary = sw;
    }

    @Override
    public void mouseEntered(GSMouseEvent e, SpreadCanvas canvas) {
        if (this.startcomponent == null) {
            this.startcomponent = e.getComponent();
        }
        this.out = e.getComponent() != this.startcomponent;
        this.setCursor(canvas);
    }

    @Override
    public void mousePressed(GSMouseEvent e, SpreadCanvas canvas) {
        if (this.startcomponent == null) {
            this.startcomponent = e.getComponent();
        }
        super.mousePressed(e, canvas);
        this.start = e.getPoint();
        this.setCursor(canvas);
    }

    @Override
    public void mouseDragged(GSMouseEvent e, SpreadCanvas canvas) {
        if (e.getComponent() != this.startcomponent) {
            return;
        }
        super.mouseDragged(e, canvas);
        this.end = e.getPoint();
        this.setCursor(canvas);
    }

    @Override
    public void mouseMoved(GSMouseEvent e, SpreadCanvas canvas) {
        if (this.startcomponent == null) {
            this.startcomponent = e.getComponent();
        }
        if (e.getComponent() != this.startcomponent) {
            this.out = true;
            return;
        }
        this.out = false;
        if (this.startcomponent != null && e.getComponent() != this.startcomponent) {
            return;
        }
        this.setCursor(canvas);
    }

    @Override
    public void mouseReleased(GSMouseEvent e, SpreadCanvas canvas) {
        super.mouseReleased(e, canvas);
        if (this.start == null || this.end == null) {
            return;
        }
        if (this.end.getX() - this.start.getX() > 10.0 && this.end.getY() - this.start.getY() > 10.0) {
            RectangleRegion reg = new RectangleRegion(canvas.getSpread(), this.adjustRect(this.start.getX(), this.start.getY()));
            reg.setTemporary(this.isTemporary());
            canvas.addRegion(reg);
        }
        this.start = null;
        this.end = null;
        DefaultState.getInstance().setMode(DefaultDrawingMode.getInstance());
        new ImageToolBarSetModeByMouseEvent().setMode(e, ImageToolBar.modeNone);
        this.setCursor(canvas);
    }

    @Override
    public void paint(Graphics g, SpreadCanvas canvas) {
        if (this.out) {
            return;
        }
        super.paint(g, canvas);
        if (this.start == null || this.end == null) {
            return;
        }
        double ratio = canvas.getImageLabel().getRatio();
        double gapX = canvas.getImageLabel().getGapWidth();
        double gapY = canvas.getImageLabel().getGapHeight();
        View view = new RectangleView(this.adjustRect(this.start.getX(), this.start.getY())).enlargedView(ratio, gapX, gapY);
        view.draw((Graphics2D)g);
    }

    private Rectangle2D adjustRect(double sx, double sy) {
        double height;
        double startY;
        double width;
        double startX;
        if (this.start.getX() > this.end.getX()) {
            startX = this.end.getX();
            width = this.start.getX() - this.end.getX();
        } else {
            startX = this.start.getX();
            width = this.end.getX() - this.start.getX();
        }
        if (this.start.getY() > this.end.getY()) {
            startY = this.end.getY();
            height = this.start.getY() - this.end.getY();
        } else {
            startY = this.start.getY();
            height = this.end.getY() - this.start.getY();
        }
        return new Rectangle2D.Double(startX, startY, width, height);
    }
}

