/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.image_search;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import smart_gs.image_search.logical.GSQuery;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.logical.Spread;
import sml_editor.logical.LineDirection;

public class LineImageCropper {
    protected int MARGIN_WIDTH = 50;
    protected int MARGIN_HEIGHT = 50;
    private int WIDTH;
    private int HEIGHT;
    private Spread spread;
    private Rectangle2D rect;
    protected Color grayColor;
    private int x;
    private int y;

    public LineImageCropper(SearchResult result) {
        this(result.getSpread(), result.getRectangle());
    }

    public LineImageCropper(GSQuery result) {
        this(result.getSpread(), result.getRectangle());
    }

    public LineImageCropper(Spread spread, Rectangle2D rect) {
        this.spread = spread;
        this.rect = rect;
        Color color = Color.GRAY.brighter();
        this.grayColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
    }

    public BufferedImage crop() {
        Image image = this.spread.getImage();
        if (this.spread.getLineDirection() == LineDirection.HORIZONTAL) {
            this.WIDTH = 600;
            this.HEIGHT = 60;
            int height = (int)this.rect.getHeight();
            this.x = (int)this.rect.getX() - this.MARGIN_WIDTH * 2;
            if (this.x < 0) {
                this.x = 0;
            }
            this.y = (int)this.rect.getY();
            BufferedImage bufImage = new BufferedImage(this.WIDTH, this.HEIGHT, 1);
            Graphics offg = bufImage.getGraphics();
            offg.drawImage(image, 0, 0, this.WIDTH, this.HEIGHT, this.x, this.y, this.x + this.WIDTH, this.y + height, null);
            return bufImage;
        }
        this.HEIGHT = 600;
        this.WIDTH = 60;
        int width = (int)this.rect.getWidth();
        this.y = (int)this.rect.getY() - this.MARGIN_HEIGHT * 2;
        if (this.y < 0) {
            this.y = 0;
        }
        this.x = (int)this.rect.getX();
        BufferedImage bufImage = new BufferedImage(this.WIDTH, this.HEIGHT, 1);
        Graphics offg = bufImage.getGraphics();
        offg.drawImage(image, 0, 0, this.WIDTH, this.HEIGHT, this.x, this.y, this.x + width, this.y + this.HEIGHT, null);
        return bufImage;
    }

    public Image fillRelative(BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage bImage = new BufferedImage(w, h, 1);
        Graphics og = bImage.getGraphics();
        og.drawImage(image, 0, 0, w, h, null);
        og.setColor(this.grayColor);
        og.fillRect((int)this.rect.getX() - this.x, (int)this.rect.getY() - this.y, (int)this.rect.getWidth(), (int)this.rect.getHeight());
        return bImage;
    }

    public Image fillGray(BufferedImage image, Rectangle rectangle) {
        BufferedImage bImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        Graphics og = bImage.getGraphics();
        og.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
        og.setColor(this.grayColor);
        og.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        return bImage;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.spread.release();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }
}

