/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.image_search.normal.swingui;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.image_search.normal.swingui.CheckAction;
import smart_gs.image_search.normal.swingui.RemoveAction;
import smart_gs.image_search.normal.swingui.SearchResultPanelOfSegmentMode;
import smart_gs.image_search.normal.swingui.SearchResultViewer;
import smart_gs.logical.Spread;
import sml_editor.logical.LineDirection;

public abstract class AbstractSearchResultPanel
extends JPanel {
    protected List<SearchResult> results;
    protected List<JPanel> previousResults;
    protected List<JPanel> nextResults;
    protected List<JPanel> currentResults;
    protected int SIZE_TO_DISPLAY = 20;
    protected int count = 0;
    protected int nextCount;
    protected boolean isFirst = true;
    protected Thread nextThread = null;
    protected SearchResultViewer parent;
    protected Image queryImage;
    protected LineDirection lineDirection;

    public AbstractSearchResultPanel(SearchResultViewer parent, List<SearchResult> results, Image queryImage, LineDirection lineDirection) {
        this.parent = parent;
        this.results = results;
        this.previousResults = new ArrayList<JPanel>();
        this.nextResults = new ArrayList<JPanel>();
        this.currentResults = new ArrayList<JPanel>();
        this.queryImage = queryImage;
        this.lineDirection = lineDirection;
    }

    public void showResult(List<JPanel> list) {
        this.removeAll();
        if (this.nextThread.isAlive()) {
            try {
                this.nextThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            this.add(list.get(i));
        }
        this.currentResults.clear();
        this.currentResults.addAll(this.nextResults);
    }

    public void next() {
        ++this.count;
        this.nextCount = this.count + 1;
        this.showResult(this.nextResults);
        this.createNextResults(this.nextCount);
    }

    public void back() {
        --this.count;
        this.nextCount = this.count + 1;
        if (this.nextThread.isAlive()) {
            this.nextThread.interrupt();
        }
        this.createNextResults(this.count);
        this.showResult(this.nextResults);
        this.createNextResults(this.nextCount);
    }

    public synchronized void createNextResults(final int count) {
        this.nextThread = new Thread(){

            @Override
            public void run() {
                super.run();
                int beginIndex = count * AbstractSearchResultPanel.this.SIZE_TO_DISPLAY;
                AbstractSearchResultPanel.this.nextResults.clear();
                for (int i = beginIndex; i < beginIndex + AbstractSearchResultPanel.this.SIZE_TO_DISPLAY && i < AbstractSearchResultPanel.this.results.size(); ++i) {
                    JPanel labelPanel = new JPanel();
                    JPanel checkBoxPanel = AbstractSearchResultPanel.this.lineDirection == LineDirection.HORIZONTAL ? new JPanel(new GridLayout(2, 1)) : new JPanel(new GridLayout(3, 1));
                    ButtonGroup g = new ButtonGroup();
                    JCheckBox checkBox = new JCheckBox("Yes");
                    JCheckBox removeBox = new JCheckBox("No");
                    g.add(checkBox);
                    g.add(removeBox);
                    JLabel newLabel = new JLabel("");
                    if (AbstractSearchResultPanel.this.results.get(i).isInBucket()) {
                        newLabel.setIcon(new ImageIcon("./icons/copy.gif"));
                    } else if (!AbstractSearchResultPanel.this.results.get(i).wasShown()) {
                        newLabel.setIcon(new ImageIcon("./icons/new.gif"));
                    }
                    checkBox.addItemListener(new CheckAction(AbstractSearchResultPanel.this.parent, AbstractSearchResultPanel.this.results.get(i)));
                    removeBox.addItemListener(new RemoveAction(AbstractSearchResultPanel.this.parent, AbstractSearchResultPanel.this.results.get(i)));
                    checkBoxPanel.add(newLabel);
                    checkBoxPanel.add(checkBox);
                    checkBoxPanel.add(removeBox);
                    JLabel label = AbstractSearchResultPanel.this.createImageLabel(AbstractSearchResultPanel.this.results.get(i), AbstractSearchResultPanel.this.queryImage);
                    Spread spread = AbstractSearchResultPanel.this.results.get(i).getSpread();
                    if (AbstractSearchResultPanel.this.lineDirection == LineDirection.HORIZONTAL) {
                        labelPanel.setLayout(new FlowLayout(0));
                        labelPanel.add(checkBoxPanel);
                        if (AbstractSearchResultPanel.this instanceof SearchResultPanelOfSegmentMode) {
                            labelPanel.setBorder(new LineBorder(Color.BLACK));
                        } else {
                            labelPanel.setBorder(new TitledBorder(spread.getURI()));
                        }
                        labelPanel.add(label);
                        AbstractSearchResultPanel.this.nextResults.add(labelPanel);
                    } else {
                        labelPanel.setLayout(new BoxLayout(labelPanel, 1));
                        labelPanel.add(checkBoxPanel);
                        labelPanel.setBorder(new LineBorder(Color.BLACK));
                        labelPanel.add(label);
                        AbstractSearchResultPanel.this.nextResults.add(labelPanel);
                    }
                    spread.release();
                }
            }
        };
        this.nextThread.start();
    }

    protected abstract JLabel createImageLabel(SearchResult var1, Image var2);

    public void updateBucket() {
        int beginIndex = this.count * this.SIZE_TO_DISPLAY;
        for (int i = 0; i < this.SIZE_TO_DISPLAY - 1; ++i) {
            JPanel panel = this.currentResults.get(i);
            JLabel label = (JLabel)((JPanel)panel.getComponent(0)).getComponent(0);
            if (!this.results.get(beginIndex + i).isInBucket()) continue;
            label.setIcon(new ImageIcon("./icons/copy.gif"));
        }
        this.parent.validate();
        this.repaint();
        this.validate();
    }
}

