/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.image_search.normal.swingui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import smart_gs.GSConstants;
import smart_gs.image_search.logical.GSQuery;
import smart_gs.image_search.logical.QueryBucket;
import smart_gs.image_search.normal.swingui.Observer;
import smart_gs.image_search.normal.swingui.ShowQueryAction;
import smart_gs.logical.Preference;
import smart_gs.util.ImageAdjuster;
import sml_editor.logical.LineDirection;

public class BucketPanel
extends JPanel
implements Observer {
    private QueryBucket bucket;
    private JFrame parent;

    public BucketPanel(JFrame parent, QueryBucket bucket) {
        this.parent = parent;
        this.bucket = bucket;
        this.bucket.addObserver(this);
        if (Preference.getInstance().getTextType() == GSConstants.TEXT_TYPE_HORIZONTAL.intValue()) {
            this.setMaximumSize(new Dimension(600, 800));
        } else {
            this.setMaximumSize(new Dimension(800, 600));
        }
        this.updateGUI();
    }

    public void updateGUI() {
        this.removeAll();
        if (this.bucket.size() < 1) {
            return;
        }
        GSQuery query0 = this.bucket.get(0);
        if (this.bucket.getLineDirection() == LineDirection.HORIZONTAL) {
            this.setLayout(new GridLayout(0, 3));
        } else {
            this.setLayout(new GridLayout(3, 0));
        }
        for (int i = 0; i < this.bucket.size(); ++i) {
            GSQuery query = this.bucket.get(i);
            Image image = i == 0 ? query.getQueryImageWithTransformation() : query.getQueryImage();
            image = ImageAdjuster.adjust(image, this.bucket.getLineDirection(), 50.0);
            JLabel label = new JLabel(new ImageIcon(image));
            label.addMouseListener(new ShowQueryAction(query));
            JPanel panel = new JPanel();
            panel.setBorder(new LineBorder(Color.BLACK));
            panel.add(label);
            this.add(panel);
        }
        this.parent.validate();
        this.parent.toFront();
        this.parent.pack();
    }

    @Override
    public void update() {
        this.updateGUI();
    }

    public QueryBucket getBucket() {
        return this.bucket;
    }
}

