/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.logical;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import smart_gs.logical.DefaultMutableTreeNodeNameComparator;
import smart_gs.logical.GSResource;
import smart_gs.logical.GSResourceNameComparator;
import smart_gs.logical.Preference;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadDirectory;
import smart_gs.logical.SpreadSelectionListManager;
import smart_gs.logical.URICreator;
import smart_gs.logical.filter.ImageFileDirFilterForSpreadTree;
import smart_gs.logical.region.BookmarkRegion;
import smart_gs.logical.visitor.CreateXMLElementVisitor;
import smart_gs.reasoning_web.logical.LinkRemover;
import smart_gs.spread_selection.IndexChangeTable;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.CanonicalPathString;
import smart_gs.util.GSPathStringGrammarChecker;
import smart_gs.util.GSStandardPath;
import smart_gs.util.StringUtils;

public class SpreadTree
extends JTree
implements DragSourceListener,
DropTargetListener,
DragGestureListener {
    private static SpreadTree singleton = new SpreadTree();
    private List<Spread> registeredSpreads;
    private List<SpreadDirectory> registeredSpreadDirectories;
    private TreePath[] selectedPaths;
    private static String IMAGE_FOLDER_PATH_STRING;
    private static String DSC_FOLDER_PATH_STRING;
    private static File IMAGE_FOLDER_PATH;
    private static File DSC_FOLDER_PATH;
    private SpreadDirectory root;
    private DefaultMutableTreeNode rootNode;
    private static final String NAME = "SpreadTree";
    private static final DataFlavor localObjectFlavor;
    private static final DataFlavor[] supportedFlavors;
    protected DragSource dragSource;
    protected DropTarget dropTarget;
    TreeNode dropTargetNode = null;
    TreeNode draggedNode = null;
    TreePath dragsourceTreePath = null;
    protected HashMap<String, String> allowImageMap = new HashMap();

    private SpreadTree() {
        super(new DefaultMutableTreeNode("root"));
        String[] formatNames = ImageIO.getReaderFormatNames();
        for (int i = 0; i < formatNames.length; ++i) {
            this.allowImageMap.put(formatNames[i].toLowerCase(), formatNames[i].toLowerCase());
        }
        Spread.resetIndex();
        this.registeredSpreads = new ArrayList<Spread>();
        this.registeredSpreadDirectories = new ArrayList<SpreadDirectory>();
        IMAGE_FOLDER_PATH_STRING = CanonicalPathString.get(new File(Preference.getInstance().getImageFolderPathString()));
        IMAGE_FOLDER_PATH = new File(IMAGE_FOLDER_PATH_STRING);
        DSC_FOLDER_PATH_STRING = CanonicalPathString.get(new File(Preference.getInstance().getDscFolderPathString()));
        DSC_FOLDER_PATH = new File(DSC_FOLDER_PATH_STRING);
        if (!IMAGE_FOLDER_PATH_STRING.equals("")) {
            this.root = new SpreadDirectory("root", new File(IMAGE_FOLDER_PATH_STRING));
            this.rootNode = new DefaultMutableTreeNode(this.root);
            ((DefaultTreeModel)this.getModel()).setRoot(this.rootNode);
            this.updateModel();
        }
        this.getSelectionModel().setSelectionMode(4);
        this.setCellRenderer(new SpreadTreeCellRenderer());
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        this.dropTarget = new DropTarget(this, this);
    }

    public List<File> getDSCFiles() {
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < this.registeredSpreads.size(); ++i) {
            if (!this.registeredSpreads.get(i).hasDscFile()) continue;
            files.add(this.registeredSpreads.get(i).getDscFile());
        }
        return files;
    }

    public void loadAllImages() {
        for (int i = 0; i < this.registeredSpreads.size(); ++i) {
            if (!this.registeredSpreads.get(i).hasDscFile()) continue;
            this.registeredSpreads.get(i).loadImage();
        }
    }

    public static SpreadTree getInstance() {
        return singleton;
    }

    public List<Spread> getSpreads() {
        return this.registeredSpreads;
    }

    public void registerSpread(Spread spread) {
        this.registeredSpreads.add(spread);
    }

    public List<Spread> getDSCSpreads() {
        ArrayList<Spread> results = new ArrayList<Spread>();
        for (int i = 0; i < this.registeredSpreads.size(); ++i) {
            if (!this.registeredSpreads.get(i).hasDscFile()) continue;
            results.add(this.registeredSpreads.get(i));
        }
        return results;
    }

    public TreePath[] getSelectedPaths() {
        return this.getSelectionModel().getSelectionPaths();
    }

    public SpreadDirectory getRootSpreadDirectory() {
        return this.root;
    }

    public boolean isRegistered(File file) {
        int i;
        for (i = 0; i < this.registeredSpreadDirectories.size(); ++i) {
            if (!this.registeredSpreadDirectories.get(i).getFile().equals(file)) continue;
            return true;
        }
        for (i = 0; i < this.registeredSpreads.size(); ++i) {
            if (!this.registeredSpreads.get(i).getFile().equals(file)) continue;
            return true;
        }
        return false;
    }

    public SpreadDirectory getCurrentDirectory() {
        TreePath path = this.getSelectionModel().getSelectionPath();
        if (path == null) {
            return (SpreadDirectory)((DefaultMutableTreeNode)this.getModel().getRoot()).getUserObject();
        }
        Object selectedObject = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        while (!(selectedObject instanceof SpreadDirectory)) {
            path = path.getParentPath();
            selectedObject = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        }
        return (SpreadDirectory)selectedObject;
    }

    public DefaultMutableTreeNode getSelectedNode() {
        TreePath path = this.getSelectionModel().getSelectionPath();
        if (path == null) {
            return this.rootNode;
        }
        return (DefaultMutableTreeNode)path.getLastPathComponent();
    }

    public boolean isImage(File file) {
        String ext;
        String fileName = file.getName();
        int index = fileName.lastIndexOf(46);
        return index >= 0 && this.allowImageMap.containsKey((ext = fileName.substring(index + 1)).toLowerCase());
    }

    private void loadImages(SpreadDirectory parent, boolean sort) {
        File[] files = parent.getFile().listFiles(new ImageFileDirFilterForSpreadTree());
        if (sort) {
            Arrays.sort(files, new SpreadFileComparator());
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                SpreadDirectory directory;
                if (this.isRegistered(file)) {
                    directory = this.getDirectory(file);
                    this.loadImages(directory, sort);
                    continue;
                }
                directory = new SpreadDirectory(parent, file.getName(), file);
                this.registeredSpreadDirectories.add(directory);
                parent.addResource(directory);
                this.loadImages(directory, sort);
                continue;
            }
            if (this.isRegistered(file) || !this.isImage(file)) continue;
            Spread spread = new Spread(parent, file);
            parent.addResource(spread);
            this.registeredSpreads.add(spread);
        }
    }

    private SpreadDirectory getDirectory(File file) {
        for (int i = 0; i < this.registeredSpreadDirectories.size(); ++i) {
            if (!this.registeredSpreadDirectories.get(i).getFile().equals(file)) continue;
            return this.registeredSpreadDirectories.get(i);
        }
        return null;
    }

    public void updateModel() {
        this.root.setTree(this.rootNode);
        ((DefaultTreeModel)this.getModel()).setRoot(this.rootNode);
        ((DefaultTreeModel)this.getModel()).reload();
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.rootNode;
    }

    public void restore(Element element) {
        NodeList list = element.getElementsByTagName("directory");
        if (list.getLength() < 1) {
            System.out.println("list error");
            return;
        }
        Element rootElement = (Element)list.item(0);
        this.registeredSpreads.clear();
        this.registeredSpreadDirectories.clear();
        Spread.resetIndex();
        this.rootNode.removeAllChildren();
        String imageFolderPath = Preference.getInstance().getImageFolderPathString();
        String name = rootElement.getAttribute("name");
        String uri = rootElement.getAttribute("uri");
        String originalURI = rootElement.getAttribute("originalURI");
        String version = rootElement.getAttribute("version");
        File filepath = new File(imageFolderPath);
        this.root = new SpreadDirectory("root", filepath, uri, originalURI, version);
        this.root.setVersion(version);
        this.root.setName(name);
        this.rootNode.setUserObject(this.root);
        this.root.restore(rootElement, filepath);
        this.registeredSpreads = this.root.getSpreads();
        this.registeredSpreadDirectories = this.root.getSpreadDirectorys();
        this.updateModel();
    }

    public void save(Document document, Element parent) {
        Element element = document.createElement("spreadTree");
        parent.appendChild(element);
        CreateXMLElementVisitor visitor = new CreateXMLElementVisitor(document);
        this.root.accept(visitor);
        element.appendChild(visitor.getLastElement());
    }

    public void registerSpreadDirectory(SpreadDirectory directory) {
        this.registeredSpreadDirectories.add(directory);
    }

    public Spread getSpreadByResourceURI(String uri) {
        for (int i = 0; i < this.registeredSpreads.size(); ++i) {
            if (!this.extractSpreadURI(uri).equals(URICreator.getURIWithoutHeader(this.registeredSpreads.get(i))) && !this.extractSpreadURI(uri).equals(this.registeredSpreads.get(i).getOriginalURI().substring("smart://".length())) && !uri.equals(this.registeredSpreads.get(i).getURI())) continue;
            return this.registeredSpreads.get(i);
        }
        return null;
    }

    private Object extractSpreadURI(String uri) {
        return uri.substring(uri.indexOf("^spread") + 1);
    }

    public Spread getSpreadByURI(String uri) {
        for (int i = 0; i < this.registeredSpreads.size(); ++i) {
            if (!this.registeredSpreads.get(i).getURI().equals(uri)) continue;
            return this.registeredSpreads.get(i);
        }
        return null;
    }

    public Spread getSpreadByURI2(String uri) {
        for (int i = 0; i < this.registeredSpreads.size(); ++i) {
            String srcurl = this.registeredSpreads.get(i).getURI();
            if ((srcurl = GSStandardPath.toStandardOnCurrentOS(srcurl)).indexOf(uri) == -1) continue;
            return this.registeredSpreads.get(i);
        }
        return null;
    }

    public void export(Writer writer) throws IOException {
        for (int i = 0; i < this.registeredSpreads.size(); ++i) {
            Spread spread = this.registeredSpreads.get(i);
            boolean isBr = false;
            String xmlstr = spread.getFirstIDAT().getSource();
            xmlstr = StringUtils.replaceString(xmlstr, "<br>", "\n");
            Pattern pattern = Pattern.compile("<.+?>", 32);
            Matcher matcher = pattern.matcher(xmlstr);
            xmlstr = matcher.replaceAll("");
            if (!(xmlstr = xmlstr.trim()).trim().equals("")) {
                writer.write(xmlstr);
                writer.write("\n");
                isBr = true;
            }
            xmlstr = spread.getSecondIDAT().getSource();
            xmlstr = StringUtils.replaceString(xmlstr, "<br>", "\n");
            pattern = Pattern.compile("<.+?>", 32);
            matcher = pattern.matcher(xmlstr);
            xmlstr = matcher.replaceAll("");
            if (!(xmlstr = xmlstr.trim()).trim().equals("")) {
                writer.write(xmlstr);
                writer.write("\n");
                isBr = true;
            }
            xmlstr = spread.getThirdIDAT().getSource();
            xmlstr = StringUtils.replaceString(xmlstr, "<br>", "\n");
            pattern = Pattern.compile("<.+?>", 32);
            matcher = pattern.matcher(xmlstr);
            xmlstr = matcher.replaceAll("");
            if (!(xmlstr = xmlstr.trim()).trim().equals("")) {
                writer.write(xmlstr);
                writer.write("\n");
                isBr = true;
            }
            if (!isBr) continue;
            writer.write("\n");
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.dropTargetNode = null;
        this.draggedNode = null;
        this.dragsourceTreePath = null;
        WorkspaceWindow.setUpdated(true);
        this.repaint();
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
        dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
        dse.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
        this.selectedPaths = null;
        this.selectedPaths = this.getSelectedPaths();
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(3);
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        Object droppedObject;
        DataFlavor[] f = dtde.getCurrentDataFlavors();
        boolean isDataFlavorSupported = f[0].getHumanPresentableName().equals(NAME);
        if (!isDataFlavorSupported) {
            this.rejectDrag(dtde);
            return;
        }
        Point pt = dtde.getLocation();
        TreePath path = this.getPathForLocation(pt.x, pt.y);
        Rectangle r2 = new Rectangle(pt.x, pt.y, 10, 10);
        Rectangle r1 = new Rectangle(pt.x - 10, pt.y - 10, 10, 10);
        this.scrollRectToVisible(r1);
        this.scrollRectToVisible(r2);
        if (path == null) {
            this.rejectDrag(dtde);
            return;
        }
        try {
            droppedObject = dtde.getTransferable().getTransferData(localObjectFlavor);
        }
        catch (Exception ex) {
            this.rejectDrag(dtde);
            return;
        }
        if (path == null || !path.getParentPath().toString().equals(this.dragsourceTreePath.getParentPath().toString())) {
            this.rejectDrag(dtde);
            return;
        }
        this.selectedPaths = null;
        this.selectedPaths = this.getSelectedPaths();
        if (!this.areSelectedPathsInSameNode(this.selectedPaths)) {
            this.rejectDrag(dtde);
            return;
        }
        DefaultMutableTreeNode droppedNode = (DefaultMutableTreeNode)droppedObject;
        DefaultMutableTreeNode parentOfDroppedNode = (DefaultMutableTreeNode)droppedNode.getParent();
        DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        for (DefaultMutableTreeNode parentOfTargetNode = (DefaultMutableTreeNode)targetNode.getParent(); parentOfTargetNode != null; parentOfTargetNode = (DefaultMutableTreeNode)parentOfTargetNode.getParent()) {
            if (!droppedNode.equals(parentOfTargetNode)) continue;
            this.rejectDrag(dtde);
            return;
        }
        this.dropTargetNode = targetNode;
        dtde.acceptDrag(dtde.getDropAction());
        this.repaint();
    }

    private boolean areSelectedPathsInSameNode(TreePath[] selectedPaths2) {
        int size;
        if (this.selectedPaths != null && (size = this.selectedPaths.length) != 0) {
            DefaultMutableTreeNode parentOfFirstSelectedNode = (DefaultMutableTreeNode)this.selectedPaths[0].getParentPath().getLastPathComponent();
            for (int i = 1; i < size; ++i) {
                DefaultMutableTreeNode parentOfSelectedNode = (DefaultMutableTreeNode)this.selectedPaths[i].getParentPath().getLastPathComponent();
                if (parentOfSelectedNode.equals(parentOfFirstSelectedNode)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        boolean droppedNodeIsSelected;
        Object droppedObject;
        try {
            droppedObject = dtde.getTransferable().getTransferData(localObjectFlavor);
        }
        catch (Exception e) {
            e.printStackTrace();
            dtde.dropComplete(false);
            return;
        }
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        Point p = dtde.getLocation();
        TreePath targetPath = this.getPathForLocation(p.x, p.y);
        if (targetPath == null || !(droppedObject instanceof MutableTreeNode)) {
            dtde.dropComplete(false);
            return;
        }
        DefaultMutableTreeNode droppedNode = (DefaultMutableTreeNode)droppedObject;
        DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode)targetPath.getLastPathComponent();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)targetNode.getParent();
        if (targetNode.equals(droppedNode)) {
            dtde.dropComplete(false);
            return;
        }
        dtde.acceptDrop(2);
        TreePath pathOfDroppedNode = new TreePath(droppedNode.getPath());
        int size = -1;
        if (this.selectedPaths == null) {
            droppedNodeIsSelected = false;
        } else {
            size = this.selectedPaths.length;
            droppedNodeIsSelected = false;
            for (int i = 0; i < size; ++i) {
                if (!pathOfDroppedNode.equals(this.selectedPaths[i])) continue;
                droppedNodeIsSelected = true;
                int droppedNodeIndexInSelection = i;
                break;
            }
        }
        List<GSResource> resources = ((SpreadDirectory)parentNode.getUserObject()).getResources();
        int droppedNodeIndex = model.getIndexOfChild(parentNode, droppedNode);
        int targetNodeIndex = model.getIndexOfChild(parentNode, targetNode);
        if (!droppedNodeIsSelected || size == 1) {
            model.removeNodeFromParent(droppedNode);
            GSResource elm = resources.get(droppedNodeIndex);
            resources.remove(droppedNodeIndex);
            int insertionPointIndex = 0;
            if (droppedNodeIndex < targetNodeIndex) {
                insertionPointIndex = targetNodeIndex - 1;
            } else if (droppedNodeIndex > targetNodeIndex) {
                insertionPointIndex = targetNodeIndex;
            }
            resources.add(insertionPointIndex, elm);
            model.insertNodeInto(droppedNode, parentNode, insertionPointIndex);
            this.setSelectionPath(pathOfDroppedNode);
            ((SpreadDirectory)parentNode.getUserObject()).setResources(resources);
        } else {
            int i;
            int insertPointIndex = targetNodeIndex;
            MutableTreeNode[] tmpForJTree = new MutableTreeNode[size];
            GSResource[] tmpForSpreadTree = new GSResource[size];
            for (int i2 = 0; i2 < size; ++i2) {
                MutableTreeNode selectedNode;
                tmpForJTree[i2] = selectedNode = (MutableTreeNode)this.selectedPaths[i2].getLastPathComponent();
                tmpForSpreadTree[i2] = resources.get(model.getIndexOfChild(parentNode, selectedNode));
            }
            int insertionPointIndex = -1;
            int offset = 0;
            for (i = 0; i < size; ++i) {
                insertionPointIndex = targetNodeIndex;
                MutableTreeNode selectedNode = (MutableTreeNode)this.selectedPaths[i].getLastPathComponent();
                int selectedNodeIndex = model.getIndexOfChild(this.selectedPaths[i].getParentPath().getLastPathComponent(), selectedNode);
                GSResource elm = resources.get(selectedNodeIndex);
                model.removeNodeFromParent(selectedNode);
                resources.remove(selectedNodeIndex);
                if (selectedNodeIndex < insertionPointIndex) {
                    ++offset;
                    continue;
                }
                if (selectedNodeIndex < insertionPointIndex) continue;
            }
            insertionPointIndex -= offset;
            for (i = size - 1; i >= 0; --i) {
                resources.add(insertionPointIndex, tmpForSpreadTree[i]);
                model.insertNodeInto(tmpForJTree[i], parentNode, insertionPointIndex);
            }
            this.setSelectionPaths(this.selectedPaths);
            ((SpreadDirectory)parentNode.getUserObject()).setResources(resources);
        }
        new AutomaticNumbering().execAndAdjustSpreadSelectionLists(this.rootNode);
        WorkspaceWindow.getInstance().updateMoveToolBar();
        WorkspaceWindow.setUpdated(true);
        this.repaint();
        dtde.dropComplete(true);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        Point clickPoint = dge.getDragOrigin();
        TreePath path = this.getPathForLocation(clickPoint.x, clickPoint.y);
        if (path == null || path.getParentPath() == null) {
            return;
        }
        this.dragsourceTreePath = path;
        this.draggedNode = (TreeNode)path.getLastPathComponent();
        if (this.draggedNode instanceof DefaultMutableTreeNode) {
            SpreadTreeTransferable trans = new SpreadTreeTransferable(this.draggedNode);
            this.dragSource.startDrag(dge, Cursor.getDefaultCursor(), trans, this);
        }
    }

    private void rejectDrag(DropTargetDragEvent dtde) {
        dtde.rejectDrag();
        this.dropTargetNode = null;
        this.repaint();
    }

    public Spread getSpreadByIndex(Integer index) {
        List<Spread> toseek = this.getSpreads();
        Spread result = null;
        for (int i = toseek.size() - 1; i >= 0; --i) {
            if (toseek.get(i).getPageIndex() != index.intValue()) continue;
            result = toseek.get(i);
        }
        return result;
    }

    public List<GSResource> getBookmarks() {
        ArrayList<GSResource> bookmarks = new ArrayList<GSResource>();
        for (Spread spread : this.registeredSpreads) {
            for (Region region : spread.getRegions()) {
                if (region.getView().getType() != 6) continue;
                bookmarks.add((BookmarkRegion)region);
            }
        }
        return bookmarks;
    }

    public void sortSelectedItemsByName() {
        int i;
        int i2;
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        this.selectedPaths = null;
        this.selectedPaths = this.getSelectedPaths();
        int size = this.selectedPaths.length;
        if (size == 0) {
            return;
        }
        if (!this.areSelectedPathsInSameNode(this.selectedPaths)) {
            JOptionPane.showMessageDialog(singleton, "Items must be in the same directory");
            return;
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.selectedPaths[0].getParentPath().getLastPathComponent();
        List<GSResource> resources = ((SpreadDirectory)parentNode.getUserObject()).getResources();
        int[] indexes = new int[size];
        for (i2 = 0; i2 < size; ++i2) {
            indexes[i2] = parentNode.getIndex((DefaultMutableTreeNode)this.selectedPaths[i2].getLastPathComponent());
        }
        Arrays.sort(indexes);
        for (i2 = 0; i2 < size - 1; ++i2) {
            if (indexes[i2 + 1] <= indexes[i2] + 1) continue;
            JOptionPane.showMessageDialog(singleton, "Items must be consective:" + indexes[i2] + "," + indexes[i2 + 1] + "\n");
            return;
        }
        int insertionPointIndex = indexes[0];
        MutableTreeNode[] tmpForJTree = new MutableTreeNode[size];
        GSResource[] tmpForSpreadTree = new GSResource[size];
        for (i = 0; i < size; ++i) {
            MutableTreeNode selectedNode;
            tmpForJTree[i] = selectedNode = (MutableTreeNode)this.selectedPaths[i].getLastPathComponent();
            tmpForSpreadTree[i] = resources.get(model.getIndexOfChild(parentNode, selectedNode));
        }
        Arrays.sort(tmpForJTree, new DefaultMutableTreeNodeNameComparator());
        Arrays.sort(tmpForSpreadTree, new GSResourceNameComparator());
        for (i = size - 1; i >= 0; --i) {
            parentNode.remove(insertionPointIndex + i);
            resources.remove(insertionPointIndex + i);
        }
        for (i = size - 1; i >= 0; --i) {
            resources.add(insertionPointIndex, tmpForSpreadTree[i]);
            model.insertNodeInto(tmpForJTree[i], parentNode, insertionPointIndex);
        }
        ((SpreadDirectory)parentNode.getUserObject()).setResources(resources);
        new AutomaticNumbering().execAndAdjustSpreadSelectionLists(this.rootNode);
        WorkspaceWindow.setUpdated(true);
        this.updateUI();
        this.repaint();
    }

    public DefaultMutableTreeNode makeNewSpreadDirectory(DefaultMutableTreeNode parentTreeNode, String name) {
        return this.makeNewSpreadDirectory(parentTreeNode, name, false);
    }

    public DefaultMutableTreeNode makeNewSpreadDirectoryImportMode(DefaultMutableTreeNode parentTreeNode, String name) {
        return this.makeNewSpreadDirectory(parentTreeNode, name, true);
    }

    public DefaultMutableTreeNode makeNewSpreadDirectory(DefaultMutableTreeNode parentTreeNode, String name, boolean importMode) {
        File newDir;
        if (!GSPathStringGrammarChecker.isFileDirIdentifier(name)) {
            JOptionPane.showMessageDialog(null, String.format("Error: name %s cannot be used in SMART-GS.", name));
            return null;
        }
        if (name.equals(".") || name.equals("..")) {
            JOptionPane.showMessageDialog(null, String.format("Error: name %s is not allowed to avoid confusion.", name));
            return null;
        }
        if (name.equals("DscLocation")) {
            JOptionPane.showMessageDialog(null, String.format("Error: name %s is used by SMART-GS system, and so cannot be used.", name));
            return null;
        }
        Enumeration<TreeNode> enm = parentTreeNode.children();
        while (enm.hasMoreElements()) {
            DefaultMutableTreeNode nextNode = (DefaultMutableTreeNode)enm.nextElement();
            GSResource rsrc = (GSResource)nextNode.getUserObject();
            String tmp = rsrc.getName();
            if (!tmp.equalsIgnoreCase(name)) continue;
            JOptionPane.showMessageDialog(null, String.format("Error: new directory   %s   cannot be made, since name   %s   already exists in %s\nRemark: name equality check is case-senseless for Windows File Systems", name, tmp, SpreadTree.makePathString(parentTreeNode.getPath())));
            return null;
        }
        SpreadDirectory parentSpreadDir = (SpreadDirectory)parentTreeNode.getUserObject();
        if (!importMode) {
            String[] children = parentSpreadDir.getFile().list();
            for (int i = 0; i < children.length; ++i) {
                String tmp = children[i];
                if (!tmp.equalsIgnoreCase(name)) continue;
                JOptionPane.showMessageDialog(null, String.format("Error: new directory   %s   cannot be made, since name   %s   already exists in the file system %s. Consider to import it\nRemark: name equality check is case-senseless for Windows File Systems", name, tmp, parentSpreadDir.getFile().getPath()));
                return null;
            }
        }
        if (!(newDir = new File(parentSpreadDir.getFile(), name)).exists()) {
            boolean check = newDir.mkdir();
            if (!check) {
                System.out.printf("Error: directory %s could not be made.\n", CanonicalPathString.get(newDir));
                return null;
            }
            File newDscDir = new File(newDir, "dsc");
            check = newDscDir.mkdir();
            if (!check) {
                System.out.printf("Error: dsc directory %s could not be made.\n", CanonicalPathString.get(newDscDir));
                return null;
            }
        }
        SpreadDirectory directory = new SpreadDirectory(parentSpreadDir, name, newDir);
        this.registeredSpreadDirectories.add(directory);
        parentSpreadDir.addResource(directory);
        DefaultMutableTreeNode directoryNode = new DefaultMutableTreeNode(directory);
        parentTreeNode.add(directoryNode);
        this.updateUI();
        this.repaint();
        return directoryNode;
    }

    public static String makePathString(TreeNode[] array_path) {
        StringBuffer tmp = new StringBuffer();
        int size = array_path.length;
        for (int i = 0; i < size; ++i) {
            tmp.append("/");
            tmp.append(array_path[i]);
        }
        return tmp.toString();
    }

    public DefaultMutableTreeNode addSpreadDirectory(DefaultMutableTreeNode treeNode, SpreadDirectory parent, File file) {
        boolean ans = file.isDirectory();
        if (file.isDirectory()) {
            if (!this.isRegistered(file)) {
                SpreadDirectory directory = new SpreadDirectory(parent, file.getName(), file);
                this.registeredSpreadDirectories.add(directory);
                parent.addResource(directory);
                DefaultMutableTreeNode directoryNode = new DefaultMutableTreeNode(directory);
                treeNode.add(directoryNode);
                return directoryNode;
            }
            Enumeration<TreeNode> e = treeNode.children();
            while (e.hasMoreElements()) {
                SpreadDirectory d;
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
                GSResource r = (GSResource)child.getUserObject();
                if (!(r instanceof SpreadDirectory) || !(d = (SpreadDirectory)r).getFile().equals(file)) continue;
                return child;
            }
        }
        System.out.print("Something wrong with SpreadTree.addDirectory()\n");
        return null;
    }

    public void addLoadImage(DefaultMutableTreeNode treeNode, SpreadDirectory parent, File file) {
        if (!file.isDirectory() && !this.isRegistered(file) && this.isImage(file)) {
            Spread spread = new Spread(parent, file);
            parent.addResource(spread);
            this.registeredSpreads.add(spread);
            treeNode.add(new DefaultMutableTreeNode(spread));
            new AutomaticNumbering().execAndAdjustSpreadSelectionLists(this.rootNode);
        }
        this.updateUI();
    }

    public void addImage(File file) {
        SpreadTree tree = SpreadTree.getInstance();
        if (file != null) {
            if (tree.isRegistered(file)) {
                return;
            }
            DefaultMutableTreeNode spreadTreeNode = tree.getSelectedNode();
            SpreadDirectory spreadDirectory = (SpreadDirectory)spreadTreeNode.getUserObject();
            tree.addLoadImage(spreadTreeNode, spreadDirectory, file);
        }
    }

    public void addImage(DefaultMutableTreeNode spreadTreeNode, File file) {
        SpreadTree tree = SpreadTree.getInstance();
        if (file != null) {
            if (tree.isRegistered(file)) {
                return;
            }
            SpreadDirectory spreadDirectory = (SpreadDirectory)spreadTreeNode.getUserObject();
            tree.addLoadImage(spreadTreeNode, spreadDirectory, file);
        }
    }

    public void addImageFile(String rootDir, String openDirectoryPathInString, SpreadDirectory openDirectory, File imageFile) {
        if (singleton.isRegistered(imageFile)) {
            return;
        }
        String imageFilePath = CanonicalPathString.get(imageFile);
        DefaultMutableTreeNode treeNode = singleton.getSelectedNode();
        SpreadDirectory parent = openDirectory;
        if (!rootDir.equals(openDirectoryPathInString)) {
            String dir = imageFilePath.substring(openDirectoryPathInString.length(), imageFilePath.length() - imageFile.getName().length());
            dir = GSStandardPath.win2standard(dir);
            StringTokenizer st = new StringTokenizer(dir, "/");
            StringBuffer dirBuf = new StringBuffer();
            if (!rootDir.endsWith("/")) {
                rootDir = rootDir + "/";
            }
            dirBuf.append(openDirectoryPathInString);
            while (st.hasMoreTokens()) {
                dirBuf.append(st.nextToken() + "/");
                File newDir = new File(dirBuf.toString());
                treeNode = singleton.addSpreadDirectory(treeNode, parent, newDir);
                parent = (SpreadDirectory)treeNode.getUserObject();
            }
        }
        singleton.addLoadImage(treeNode, parent, imageFile);
    }

    public void addDir(DefaultMutableTreeNode theTargetNode, File parentDirectory, String newDirName) {
        DefaultMutableTreeNode newDirNode = this.makeNewSpreadDirectoryImportMode(theTargetNode, newDirName);
        if (newDirNode == null) {
            return;
        }
        File newDirOnFileSystem = new File(parentDirectory, newDirName);
        File[] list = newDirOnFileSystem.listFiles(new ImageFileDirFilterForSpreadTree());
        for (int i = 0; i < list.length; ++i) {
            if (list[i].isDirectory()) {
                String dirName = list[i].getName();
                this.addDir(newDirNode, newDirOnFileSystem, dirName);
                continue;
            }
            this.addImage(newDirNode, list[i]);
        }
    }

    public void removeSelectedItems() {
        GSResource item;
        int i;
        TreePath[] paths = this.getSelectedPaths();
        int size = paths.length;
        Object[] options = new Object[]{"delete the items", "don't delete the items", "Cancel"};
        int selectedProcessOption = JOptionPane.showOptionDialog(WorkspaceWindow.getInstance().getFrame(), "From Image Folder,", "Deletion options", 1, 3, null, options, options[0]);
        if (selectedProcessOption == 2) {
            return;
        }
        for (i = 0; i < size && (item = (GSResource)((DefaultMutableTreeNode)paths[i].getLastPathComponent()).getUserObject()) != null; ++i) {
            if (item instanceof Spread) {
                this.removeSpread(paths[i]);
            } else if (item instanceof SpreadDirectory) {
                this.removeDirectory(paths[i]);
            } else {
                System.out.print("Bug in SpreadTree");
            }
            new AutomaticNumbering().execAndAdjustSpreadSelectionLists(this.rootNode);
            WorkspaceWindow.setUpdated(true);
            this.repaint();
        }
        if (selectedProcessOption == 0) {
            for (i = 0; i < size && (item = (GSResource)((DefaultMutableTreeNode)paths[i].getLastPathComponent()).getUserObject()) != null; ++i) {
                if (item instanceof Spread) {
                    Spread spread = (Spread)item;
                    File imageFile = spread.getImageFile();
                    File dscFile = spread.getDscFile();
                    File dscLineSegFile = spread.getDscLineSegFile();
                    File lineSegFile = spread.getLineSegFile();
                    if (imageFile.exists()) {
                        imageFile.delete();
                    }
                    if (dscFile != null && dscFile.exists()) {
                        dscFile.delete();
                    }
                    if (dscLineSegFile.exists()) {
                        dscLineSegFile.delete();
                    }
                    if (!lineSegFile.exists()) continue;
                    lineSegFile.delete();
                    continue;
                }
                Object[] nodes = paths[i].getPath();
                File image_fileDir_path = IMAGE_FOLDER_PATH;
                for (int j = 1; j < nodes.length; ++j) {
                    image_fileDir_path = new File(image_fileDir_path, nodes[j].toString());
                }
                SpreadTree.deleteDir(image_fileDir_path);
                if (IMAGE_FOLDER_PATH_STRING.equals(DSC_FOLDER_PATH)) continue;
                File dsc_fileDir_path = DSC_FOLDER_PATH;
                for (int j = 1; j < nodes.length; ++j) {
                    dsc_fileDir_path = new File(dsc_fileDir_path, nodes[j].toString());
                }
                SpreadTree.deleteDir(dsc_fileDir_path);
            }
        }
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = SpreadTree.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        if (dir.exists()) {
            return dir.delete();
        }
        return true;
    }

    public void removeSpread(TreePath path) {
        if (path == null) {
            return;
        }
        Object obj = path.getLastPathComponent();
        if (obj == null) {
            return;
        }
        Spread deletespread = (Spread)((DefaultMutableTreeNode)obj).getUserObject();
        if (deletespread == null) {
            return;
        }
        String nameStr = deletespread.toString();
        DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)targetNode.getParent();
        int smallest = Integer.MAX_VALUE;
        if (nameStr.indexOf(":") != -1) {
            String numberStr = nameStr.substring(0, nameStr.indexOf(":"));
            try {
                smallest = Integer.parseInt(numberStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        Enumeration<TreeNode> enumeration = parentNode.children();
        SpreadDirectory spreadDirectory = (SpreadDirectory)parentNode.getUserObject();
        int deletecount = 0;
        boolean deleteflg = false;
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode childrenNode = (DefaultMutableTreeNode)enumeration.nextElement();
            String childrenStr = childrenNode.toString();
            if (childrenNode.getUserObject() instanceof Spread && childrenStr.equals(nameStr)) {
                deleteflg = true;
                this.removeLink(((Spread)childrenNode.getUserObject()).getURI());
                this.registeredSpreads.remove((Spread)childrenNode.getUserObject());
                spreadDirectory.remove((Spread)childrenNode.getUserObject());
                break;
            }
            ++deletecount;
        }
        if (!deleteflg) {
            return;
        }
        parentNode.remove(deletecount);
        this.updateUI();
        this.repaint();
    }

    public void removeDirectory(TreePath path) {
        if (path == null) {
            return;
        }
        Object obj = path.getLastPathComponent();
        if (obj == null) {
            return;
        }
        SpreadDirectory deleteDirectory = (SpreadDirectory)((DefaultMutableTreeNode)obj).getUserObject();
        if (deleteDirectory == null) {
            return;
        }
        List<SpreadDirectory> listdir = deleteDirectory.getSpreadDirectorys();
        for (int i = 0; i < listdir.size(); ++i) {
            SpreadDirectory spreadDirectory = listdir.get(i);
            this.removeLink(spreadDirectory.getURI());
            this.registeredSpreadDirectories.remove(spreadDirectory);
        }
        List<Spread> listfile = deleteDirectory.getSpreads();
        for (int i = 0; i < listfile.size(); ++i) {
            Spread spread = listfile.get(i);
            this.removeLink(spread.getURI());
            this.registeredSpreads.remove(spread);
        }
        deleteDirectory.removeAllChildren();
        this.registeredSpreadDirectories.remove(deleteDirectory);
        this.removeLink(deleteDirectory.getURI());
        DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)targetNode.getParent();
        Object parentObject = parentNode.getUserObject();
        ((SpreadDirectory)parentObject).removeDirectory(deleteDirectory);
        parentNode.remove(targetNode);
        this.updateUI();
        this.repaint();
    }

    private void removeLink(String url) {
        LinkRemover.removeLinksOf(url);
    }

    public void clear() {
        this.registeredSpreads.clear();
        this.registeredSpreadDirectories.clear();
        this.rootNode.removeAllChildren();
        this.root.clear();
        this.updateUI();
        this.repaint();
    }

    static {
        localObjectFlavor = new DataFlavor("application/x-java-jvm-local-objectref", NAME);
        supportedFlavors = new DataFlavor[]{localObjectFlavor};
    }

    class AutomaticNumbering {
        private int counter = 0;
        int ict_max = Spread.getCurrentMaxPageIndex();
        IndexChangeTable ict = new IndexChangeTable(this.ict_max);

        AutomaticNumbering() {
        }

        private void exec(DefaultMutableTreeNode parentNode) {
            Enumeration<TreeNode> enumeration = parentNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode childrenNode = (DefaultMutableTreeNode)enumeration.nextElement();
                String childrenStr = childrenNode.toString();
                if (childrenNode.getUserObject() instanceof Spread) {
                    Spread spread = (Spread)childrenNode.getUserObject();
                    if (this.counter <= this.ict_max) {
                        this.ict.set(spread.getPageViewIndex(), this.counter);
                    }
                    spread.setPageViewIndex(this.counter);
                    ++this.counter;
                    continue;
                }
                if (!(childrenNode.getUserObject() instanceof SpreadDirectory)) continue;
                this.exec(childrenNode);
            }
            WorkspaceWindow.setUpdated(true);
        }

        public void execAndAdjustSpreadSelectionLists(DefaultMutableTreeNode rootNode) {
            this.exec(rootNode);
            SpreadSelectionListManager.getInstance().adjustSpreadSelctionLists(this.ict);
        }
    }

    class SpreadFileComparator
    implements Comparator<File> {
        SpreadFileComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            return o1.compareTo(o2);
        }
    }

    class SpreadTreeCellRenderer
    extends DefaultTreeCellRenderer {
        boolean isTargetNode;
        boolean isTargetNodeLeaf;
        boolean isLastItem;
        Insets normalInsets = super.getInsets();
        Insets lastItemInsets;
        int BOTTOM_PAD = 30;

        public SpreadTreeCellRenderer() {
            this.lastItemInsets = new Insets(this.normalInsets.top, this.normalInsets.left, this.normalInsets.bottom + this.BOTTOM_PAD, this.normalInsets.right);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            Object obj;
            this.isTargetNode = value == SpreadTree.this.dropTargetNode;
            this.isTargetNodeLeaf = this.isTargetNode && ((TreeNode)value).isLeaf();
            boolean showSelected = isSelected & SpreadTree.this.dropTargetNode == null;
            DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, row, hasFocus);
            if (value != null && value instanceof DefaultMutableTreeNode && (obj = (defaultMutableTreeNode = (DefaultMutableTreeNode)value).getUserObject()) != null && obj instanceof SpreadDirectory) {
                Icon icon = renderer.getOpenIcon();
                renderer.setIcon(icon);
            }
            return renderer;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.isTargetNode) {
                g.setColor(Color.black);
                g.drawLine(0, 0, this.getSize().width, 0);
            }
        }
    }

    class SpreadTreeTransferable
    implements Transferable {
        Object object;

        public SpreadTreeTransferable(Object o) {
            this.object = o;
        }

        @Override
        public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(df)) {
                return this.object;
            }
            throw new UnsupportedFlavorException(df);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor df) {
            return df.getHumanPresentableName().equals(SpreadTree.NAME);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return supportedFlavors;
        }
    }
}

