/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.logical;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import smart_gs.logical.DefaultMutableTreeNodeNameComparator;
import smart_gs.logical.GSResource;
import smart_gs.logical.GSResourceNameComparator;
import smart_gs.logical.URIObject;
import smart_gs.logical.UsersNote;
import smart_gs.logical.UsersNoteDirectory;
import smart_gs.logical.visitor.CreateXMLElementVisitor;
import smart_gs.reasoning_web.logical.LinkRemover;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.GSStandardPath;

public class UsersNoteTree
extends JTree
implements DragSourceListener,
DropTargetListener,
DragGestureListener {
    private static UsersNoteDirectory rootUsersNoteDirectory = new UsersNoteDirectory();
    private static UsersNoteTree singleton = new UsersNoteTree(rootUsersNoteDirectory);
    private List<UsersNote> registeredUsersNotes;
    private List<UsersNoteDirectory> registeredUsersNoteDirectories;
    private TreePath[] selectedPaths;
    private UsersNoteDirectory root;
    private DefaultMutableTreeNode rootNode;
    private static final String NAME = "UsersNoteTree";
    private static final DataFlavor localObjectFlavor = new DataFlavor("application/x-java-jvm-local-objectref", "UsersNoteTree");
    private static final DataFlavor[] supportedFlavors = new DataFlavor[]{localObjectFlavor};
    protected DragSource dragSource;
    protected DropTarget dropTarget;
    TreeNode dropTargetNode = null;
    TreeNode draggedNode = null;
    TreePath dragsourceTreePath = null;
    protected HashMap<String, String> allowImageMap = new HashMap();

    private UsersNoteTree(UsersNoteDirectory rootUsersNoteDirectory) {
        super(new DefaultMutableTreeNode(rootUsersNoteDirectory));
        rootUsersNoteDirectory.setName("root");
        this.root = rootUsersNoteDirectory;
        this.rootNode = (DefaultMutableTreeNode)super.getModel().getRoot();
        this.registeredUsersNotes = new ArrayList<UsersNote>();
        this.registeredUsersNoteDirectories = new ArrayList<UsersNoteDirectory>();
        this.registeredUsersNoteDirectories.add(rootUsersNoteDirectory);
        this.getSelectionModel().setSelectionMode(4);
        this.setCellRenderer(new UsersNoteTreeCellRenderer());
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        this.dropTarget = new DropTarget(this, this);
    }

    public static UsersNoteTree getInstance() {
        return singleton;
    }

    public List<UsersNote> getUsersNotes() {
        return this.registeredUsersNotes;
    }

    public void registorUsersNote(UsersNote usersNote) {
        this.registeredUsersNotes.add(usersNote);
    }

    public TreePath[] getSelectedPaths() {
        return this.getSelectionModel().getSelectionPaths();
    }

    public UsersNoteDirectory getRootUsersNoteDirectory() {
        return this.root;
    }

    public UsersNoteDirectory getCurrentDirectory() {
        TreePath path = this.getSelectionModel().getSelectionPath();
        if (path == null) {
            return (UsersNoteDirectory)((DefaultMutableTreeNode)this.getModel().getRoot()).getUserObject();
        }
        Object selectedObject = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        while (!(selectedObject instanceof UsersNoteDirectory)) {
            path = path.getParentPath();
            selectedObject = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        }
        return (UsersNoteDirectory)selectedObject;
    }

    public DefaultMutableTreeNode getSelectedNode() {
        TreePath path = this.getSelectionModel().getSelectionPath();
        if (path == null) {
            return this.rootNode;
        }
        return (DefaultMutableTreeNode)path.getLastPathComponent();
    }

    public void updateModel() {
        this.root.setTree(this.rootNode);
        ((DefaultTreeModel)this.getModel()).setRoot(this.rootNode);
        ((DefaultTreeModel)this.getModel()).reload();
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.rootNode;
    }

    public void restore(Element element) {
        NodeList list = element.getElementsByTagName("usersNoteDirectory");
        Element rootElement = (Element)list.item(0);
        this.registeredUsersNotes.clear();
        this.registeredUsersNoteDirectories.clear();
        this.rootNode.removeAllChildren();
        this.root = new UsersNoteDirectory();
        String name = rootElement.getAttribute("name");
        this.root.setName(name);
        this.rootNode.setUserObject(this.root);
        this.root.restore(rootElement);
        this.registeredUsersNotes = this.root.getUsersNotes();
        this.registeredUsersNoteDirectories = this.root.getUsersNoteDirectories();
        this.updateModel();
    }

    public void save(Document document, Element parent) {
        Element element = document.createElement("usersNoteTree");
        parent.appendChild(element);
        CreateXMLElementVisitor visitor = new CreateXMLElementVisitor(document);
        this.root.accept(visitor);
        element.appendChild(visitor.getLastElement());
    }

    public void registorUsersNoteDirectory(UsersNoteDirectory directory) {
        this.registeredUsersNoteDirectories.add(directory);
    }

    public UsersNote getUsersNoteByURI(String uri) {
        for (int i = 0; i < this.registeredUsersNotes.size(); ++i) {
            UsersNote note = this.registeredUsersNotes.get(i);
            if (!uri.equals(note.getURI())) continue;
            return this.registeredUsersNotes.get(i);
        }
        return null;
    }

    public UsersNote getUsersNoteByURI2(String uri) {
        for (int i = 0; i < this.registeredUsersNotes.size(); ++i) {
            String srcurl = this.registeredUsersNotes.get(i).getURI();
            if ((srcurl = GSStandardPath.toStandardOnCurrentOS(srcurl)).indexOf(uri) == -1) continue;
            return this.registeredUsersNotes.get(i);
        }
        return null;
    }

    public void export(Writer writer) throws IOException {
        for (int i = 0; i < this.registeredUsersNotes.size(); ++i) {
            UsersNote usersNote = this.registeredUsersNotes.get(i);
            boolean isBr = false;
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.dropTargetNode = null;
        this.draggedNode = null;
        this.dragsourceTreePath = null;
        WorkspaceWindow.setUpdated(true);
        this.repaint();
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
        dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
        dse.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
        this.selectedPaths = null;
        this.selectedPaths = this.getSelectedPaths();
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(3);
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        Object droppedObject;
        DataFlavor[] f = dtde.getCurrentDataFlavors();
        boolean isDataFlavorSupported = f[0].getHumanPresentableName().equals(NAME);
        if (!isDataFlavorSupported) {
            this.rejectDrag(dtde);
            return;
        }
        Point pt = dtde.getLocation();
        TreePath path = this.getPathForLocation(pt.x, pt.y);
        Rectangle r2 = new Rectangle(pt.x, pt.y, 10, 10);
        Rectangle r1 = new Rectangle(pt.x - 10, pt.y - 10, 10, 10);
        this.scrollRectToVisible(r1);
        this.scrollRectToVisible(r2);
        if (path == null) {
            this.rejectDrag(dtde);
            return;
        }
        try {
            droppedObject = dtde.getTransferable().getTransferData(localObjectFlavor);
        }
        catch (Exception ex) {
            this.rejectDrag(dtde);
            return;
        }
        if (path == null || !path.getParentPath().toString().equals(this.dragsourceTreePath.getParentPath().toString())) {
            this.rejectDrag(dtde);
            return;
        }
        this.selectedPaths = null;
        this.selectedPaths = this.getSelectedPaths();
        if (!this.areSelectedPathsInSameNode(this.selectedPaths)) {
            this.rejectDrag(dtde);
            return;
        }
        DefaultMutableTreeNode droppedNode = (DefaultMutableTreeNode)droppedObject;
        DefaultMutableTreeNode parentOfDroppedNode = (DefaultMutableTreeNode)droppedNode.getParent();
        DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        for (DefaultMutableTreeNode parentOfTargetNode = (DefaultMutableTreeNode)targetNode.getParent(); parentOfTargetNode != null; parentOfTargetNode = (DefaultMutableTreeNode)parentOfTargetNode.getParent()) {
            if (!droppedNode.equals(parentOfTargetNode)) continue;
            this.rejectDrag(dtde);
            return;
        }
        this.dropTargetNode = targetNode;
        dtde.acceptDrag(dtde.getDropAction());
        this.repaint();
    }

    private boolean areSelectedPathsInSameNode(TreePath[] selectedPaths2) {
        int size;
        if (this.selectedPaths != null && (size = this.selectedPaths.length) != 0) {
            DefaultMutableTreeNode parentOfFirstSelectedNode = (DefaultMutableTreeNode)this.selectedPaths[0].getParentPath().getLastPathComponent();
            for (int i = 1; i < size; ++i) {
                DefaultMutableTreeNode parentOfSelectedNode = (DefaultMutableTreeNode)this.selectedPaths[i].getParentPath().getLastPathComponent();
                if (parentOfSelectedNode.equals(parentOfFirstSelectedNode)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        boolean droppedNodeIsSelected;
        Object droppedObject;
        try {
            droppedObject = dtde.getTransferable().getTransferData(localObjectFlavor);
        }
        catch (Exception e) {
            e.printStackTrace();
            dtde.dropComplete(false);
            return;
        }
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        Point p = dtde.getLocation();
        TreePath targetPath = this.getPathForLocation(p.x, p.y);
        if (targetPath == null || !(droppedObject instanceof MutableTreeNode)) {
            dtde.dropComplete(false);
            return;
        }
        DefaultMutableTreeNode droppedNode = (DefaultMutableTreeNode)droppedObject;
        DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode)targetPath.getLastPathComponent();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)targetNode.getParent();
        if (targetNode.equals(droppedNode)) {
            dtde.dropComplete(false);
            return;
        }
        dtde.acceptDrop(2);
        TreePath pathOfDroppedNode = new TreePath(droppedNode.getPath());
        int size = -1;
        if (this.selectedPaths == null) {
            droppedNodeIsSelected = false;
        } else {
            size = this.selectedPaths.length;
            droppedNodeIsSelected = false;
            for (int i = 0; i < size; ++i) {
                if (!pathOfDroppedNode.equals(this.selectedPaths[i])) continue;
                droppedNodeIsSelected = true;
                int droppedNodeIndexInSelection = i;
                break;
            }
        }
        List<GSResource> resources = ((UsersNoteDirectory)parentNode.getUserObject()).getResources();
        int droppedNodeIndex = model.getIndexOfChild(parentNode, droppedNode);
        int targetNodeIndex = model.getIndexOfChild(parentNode, targetNode);
        if (!droppedNodeIsSelected || size == 1) {
            model.removeNodeFromParent(droppedNode);
            GSResource elm = resources.get(droppedNodeIndex);
            resources.remove(droppedNodeIndex);
            int insertionPointIndex = 0;
            if (droppedNodeIndex < targetNodeIndex) {
                insertionPointIndex = targetNodeIndex - 1;
            } else if (droppedNodeIndex > targetNodeIndex) {
                insertionPointIndex = targetNodeIndex;
            }
            resources.add(insertionPointIndex, elm);
            model.insertNodeInto(droppedNode, parentNode, insertionPointIndex);
            this.setSelectionPath(pathOfDroppedNode);
            ((UsersNoteDirectory)parentNode.getUserObject()).setResources(resources);
        } else {
            int i;
            int insertPointIndex = targetNodeIndex;
            MutableTreeNode[] tmpForJTree = new MutableTreeNode[size];
            GSResource[] tmpForUsersNoteTree = new GSResource[size];
            for (int i2 = 0; i2 < size; ++i2) {
                MutableTreeNode selectedNode;
                tmpForJTree[i2] = selectedNode = (MutableTreeNode)this.selectedPaths[i2].getLastPathComponent();
                tmpForUsersNoteTree[i2] = resources.get(model.getIndexOfChild(parentNode, selectedNode));
            }
            int insertionPointIndex = -1;
            int offset = 0;
            for (i = 0; i < size; ++i) {
                insertionPointIndex = targetNodeIndex;
                MutableTreeNode selectedNode = (MutableTreeNode)this.selectedPaths[i].getLastPathComponent();
                int selectedNodeIndex = model.getIndexOfChild(this.selectedPaths[i].getParentPath().getLastPathComponent(), selectedNode);
                GSResource elm = resources.get(selectedNodeIndex);
                model.removeNodeFromParent(selectedNode);
                resources.remove(selectedNodeIndex);
                if (selectedNodeIndex < insertionPointIndex) {
                    ++offset;
                    continue;
                }
                if (selectedNodeIndex < insertionPointIndex) continue;
            }
            insertionPointIndex -= offset;
            for (i = size - 1; i >= 0; --i) {
                resources.add(insertionPointIndex, tmpForUsersNoteTree[i]);
                model.insertNodeInto(tmpForJTree[i], parentNode, insertionPointIndex);
            }
            this.setSelectionPaths(this.selectedPaths);
            ((UsersNoteDirectory)parentNode.getUserObject()).setResources(resources);
        }
        WorkspaceWindow.getInstance().updateMoveToolBar();
        WorkspaceWindow.setUpdated(true);
        this.repaint();
        dtde.dropComplete(true);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        Point clickPoint = dge.getDragOrigin();
        TreePath path = this.getPathForLocation(clickPoint.x, clickPoint.y);
        if (path == null || path.getParentPath() == null) {
            return;
        }
        this.dragsourceTreePath = path;
        this.draggedNode = (TreeNode)path.getLastPathComponent();
        if (this.draggedNode instanceof DefaultMutableTreeNode) {
            UsersNoteTreeTransferable trans = new UsersNoteTreeTransferable(this.draggedNode);
            this.dragSource.startDrag(dge, Cursor.getDefaultCursor(), trans, this);
        }
    }

    private void rejectDrag(DropTargetDragEvent dtde) {
        dtde.rejectDrag();
        this.dropTargetNode = null;
        this.repaint();
    }

    public void sortSelectedItemsByName() {
        int i;
        int i2;
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        this.selectedPaths = null;
        this.selectedPaths = this.getSelectedPaths();
        int size = this.selectedPaths.length;
        if (size == 0) {
            return;
        }
        if (!this.areSelectedPathsInSameNode(this.selectedPaths)) {
            JOptionPane.showMessageDialog(singleton, "Items must be in the same directory");
            return;
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.selectedPaths[0].getParentPath().getLastPathComponent();
        List<GSResource> resources = ((UsersNoteDirectory)parentNode.getUserObject()).getResources();
        int[] indexes = new int[size];
        for (i2 = 0; i2 < size; ++i2) {
            indexes[i2] = parentNode.getIndex((DefaultMutableTreeNode)this.selectedPaths[i2].getLastPathComponent());
        }
        Arrays.sort(indexes);
        for (i2 = 0; i2 < size - 1; ++i2) {
            if (indexes[i2 + 1] <= indexes[i2] + 1) continue;
            JOptionPane.showMessageDialog(singleton, "Items must be consective:" + indexes[i2] + "," + indexes[i2 + 1] + "\n");
            return;
        }
        int insertionPointIndex = indexes[0];
        MutableTreeNode[] tmpForJTree = new MutableTreeNode[size];
        GSResource[] tmpForUsersNoteTree = new GSResource[size];
        for (i = 0; i < size; ++i) {
            MutableTreeNode selectedNode;
            tmpForJTree[i] = selectedNode = (MutableTreeNode)this.selectedPaths[i].getLastPathComponent();
            tmpForUsersNoteTree[i] = resources.get(model.getIndexOfChild(parentNode, selectedNode));
        }
        Arrays.sort(tmpForJTree, new DefaultMutableTreeNodeNameComparator());
        Arrays.sort(tmpForUsersNoteTree, new GSResourceNameComparator());
        for (i = size - 1; i >= 0; --i) {
            parentNode.remove(insertionPointIndex + i);
            resources.remove(insertionPointIndex + i);
        }
        for (i = size - 1; i >= 0; --i) {
            resources.add(insertionPointIndex, tmpForUsersNoteTree[i]);
            model.insertNodeInto(tmpForJTree[i], parentNode, insertionPointIndex);
        }
        ((UsersNoteDirectory)parentNode.getUserObject()).setResources(resources);
        WorkspaceWindow.setUpdated(true);
        this.updateUI();
        this.repaint();
    }

    public DefaultMutableTreeNode makeUsersNoteDirectory(DefaultMutableTreeNode parentTreeNode, String name) {
        Enumeration<TreeNode> enm = parentTreeNode.children();
        while (enm.hasMoreElements()) {
            String tmp = ((GSResource)((DefaultMutableTreeNode)enm.nextElement()).getUserObject()).getName();
            if (!tmp.equals(name)) continue;
            JOptionPane.showMessageDialog(null, String.format("Error: name %s already used in %s\n.", tmp, UsersNoteTree.makePathString(parentTreeNode.getPath())));
            return null;
        }
        UsersNoteDirectory parentUsersNoteDir = (UsersNoteDirectory)parentTreeNode.getUserObject();
        UsersNoteDirectory directory = new UsersNoteDirectory(parentUsersNoteDir, name);
        directory.setName(name);
        this.registeredUsersNoteDirectories.add(directory);
        parentUsersNoteDir.addResource(directory);
        DefaultMutableTreeNode directoryNode = new DefaultMutableTreeNode(directory);
        parentTreeNode.add(directoryNode);
        WorkspaceWindow.setUpdated(true);
        this.updateUI();
        this.repaint();
        return directoryNode;
    }

    public DefaultMutableTreeNode makeUsersNote(DefaultMutableTreeNode parentTreeNode, String noteName) {
        Enumeration<TreeNode> enm = parentTreeNode.children();
        while (enm.hasMoreElements()) {
            String tmp = ((GSResource)((DefaultMutableTreeNode)enm.nextElement()).getUserObject()).getName();
            if (!tmp.equals(noteName)) continue;
            JOptionPane.showMessageDialog(null, String.format("Error: name %s already used in %s\n.", tmp, UsersNoteTree.makePathString(parentTreeNode.getPath())));
            return null;
        }
        UsersNoteDirectory parentUsersNoteDir = (UsersNoteDirectory)parentTreeNode.getUserObject();
        UsersNote note = new UsersNote(parentUsersNoteDir, noteName);
        this.registeredUsersNotes.add(note);
        parentUsersNoteDir.addResource(note);
        DefaultMutableTreeNode noteNode = new DefaultMutableTreeNode(note);
        parentTreeNode.add(noteNode);
        this.updateUI();
        this.repaint();
        WorkspaceWindow.setUpdated(true);
        return noteNode;
    }

    public static String makePathString(TreeNode[] array_path) {
        StringBuffer tmp = new StringBuffer();
        int size = array_path.length;
        for (int i = 0; i < size; ++i) {
            tmp.append("/");
            tmp.append(array_path[i]);
        }
        return tmp.toString();
    }

    public void removeSelectedItems() {
        TreePath[] paths = this.getSelectedPaths();
        int size = paths.length;
        for (int i = 0; i < size; ++i) {
            GSResource item = (GSResource)((DefaultMutableTreeNode)paths[i].getLastPathComponent()).getUserObject();
            if (item == null) {
                return;
            }
            if (item instanceof UsersNote) {
                this.removeUsersNote(paths[i]);
            } else if (item instanceof UsersNoteDirectory) {
                this.removeDirectory(paths[i]);
            } else {
                System.out.print("Bug in UsersNoteTree");
            }
            WorkspaceWindow.setUpdated(true);
            this.repaint();
        }
    }

    public void removeUsersNote(TreePath path) {
        if (path == null) {
            return;
        }
        Object obj = path.getLastPathComponent();
        if (obj == null) {
            return;
        }
        UsersNote deleteUsersNote = (UsersNote)((DefaultMutableTreeNode)obj).getUserObject();
        if (deleteUsersNote == null) {
            return;
        }
        String nameStr = deleteUsersNote.toString();
        DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)targetNode.getParent();
        int smallest = Integer.MAX_VALUE;
        if (nameStr.indexOf(":") != -1) {
            String numberStr = nameStr.substring(0, nameStr.indexOf(":"));
            try {
                smallest = Integer.parseInt(numberStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        Enumeration<TreeNode> enumeration = parentNode.children();
        UsersNoteDirectory UsersNoteDirectory2 = (UsersNoteDirectory)parentNode.getUserObject();
        int deletecount = 0;
        boolean deleteflg = false;
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode childrenNode = (DefaultMutableTreeNode)enumeration.nextElement();
            String childrenStr = childrenNode.toString();
            if (childrenNode.getUserObject() instanceof UsersNote && childrenStr.equals(nameStr)) {
                deleteflg = true;
                this.removeLink(((UsersNote)childrenNode.getUserObject()).getURI());
                this.registeredUsersNotes.remove((UsersNote)childrenNode.getUserObject());
                UsersNoteDirectory2.remove((UsersNote)childrenNode.getUserObject());
                break;
            }
            ++deletecount;
        }
        if (!deleteflg) {
            return;
        }
        parentNode.remove(deletecount);
        WorkspaceWindow.setUpdated(true);
        this.updateUI();
        WorkspaceWindow.setUpdated(true);
        this.repaint();
    }

    public void removeDirectory(TreePath path) {
        if (path == null) {
            return;
        }
        Object obj = path.getLastPathComponent();
        if (obj == null) {
            return;
        }
        UsersNoteDirectory deleteDirectory = (UsersNoteDirectory)((DefaultMutableTreeNode)obj).getUserObject();
        if (deleteDirectory == null) {
            return;
        }
        List<UsersNoteDirectory> listdir = deleteDirectory.getUsersNoteDirectories();
        for (int i = 0; i < listdir.size(); ++i) {
            UsersNoteDirectory usersNoteDirectory = listdir.get(i);
            this.removeLink(usersNoteDirectory.getURI());
            this.registeredUsersNoteDirectories.remove(usersNoteDirectory);
        }
        List<UsersNote> listnote = deleteDirectory.getUsersNotes();
        for (int i = 0; i < listnote.size(); ++i) {
            UsersNote usersNote = listnote.get(i);
            this.removeLink(usersNote.getURI());
            this.registeredUsersNotes.remove(usersNote);
        }
        deleteDirectory.removeAllChildren();
        this.registeredUsersNoteDirectories.remove(deleteDirectory);
        this.removeLink(deleteDirectory.getURI());
        DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)targetNode.getParent();
        Object parentObject = parentNode.getUserObject();
        ((UsersNoteDirectory)parentObject).removeDirectory(deleteDirectory);
        parentNode.remove(targetNode);
        WorkspaceWindow.setUpdated(true);
        this.updateUI();
        this.repaint();
    }

    private void removeLink(String url) {
        LinkRemover.removeLinksOf(url);
    }

    public void clear() {
        this.registeredUsersNotes.clear();
        this.registeredUsersNoteDirectories.clear();
        this.rootNode.removeAllChildren();
        this.root.clear();
        this.updateUI();
        this.repaint();
    }

    public void changeNodeName(DefaultMutableTreeNode node, String newName) {
        ((GSResource)node.getUserObject()).setName(newName);
        WorkspaceWindow.setUpdated(true);
        this.updateUI();
        this.repaint();
    }

    public UsersNote getUsersNoteByTextSegmentURI(String uri) {
        String usersNoteURI = URIObject.getContainerURIFrom(uri);
        for (int i = 0; i < this.registeredUsersNotes.size(); ++i) {
            if (!this.registeredUsersNotes.get(i).getURI().equals(usersNoteURI)) continue;
            return this.registeredUsersNotes.get(i);
        }
        return null;
    }

    class UsersNoteTreeCellRenderer
    extends DefaultTreeCellRenderer {
        boolean isTargetNode;
        boolean isTargetNodeLeaf;
        boolean isLastItem;
        Insets normalInsets = super.getInsets();
        Insets lastItemInsets;
        int BOTTOM_PAD = 30;

        public UsersNoteTreeCellRenderer() {
            this.lastItemInsets = new Insets(this.normalInsets.top, this.normalInsets.left, this.normalInsets.bottom + this.BOTTOM_PAD, this.normalInsets.right);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
            this.isTargetNode = value == UsersNoteTree.this.dropTargetNode;
            this.isTargetNodeLeaf = this.isTargetNode && ((TreeNode)value).isLeaf();
            boolean showSelected = isSelected & UsersNoteTree.this.dropTargetNode == null;
            DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, row, hasFocus);
            if (value != null && value instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)value;
                Object obj = defaultMutableTreeNode.getUserObject();
                renderer.setText(((GSResource)obj).getName());
                if (obj != null && obj instanceof UsersNoteDirectory) {
                    Icon icon = renderer.getOpenIcon();
                    renderer.setIcon(icon);
                }
            }
            return renderer;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.isTargetNode) {
                g.setColor(Color.black);
                g.drawLine(0, 0, this.getSize().width, 0);
            }
        }
    }

    class UsersNoteTreeTransferable
    implements Transferable {
        Object object;

        public UsersNoteTreeTransferable(Object o) {
            this.object = o;
        }

        @Override
        public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(df)) {
                return this.object;
            }
            throw new UnsupportedFlavorException(df);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor df) {
            return df.getHumanPresentableName().equals(UsersNoteTree.NAME);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return supportedFlavors;
        }
    }
}

