/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.menu;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import smart_gs.logical.Preference;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.CanonicalPathString;

public class ExternalEditorSettingDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JLabel jLabel = null;
    private JTextField editorPath = null;
    private JButton selectButton = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JDialog jDialog;

    public ExternalEditorSettingDialog(Frame owner) {
        super(owner, true);
        this.initialize();
        this.jDialog = this;
    }

    private void initialize() {
        this.setSize(504, 108);
        this.setContentPane(this.getJContentPane());
        this.setTitle("Select Editor");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jLabel = new JLabel();
            this.jLabel.setBounds(new Rectangle(14, 11, 43, 16));
            this.jLabel.setText("Editor");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.jLabel, null);
            this.jContentPane.add((Component)this.getEditorPath(), null);
            this.jContentPane.add((Component)this.getSelectButton(), null);
            this.jContentPane.add((Component)this.getOkButton(), null);
            this.jContentPane.add((Component)this.getCancelButton(), null);
        }
        return this.jContentPane;
    }

    private JTextField getEditorPath() {
        if (this.editorPath == null) {
            this.editorPath = new JTextField();
            this.editorPath.setBounds(new Rectangle(58, 11, 308, 20));
            if (Preference.getInstance().getEditor() != null) {
                this.editorPath.setText(Preference.getInstance().getEditor());
            }
        }
        return this.editorPath;
    }

    private JButton getSelectButton() {
        if (this.selectButton == null) {
            this.selectButton = new JButton();
            this.selectButton.setText("select files...");
            this.selectButton.setBounds(new Rectangle(370, 11, 116, 20));
            this.selectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser();
                    int returnVal = chooser.showOpenDialog(WorkspaceWindow.getInstance());
                    try {
                        if (returnVal == 0) {
                            File file = chooser.getSelectedFile();
                            ExternalEditorSettingDialog.this.editorPath.setText(CanonicalPathString.get(file));
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            });
        }
        return this.selectButton;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setBounds(new Rectangle(108, 40, 100, 20));
            this.okButton.setText("OK");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String editor = ExternalEditorSettingDialog.this.editorPath.getText();
                    if (editor != null) {
                        Preference.getInstance().setEditor(editor);
                    }
                    ExternalEditorSettingDialog.this.jDialog.setVisible(false);
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setBounds(new Rectangle(225, 40, 100, 20));
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExternalEditorSettingDialog.this.jDialog.setVisible(false);
                }
            });
        }
        return this.cancelButton;
    }
}

