/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.reasoning_web.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.TimeZone;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import smart_gs.logical.FirstIDAT;
import smart_gs.logical.IDAT;
import smart_gs.logical.Region;
import smart_gs.logical.SecondIDAT;
import smart_gs.logical.Spread;
import smart_gs.logical.TextSegment;
import smart_gs.logical.URIObject;
import smart_gs.logical.UsersNote;
import smart_gs.menu.action.SpreadJumpAction;
import smart_gs.menu.action.SpreadOpenAction;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.InConstruction;

public class elementViewPanelListener
extends MouseAdapter {
    private GS_RWElement element;
    private JPanel panelOfLocalView;
    private JWindow window;
    private JPanel panelToDisplayInformation = new JPanel();

    public elementViewPanelListener(JPanel panel, GS_RWElement element) {
        this.element = element;
        this.panelOfLocalView = panel;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        if (this.element instanceof Region) {
            Region region = (Region)this.element;
            if (e.getButton() == 1) {
                if (WorkspaceWindow.getInstance().isAlt()) {
                    SpreadJumpAction.jumpToMarkup(region);
                } else {
                    SpreadOpenAction.openMarkup(region);
                }
            }
            if (e.getButton() == 3) {
                SpreadJumpAction.jumpToMarkup(region);
            }
        } else if (this.element instanceof TextSegment) {
            TextSegment segment = (TextSegment)this.element;
            if (e.getButton() == 1) {
                if (WorkspaceWindow.getInstance().isAlt()) {
                    SpreadJumpAction.jumpToMarkup(segment);
                } else {
                    SpreadOpenAction.openMarkup(segment);
                }
            }
            if (e.getButton() == 3) {
                SpreadJumpAction.jumpToMarkup(segment);
            }
        } else {
            InConstruction.message();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        String creationTime;
        String userName;
        String kind;
        super.mouseEntered(e);
        String uri = this.element.getURI();
        String[] token = uri.substring(8).split("/");
        TimeZone timeZone = TimeZone.getDefault();
        String toPrint = "";
        if (this.element instanceof Region) {
            kind = ((Region)this.element).getTypeStringForDisplay();
            userName = token[1];
            creationTime = URIObject.localizeDate(timeZone, token[2]) + " (" + timeZone.getID() + ")";
            String locationKind = "Image";
            String locationName = token[4];
            String locationPath = ((Region)this.element).getSpread().getFolderPath();
            locationPath = "/root/" + locationPath + locationName;
            toPrint = String.format("<html>Kind: %s<br>User: %s<br>Time: %s<br>Location Kind: %s<br>Spread Name: %s<br>Path: %s<br></html>", kind, userName, creationTime, locationKind, locationName, locationPath);
        } else if (this.element instanceof TextSegment) {
            kind = "Text Segment";
            userName = token[1];
            creationTime = URIObject.localizeDate(timeZone, token[2]) + " (" + timeZone.getID() + ")";
            String locationKind = token[3];
            if (locationKind.equals("^usersNote")) {
                locationKind = "Users' Note";
            } else if (locationKind.equals("^firstIdat")) {
                locationKind = "first IDAT";
            } else if (locationKind.equals("^secondIdat")) {
                locationKind = "second IDAT";
            } else if (locationKind.equals("^thirdIdat")) {
                locationKind = "third IDAT";
            }
            if (locationKind.equals("Users' Note")) {
                String noteName = token[4];
                UsersNote note = (UsersNote)((TextSegment)this.element).getDocument();
                String notePath = "/root/" + note.getFolderPath() + noteName;
                toPrint = String.format("<html>Kind: %s<br>User: %s<br>Time: %s<br>Location Kind: %s<br>Note Name: %s<br>Path: %s<br></html>", kind, userName, creationTime, locationKind, noteName, notePath);
            } else {
                String spreadName = token[7];
                TextSegment seg = (TextSegment)this.element;
                IDAT idat = (IDAT)seg.getDocument();
                Spread spread = idat.getSpread();
                String idatName = idat instanceof FirstIDAT ? spread.getFirstIDATName() : (idat instanceof SecondIDAT ? spread.getSecondIDATName() : spread.getThirdIDATName());
                String spreadPath = spread.getFolderPath();
                spreadPath = "/root/" + spreadPath + spreadName;
                toPrint = String.format("<html>Kind: %s<br>User: %s<br>Time: %s<br>Location Kind: %s<br>IDAT Name: %s<br>Spread Name: %s<br>Spread Path: %s<br></html>", kind, userName, creationTime, locationKind, idatName, spreadName, spreadPath);
            }
        } else {
            InConstruction.message();
            toPrint = "";
        }
        JLabel label = new JLabel(toPrint);
        this.panelToDisplayInformation.add((Component)label, "Center");
        if (this.window == null) {
            this.window = new JWindow();
        }
        this.window.getContentPane().setLayout(new BorderLayout());
        this.window.getContentPane().add((Component)label, "Center");
        Point orig_p = this.panelOfLocalView.getLocationOnScreen();
        Point p = new Point(orig_p.x + 140 + 10, orig_p.y);
        this.window.setLocation(p);
        this.window.pack();
        this.window.setVisible(true);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.window != null) {
            this.window.setVisible(false);
        }
    }
}

