/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.spread_selection;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadDirectory;
import smart_gs.logical.SpreadTree;
import smart_gs.spread_selection.CheckBoxNode;
import smart_gs.spread_selection.CheckBoxNodeEditor;
import smart_gs.spread_selection.CheckBoxNodeRenderer;

public class SpreadSelectionTree
extends JTree {
    private DefaultMutableTreeNode rootNode;

    public SpreadSelectionTree() {
        DefaultMutableTreeNode spreadTreeRootNode = SpreadTree.getInstance().getRootNode();
        this.rootNode = this.selectionTreeRootNode(spreadTreeRootNode);
        JTree tmpTree = new JTree(this.rootNode);
        this.setModel(tmpTree.getModel());
        ((DefaultTreeModel)this.getModel()).reload();
        CheckBoxNodeRenderer renderer = new CheckBoxNodeRenderer();
        this.setCellRenderer(renderer);
        this.setCellEditor(new CheckBoxNodeEditor(this));
        this.setEditable(true);
    }

    public ArrayList<Integer> selectionList() {
        return new SelectionListCollector().collect();
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.rootNode;
    }

    private DefaultMutableTreeNode selectionTreeRootNode(DefaultMutableTreeNode node) {
        Object usrObj = node.getUserObject();
        DefaultMutableTreeNode resultNode = null;
        if (usrObj instanceof Spread) {
            resultNode = new DefaultMutableTreeNode(new CheckBoxNode(((Spread)usrObj).toString(), false, ((Spread)usrObj).getPageViewIndex()));
        } else if (usrObj instanceof SpreadDirectory) {
            resultNode = new DefaultMutableTreeNode(((SpreadDirectory)usrObj).toString());
            Enumeration<TreeNode> enumeration = node.children();
            while (enumeration.hasMoreElements()) {
                resultNode.add(this.selectionTreeRootNode((DefaultMutableTreeNode)enumeration.nextElement()));
            }
        } else {
            System.out.println("Illegal Spread Tree");
        }
        return resultNode;
    }

    class SelectionListCollector {
        ArrayList<Integer> selectionList = new ArrayList();

        SelectionListCollector() {
        }

        ArrayList<Integer> collect() {
            this.selectionList.clear();
            this.collectIndexsOfCheckedSpreads(SpreadSelectionTree.this.rootNode);
            return this.selectionList;
        }

        void collectIndexsOfCheckedSpreads(DefaultMutableTreeNode parentNode) {
            Enumeration<TreeNode> enumeration = parentNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode childrenNode = (DefaultMutableTreeNode)enumeration.nextElement();
                Object usrObj = childrenNode.getUserObject();
                if (usrObj instanceof CheckBoxNode) {
                    if (!((CheckBoxNode)usrObj).isSelected()) continue;
                    Integer index = ((CheckBoxNode)usrObj).getIndex();
                    this.selectionList.add(index);
                    continue;
                }
                this.collectIndexsOfCheckedSpreads(childrenNode);
            }
        }
    }
}

