/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.swingui.toolbar;

import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JRadioButton;
import javax.swing.JToolBar;
import smart_gs.drawing_tool.action.LineSegEditorChangeSizeAction;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.toolbar.ImageToolBarComponent;
import smart_gs.swingui.toolbar.action.DeleteDscFileAction;
import smart_gs.swingui.toolbar.action.DeleteLineSegmentsFileAction;
import smart_gs.swingui.toolbar.action.DscCompileAction;
import smart_gs.swingui.toolbar.action.ImportDscFileAction;
import smart_gs.swingui.toolbar.action.LineSegDscInformationAction;
import smart_gs.swingui.toolbar.action.LineSegEditorChangeIndexActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorCutActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorDefaultActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorDeleteActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorDrawActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorSemiAutomaticLineSegmentationActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorShowLinesActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorUndoActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorZoomInOutActionListener;
import smart_gs.swingui.toolbar.action.ReadSegmentInfoAction;
import smart_gs.swingui.toolbar.action.SaveLineSegmentsAction;
import smart_gs.swingui.toolbar.action.SaveLineSegmentsAndDscCompileAction;
import smart_gs.swingui.toolbar.action.SaveLineSegmentsInSegfoFormatAction;

public class LineSegEditorToolBar
extends JToolBar {
    ButtonGroup modeButtonGroup = new ButtonGroup();
    JRadioButton defaultbutton = new JRadioButton("Default");
    JRadioButton draw;
    JRadioButton cut;

    public LineSegEditorToolBar(LineSegEditor editor) {
        this.defaultbutton.addActionListener(new LineSegEditorDefaultActionListener(editor));
        this.defaultbutton.setToolTipText("Default Mode");
        this.add(this.defaultbutton);
        this.modeButtonGroup.add(this.defaultbutton);
        this.draw = new JRadioButton("Draw");
        this.draw.addActionListener(new LineSegEditorDrawActionListener(editor));
        this.draw.setToolTipText("Draw Line Segment Mode");
        this.add(this.draw);
        this.modeButtonGroup.add(this.draw);
        this.draw = new JRadioButton("Auto");
        this.draw.addActionListener(new LineSegEditorSemiAutomaticLineSegmentationActionListener(editor));
        this.draw.setToolTipText("Semi-auto Draw Line Segment Mode");
        this.add(this.draw);
        this.modeButtonGroup.add(this.draw);
        this.cut = new JRadioButton("Cut");
        this.cut.addActionListener(new LineSegEditorCutActionListener(editor, this));
        this.cut.setToolTipText("Cut Line Segment");
        this.add(this.cut);
        this.modeButtonGroup.add(this.cut);
        JButton move = new JButton("Change");
        move.addActionListener(new LineSegEditorChangeIndexActionListener(editor));
        move.setToolTipText("Change Index");
        this.add(move);
        JButton delete = new JButton("Delete");
        delete.addActionListener(new LineSegEditorDeleteActionListener(editor));
        delete.setToolTipText("Delete Line");
        this.add(delete);
        JButton undo = new JButton("Undo");
        undo.addActionListener(new LineSegEditorUndoActionListener(editor));
        undo.setToolTipText("Undo the last change on line segments");
        this.add(undo);
        JButton linesegshow = new JButton(new ImageIcon("./icons/linesegment.png"));
        linesegshow.addActionListener(new LineSegEditorShowLinesActionListener(editor));
        linesegshow.setToolTipText("Line Segment Display Mode");
        this.add(linesegshow);
        ZoomIn zoomIn = new ZoomIn(new ImageIcon("./icons/zoom_in.gif"));
        zoomIn.addActionListener(new LineSegEditorZoomInOutActionListener(editor, "ZoomIn"));
        zoomIn.setToolTipText("Zoom in");
        this.add(zoomIn);
        ZoomOut zoomOut = new ZoomOut(new ImageIcon("./icons/zoom_out.gif"));
        zoomOut.addActionListener(new LineSegEditorZoomInOutActionListener(editor, "ZoomOut"));
        zoomOut.setToolTipText("Zoom out");
        this.add(zoomOut);
        JButton changeSize = new JButton("Zoom & Move");
        changeSize.addActionListener(new LineSegEditorChangeSizeAction(editor));
        changeSize.setToolTipText("Change Size");
        this.add(changeSize);
        JButton saveLSeg = new JButton("Save");
        saveLSeg.addActionListener(new SaveLineSegmentsAction(editor));
        saveLSeg.setToolTipText("Save Line Segments");
        this.add(saveLSeg);
        JButton readLSegSegfo = new JButton("Read Segfo File");
        readLSegSegfo.addActionListener(new ReadSegmentInfoAction(editor));
        readLSegSegfo.setToolTipText("Read Segfo File");
        this.add(readLSegSegfo);
        JButton saveLSegSegfo = new JButton("Save as Segfo File");
        saveLSegSegfo.addActionListener(new SaveLineSegmentsInSegfoFormatAction(editor));
        saveLSegSegfo.setToolTipText("Save as Segfo File");
        this.add(saveLSegSegfo);
        JButton infoLSeg = new JButton("Line Seg & DSC Info");
        infoLSeg.addActionListener(new LineSegDscInformationAction(editor));
        infoLSeg.setToolTipText("Line Seg & DSC Information");
        this.add(infoLSeg);
        JButton deleteLSeg = new JButton("Delete Line Seg File");
        deleteLSeg.addActionListener(new DeleteLineSegmentsFileAction(editor));
        deleteLSeg.setToolTipText("Delete Line Segments File");
        this.add(deleteLSeg);
        JButton createDSC = new JButton("Make DSC File");
        createDSC.addActionListener(new DscCompileAction(editor));
        createDSC.setToolTipText("Make DSC File");
        this.add(createDSC);
        JButton createLineSegAndDSC = new JButton("Save Line Seg & Make DSC File");
        createLineSegAndDSC.addActionListener(new SaveLineSegmentsAndDscCompileAction(editor));
        createLineSegAndDSC.setToolTipText("Save Line Seg & Make DSC File");
        this.add(createLineSegAndDSC);
        JButton deleteDSC = new JButton("Delete DSC File");
        deleteDSC.addActionListener(new DeleteDscFileAction(editor));
        deleteDSC.setToolTipText("Delete DSC File");
        this.add(deleteDSC);
        JButton importDSC = new JButton("Import DSC File");
        importDSC.addActionListener(new ImportDscFileAction(editor));
        importDSC.setToolTipText("Import DSC File");
        this.add(importDSC);
    }

    public void initializeButtonGroup() {
        this.defaultbutton.setEnabled(true);
        this.draw.setEnabled(true);
        this.cut.setEnabled(true);
        this.defaultbutton.setSelected(true);
    }

    public void disableDefautlAndDraw() {
        this.defaultbutton.setEnabled(false);
        this.draw.setEnabled(false);
    }

    private class ZoomOut
    extends JButton
    implements ImageToolBarComponent {
        ZoomOut(ImageIcon imageIcon) {
            super(imageIcon);
        }

        @Override
        public ImageToolBarComponent.IMAGETOOLBARCOMPONENT_TYPE getImageToolBarComponentType() {
            return ImageToolBarComponent.IMAGETOOLBARCOMPONENT_TYPE.ZOOM_OUT;
        }
    }

    private class ZoomIn
    extends JButton
    implements ImageToolBarComponent {
        ZoomIn(ImageIcon imageIcon) {
            super(imageIcon);
        }

        @Override
        public ImageToolBarComponent.IMAGETOOLBARCOMPONENT_TYPE getImageToolBarComponentType() {
            return ImageToolBarComponent.IMAGETOOLBARCOMPONENT_TYPE.ZOOM_IN;
        }
    }
}

