/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import smart_gs.logical.LineSegmentForEdit;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.LineSegEditor;

public class LineSegEditorChangeIndexActionListener
implements ActionListener {
    LineSegEditor editor;
    private final String iputExp = "[ \t]*[1-9][0-9]*[ \t]*>[ \t]*[1-9][0-9]*[ \t]*";
    private Pattern patternInputExp;

    public LineSegEditorChangeIndexActionListener(LineSegEditor editor) {
        this.editor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.editor.pushLinestack();
        String input = JOptionPane.showInputDialog("Specify change. E.g. 7>3 to change 7tn line to 3rd", (Object)"");
        if (input == null) {
            return;
        }
        this.patternInputExp = Pattern.compile("[ \t]*[1-9][0-9]*[ \t]*>[ \t]*[1-9][0-9]*[ \t]*");
        Matcher matcherZenkakuOrAscii = this.patternInputExp.matcher(input);
        if (!matcherZenkakuOrAscii.matches()) {
            JOptionPane.showMessageDialog(this.editor, "Input must be the form: in0dex>index");
        }
        int index = input.indexOf(62);
        int oldIndex = Integer.parseInt(input.substring(0, index));
        int newIndex = Integer.parseInt(input.substring(index + 1, input.length()));
        Spread spread = this.editor.getSpread();
        List<LineSegmentForEdit> lines = this.editor.getLinesForEdit();
        if (oldIndex == newIndex) {
            return;
        }
        int length = lines.size();
        if (oldIndex >= length) {
            JOptionPane.showMessageDialog(null, "Old index is out of range");
            return;
        }
        if (newIndex >= length) {
            JOptionPane.showMessageDialog(null, "New index is out of range");
            return;
        }
        LineSegmentForEdit tmp = lines.get(oldIndex);
        lines.remove(oldIndex);
        lines.add(newIndex, tmp);
        this.editor.rewriteLineSegIndexes();
        this.editor.repaint();
    }
}

