/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.swingui.tree.action;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import smart_gs.logical.Preference;
import smart_gs.logical.SpreadDirectory;
import smart_gs.logical.SpreadTree;
import smart_gs.logical.filter.ImageFileFilter;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.CanonicalPathString;
import smart_gs.util.GSStandardPath;

public class AddSpreadsAction
implements ActionListener {
    protected File openDirectory;
    protected SpreadTree tree = SpreadTree.getInstance();
    protected SpreadDirectory spreadDirectory;
    String imageFolderPath = GSStandardPath.toStandardOnCurrentOS(CanonicalPathString.get(new File(Preference.getInstance().getImageFolderPathString())));
    File imageFolder = new File(Preference.getInstance().getImageFolderPathString());

    public AddSpreadsAction(File openDirectory, SpreadTree tree, SpreadDirectory spreadDirectory) {
        this.openDirectory = openDirectory;
        this.tree = tree;
        this.spreadDirectory = spreadDirectory;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser(this.openDirectory);
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileFilter(new ImageFileFilter());
        chooser.setFileSelectionMode(0);
        int input = chooser.showOpenDialog(WorkspaceWindow.getInstance());
        if (input == 1) {
            return;
        }
        for (File file : chooser.getSelectedFiles()) {
            String fileToAddPath = CanonicalPathString.get(file);
            if (!(fileToAddPath = GSStandardPath.toStandardOnCurrentOS(fileToAddPath)).startsWith(this.imageFolderPath)) {
                JOptionPane.showMessageDialog(new Frame(), String.format("Image file %s \n is not in Image Folder %s.", fileToAddPath, this.imageFolderPath), "Information", -1);
                return;
            }
            String openDirPath = CanonicalPathString.get(this.openDirectory);
            String path = (openDirPath = GSStandardPath.toStandardOnCurrentOS(openDirPath)) + "/" + file.getName();
            if (!path.equals(fileToAddPath)) {
                JOptionPane.showMessageDialog(new Frame(), String.format("Image file %s \n is not in the directory specified", file.toString()), "Information", -1);
                return;
            }
            this.tree.addImage(file);
        }
    }
}

