/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.RegionNotify;
import smart_gs.drawing_tool.state.RegionSelectionState;
import smart_gs.logical.Region;
import smart_gs.smleditor.swingui.GSEditorFrame;
import smart_gs.util.ImageCropper;

public class RegionSelectionDialog
extends JDialog
implements RegionNotify {
    private JScrollPane scrollPane;
    private JPanel mainPanel;
    private JPanel entriesPanel;
    protected JPanel buttonPanel;
    protected JPanel southPanel;
    protected List<Region> regions = new ArrayList<Region>();
    protected JTextField selectionField = new JTextField(20);
    protected Region selectedRegion;
    protected JButton addRegionButton;

    public RegionSelectionDialog(GSEditorFrame parent) {
        super(parent.getFrame(), "Select Region");
        this.toFront();
        this.mainPanel = new JPanel(new BorderLayout());
        this.getContentPane().setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.mainPanel);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.entriesPanel = new JPanel(new GridLayout());
        this.mainPanel.add((Component)this.entriesPanel, "Center");
        JPanel p = new JPanel(new FlowLayout());
        this.addRegionButton = new JButton("Add Region");
        this.addRegionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RegionSelectionDialog.this.addRegion();
            }
        });
        p.add(this.addRegionButton);
        this.mainPanel.add((Component)p, "South");
        this.southPanel = new JPanel(new BorderLayout());
        this.buttonPanel = new JPanel();
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RegionSelectionDialog.this.ok();
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RegionSelectionDialog.this.cancel();
            }
        });
        this.buttonPanel.add(ok);
        this.buttonPanel.add(cancel);
        this.southPanel.add((Component)this.buttonPanel, "South");
        this.getContentPane().add((Component)this.southPanel, "South");
        this.setSize(400, 200);
        this.setLocationRelativeTo(null);
    }

    private void addRegion() {
        DefaultState.setDefaultState(RegionSelectionState.getInstance());
        ((RegionSelectionState)RegionSelectionState.getInstance()).addNotifyElement(this);
        this.select();
    }

    private void createEntry(Region region) {
        if (this.regions.contains(region)) {
            return;
        }
        this.regions.add(region);
        JPanel entryPanel = new JPanel(new FlowLayout(0));
        JPanel imagePanel = new JPanel();
        Image image = new ImageCropper(region).crop();
        JLabel label = new JLabel(new ImageIcon(image));
        imagePanel.add(label);
        entryPanel.add(imagePanel);
        entryPanel.setBorder(new TitledBorder(region.getURI()));
        GridLayout layout = (GridLayout)this.entriesPanel.getLayout();
        layout.setRows(layout.getRows() + 1);
        this.entriesPanel.add(entryPanel);
        this.setSize(400, 400);
        this.validate();
    }

    protected void ok() {
        DefaultState.restoreDefaultState();
        this.dispose();
    }

    protected void cancel() {
        DefaultState.restoreDefaultState();
        this.dispose();
    }

    protected void restore() {
        this.getContentPane().removeAll();
        DefaultState.restoreDefaultState();
        if (this.selectedRegion != null) {
            this.createEntry(this.selectedRegion);
        }
        this.selectedRegion = null;
        this.selectionField.setText("");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.getContentPane().add((Component)this.southPanel, "South");
        this.setSize(400, 500);
        this.validate();
    }

    public void select() {
        JPanel panel = new JPanel();
        panel.add(this.selectionField);
        JButton restore = new JButton("OK");
        restore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RegionSelectionDialog.this.restore();
            }
        });
        panel.add(restore);
        this.getContentPane().removeAll();
        this.getContentPane().add(panel);
        this.pack();
        this.validate();
    }

    @Override
    public void notifyRegionSelection(Region region) {
        this.selectionField.setText(region.getURI());
        this.selectedRegion = region;
    }
}

