/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.util;

import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import smart_gs.logical.TextSegment;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.util.ResourceNotify;
import sml_editor.swingui.EditorTextPane;
import sml_editor.swingui.mouse_state.MouseMode;

public class ResourceSelectionMode
extends MouseMode {
    private static ResourceSelectionMode singleton = new ResourceSelectionMode();
    private List<ResourceNotify> elements = new ArrayList<ResourceNotify>();

    private ResourceSelectionMode() {
    }

    public static ResourceSelectionMode getInstance() {
        return singleton;
    }

    public void addNotifyElement(ResourceNotify element) {
        this.elements.add(element);
    }

    @Override
    public void mouseClicked(MouseEvent e, EditorTextPane textPane) {
        super.mouseClicked(e, textPane);
        SimpleAttributeSet element = textPane.getSelectID(e.getPoint());
        if (element == null) {
            return;
        }
        TextSegment segment = ((GSEditorTextPane)textPane).getSmartDocument().getSegmentByID(new Integer((String)element.getAttribute(HTML.Attribute.HREF)));
        if (segment != null) {
            this.notifySelectedResource(segment);
        }
    }

    private void notifySelectedResource(TextSegment segment) {
        for (int i = 0; i < this.elements.size(); ++i) {
            this.elements.get(i).notifyResourceSelection(segment);
        }
    }
}

