/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.util;

import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import smart_gs.logical.LineSegment;
import smart_gs.logical.LineSegmentForEdit;
import smart_gs.logical.Spread;
import smart_gs.util.Pair;
import sml_editor.logical.LineDirection;

public class SegfoToLineConverter {
    private Spread spread;
    String file_name;

    public SegfoToLineConverter(Spread spread) {
        this.spread = spread;
        this.file_name = spread.getFileName();
    }

    public Pair<LineDirection, List<LineSegment>> getLines(File file) {
        return this.getLines(file, this.file_name);
    }

    public Pair<LineDirection, List<LineSegment>> getLines(File file, String file_name) {
        int i;
        String secondLineString;
        String firstLineString;
        LineDirection lineDirection = LineDirection.UNDEFINED;
        ArrayList<LineSegment> lines = new ArrayList<LineSegment>();
        StringBuffer bodyBufStr = new StringBuffer();
        try {
            String tmp_str;
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            firstLineString = br.readLine();
            if (firstLineString == null) {
                System.out.println("Someting wrong to read the first line of the file: " + file);
                return null;
            }
            secondLineString = br.readLine();
            if (secondLineString == null) {
                System.out.println("Someting wrong to read the second line of the file: " + file);
                return null;
            }
            if (!(secondLineString = secondLineString.trim()).equalsIgnoreCase("Horizontal") && !secondLineString.equalsIgnoreCase("Vertical")) {
                System.out.printf("The second line %s of the file is %s.%n It must be Vertical or Horizontal.%d", secondLineString, file);
            } else {
                LineDirection lineDirection2 = lineDirection = secondLineString.equalsIgnoreCase("Horizontal") ? LineDirection.HORIZONTAL : LineDirection.VERTICAL;
            }
            while ((tmp_str = br.readLine()) != null) {
                bodyBufStr.append(tmp_str);
                bodyBufStr.append('\t');
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Something wrong to read the file: " + file);
            return null;
        }
        int start = firstLineString.indexOf(file_name);
        for (i = 0; i < start; ++i) {
            if (Character.isWhitespace(firstLineString.indexOf(i))) continue;
            System.out.println(String.format("1st line \"%s\" does not match the spread file name: \"%s\"", firstLineString, file_name));
            return null;
        }
        for (i = start + file_name.length(); i < firstLineString.length(); ++i) {
            if (Character.isWhitespace(firstLineString.indexOf(i))) continue;
            System.out.println(String.format("1st line \"%s\" does not match the spread file name: \"%s\"", firstLineString, file_name));
            return null;
        }
        if (!secondLineString.equalsIgnoreCase("Horizontal") && !secondLineString.equalsIgnoreCase("Vertical")) {
            System.out.printf("The second line %s of the file is %s.%n It must be Vertical or Horizontal.%d", secondLineString, file);
        } else {
            lineDirection = secondLineString.equalsIgnoreCase("Horizontal") ? LineDirection.HORIZONTAL : LineDirection.VERTICAL;
        }
        String file_contents = bodyBufStr.toString();
        String[] tokenArray = file_contents.split("[\\x20\\u0009\\u000D]+");
        ArrayList<Integer> intList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < tokenArray.length; ++i2) {
            if (tokenArray[i2].isEmpty()) {
                ++i2;
            }
            try {
                int tmpInt = Integer.parseInt(tokenArray[i2]);
                intList.add(tmpInt);
                continue;
            }
            catch (NumberFormatException e) {
                System.out.println(String.format("%d-th element %d of  \"%s\" cannot be parsed as an integer", i2, file_name, tokenArray[i2]));
                return null;
            }
        }
        if ((Integer)intList.get(intList.size() - 1) != -99999) {
            System.out.println(String.format("The last token should be -99999, but is %d in  \"%s\" ", intList.get(intList.size()), file_name));
        }
        intList.remove(intList.size() - 1);
        ArrayList<Point2D> tmpPointsList = new ArrayList<Point2D>();
        int size = intList.size();
        int index = 0;
        for (int i3 = 0; i3 < size; ++i3) {
            int tmpIntX = (Integer)intList.get(i3);
            if (tmpIntX == -1) {
                if (tmpPointsList.isEmpty()) {
                    System.out.println(String.format("The line ends with %d-th element -1 is empty", i3));
                    return null;
                }
                lines.add(new LineSegment(this.spread, tmpPointsList, index));
                ++index;
                tmpPointsList = new ArrayList();
                continue;
            }
            if (tmpIntX < 0) {
                System.out.println(String.format("%d-th integer %d (x-axis) in the body is negative ", i3, tmpIntX));
            }
            if (++i3 >= size) {
                System.out.println(String.format("The data did not end with -1", new Object[0]));
                return null;
            }
            int tmpIntY = (Integer)intList.get(i3);
            if (tmpIntY < 0) {
                System.out.println(String.format("%d-th integer (y-axis) %d in the body is negative ", i3, tmpIntX));
            }
            tmpPointsList.add(new Point2D.Double(tmpIntX, tmpIntY));
        }
        return new Pair<LineDirection, List<LineSegment>>(lineDirection, lines);
    }

    public List<LineSegmentForEdit> getLinesForEdit(File file) {
        return this.getLinesForEdit(file, this.file_name);
    }

    public List<LineSegmentForEdit> getLinesForEdit(File file, String file_name) {
        int i;
        String secondLineString;
        String firstLineString;
        LineDirection lineDirection = LineDirection.UNDEFINED;
        ArrayList<LineSegmentForEdit> lines = new ArrayList<LineSegmentForEdit>();
        StringBuffer bodyBufStr = new StringBuffer();
        try {
            String tmp_str;
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            firstLineString = br.readLine();
            if (firstLineString == null) {
                System.out.println("Someting wrong to read the first line of the file: " + file);
                return null;
            }
            secondLineString = br.readLine();
            if (secondLineString == null) {
                System.out.println("Someting wrong to read the second line of the file: " + file);
                return null;
            }
            while ((tmp_str = br.readLine()) != null) {
                bodyBufStr.append(tmp_str);
                bodyBufStr.append('\t');
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Something wrong to read the file: " + file);
            return null;
        }
        int start = firstLineString.indexOf(file_name);
        for (i = 0; i < start; ++i) {
            if (Character.isWhitespace(firstLineString.indexOf(i))) continue;
            System.out.println(String.format("1st line \"%s\" does not match the spread file name: \"%s\"", firstLineString, file_name));
            return null;
        }
        for (i = start + file_name.length(); i < firstLineString.length(); ++i) {
            if (Character.isWhitespace(firstLineString.indexOf(i))) continue;
            System.out.println(String.format("1st line \"%s\" does not match the spread file name: \"%s\"", firstLineString, file_name));
            return null;
        }
        if (!secondLineString.equalsIgnoreCase("Horizontal") && !secondLineString.equalsIgnoreCase("Vertical")) {
            System.out.printf("The second line %s of the file is %s.%n It must be Vertical or Horizontal.%d", secondLineString, file);
        } else {
            lineDirection = secondLineString.equalsIgnoreCase("Horizontal") ? LineDirection.HORIZONTAL : LineDirection.VERTICAL;
        }
        String file_contents = bodyBufStr.toString();
        String[] tokenArray = file_contents.split("[\\x20\\u0009\\u000D]+");
        ArrayList<Integer> intList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < tokenArray.length; ++i2) {
            if (tokenArray[i2].isEmpty()) {
                ++i2;
            }
            try {
                int tmpInt = Integer.parseInt(tokenArray[i2]);
                intList.add(tmpInt);
                continue;
            }
            catch (NumberFormatException e) {
                System.out.println(String.format("%d-th element %d cannot be parsed as an integer", i2, tokenArray[i2]));
                return null;
            }
        }
        if ((Integer)intList.get(intList.size() - 1) != -99999) {
            System.out.println(String.format("The last token should be -99999, but is %d", intList.get(intList.size())));
        }
        intList.remove(intList.size() - 1);
        ArrayList<Point2D> tmpPointsList = new ArrayList<Point2D>();
        int size = intList.size();
        for (int i3 = 0; i3 < size; ++i3) {
            int tmpIntX = (Integer)intList.get(i3);
            if (tmpIntX == -1) {
                if (tmpPointsList.isEmpty()) {
                    System.out.println(String.format("The line ends with %d-th element -1 is empty", i3));
                    return null;
                }
                lines.add(new LineSegmentForEdit(tmpPointsList, lineDirection));
                tmpPointsList = new ArrayList();
                continue;
            }
            if (tmpIntX < 0) {
                System.out.println(String.format("%d-th integer %d (x-axis) in the body is negative ", i3, tmpIntX));
            }
            if (++i3 >= size) {
                System.out.println(String.format("The data did not end with -1", new Object[0]));
                return null;
            }
            int tmpIntY = (Integer)intList.get(i3);
            if (tmpIntY < 0) {
                System.out.println(String.format("%d-th integer (y-axis) %d in the body is negative ", i3, tmpIntX));
            }
            tmpPointsList.add(new Point2D.Double(tmpIntX, tmpIntY));
        }
        return lines;
    }
}

