/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.util;

import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import smart_gs.logical.LineSegment;
import smart_gs.logical.LineSegmentForEdit;
import smart_gs.logical.Spread;
import smart_gs.util.Pair;
import sml_editor.logical.LineDirection;

public class XMLToLineConverter {
    private Spread spread;

    public XMLToLineConverter(Spread spread) {
        this.spread = spread;
    }

    public Pair<LineDirection, List<LineSegment>> getLines(File file) {
        LineDirection lineDirection = LineDirection.UNDEFINED;
        ArrayList<LineSegment> results_lines = new ArrayList<LineSegment>();
        DocumentBuilder builder = null;
        Document document = null;
        try {
            String tmp0;
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = builder.parse(file);
            NodeList line_direction_nodes = document.getElementsByTagName("lineDirection");
            if (line_direction_nodes == null || line_direction_nodes.getLength() != 1) {
                System.out.printf("Line Direction in %s is not given%n", file);
                return null;
            }
            if (line_direction_nodes.item(0).getNodeType() != 1 || line_direction_nodes.item(0).getChildNodes().getLength() != 1 || line_direction_nodes.item(0).getFirstChild().getNodeType() != 3) {
                System.out.printf("Line Direction format in %s is illegal%n", new Object[0]);
            }
            if (!(tmp0 = line_direction_nodes.item(0).getFirstChild().getNodeValue().trim()).equalsIgnoreCase("horizontal") && !tmp0.equalsIgnoreCase("vertical")) {
                System.out.printf("Line Direction $s in %s is illegal%n", tmp0, file);
                return null;
            }
            if (tmp0.equalsIgnoreCase("horizontal")) {
                lineDirection = LineDirection.HORIZONTAL;
            }
            if (tmp0.equalsIgnoreCase("vertical")) {
                lineDirection = LineDirection.VERTICAL;
            }
            NodeList lines = document.getElementsByTagName("vertexes");
            for (int i = 0; i < lines.getLength(); ++i) {
                if (lines.item(i).getNodeType() != 1) continue;
                LineSegment segment = this.getLineSegment((Element)lines.item(i), i);
                results_lines.add(segment);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return new Pair<LineDirection, List<LineSegment>>(lineDirection, results_lines);
    }

    private LineSegment getLineSegment(Element element, int index) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        String uri = element.getAttribute("uri");
        String originalURI = element.getAttribute("originalURI");
        NodeList nodes = element.getElementsByTagName("vertex");
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (nodes.item(i).getNodeType() != 1) continue;
            Element e = (Element)nodes.item(i);
            NodeList childs = e.getChildNodes();
            for (int j = 0; j < childs.getLength(); ++j) {
                if (childs.item(j).getNodeType() != 1) continue;
                Element elem = (Element)childs.item(j);
                if (elem.getNodeName().equals("x")) {
                    x = new Double(elem.getTextContent());
                    continue;
                }
                if (!elem.getNodeName().equals("y")) continue;
                y = new Double(elem.getTextContent());
                points.add(new Point2D.Double(x, y));
            }
        }
        return new LineSegment(this.spread, points, uri, originalURI, index);
    }

    public List<LineSegmentForEdit> getLinesForEdit(File file) {
        ArrayList<LineSegmentForEdit> results = new ArrayList<LineSegmentForEdit>();
        DocumentBuilder builder = null;
        Document document = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = builder.parse(file);
            NodeList lines = document.getElementsByTagName("vertexes");
            for (int i = 0; i < lines.getLength(); ++i) {
                if (lines.item(i).getNodeType() != 1) continue;
                LineSegmentForEdit segment = this.getLineSegmentForEdit((Element)lines.item(i), i);
                results.add(segment);
            }
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            // empty catch block
        }
        return results;
    }

    private LineSegmentForEdit getLineSegmentForEdit(Element element, int index) {
        LineDirection lineDirection;
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        NodeList nodes = element.getElementsByTagName("vertex");
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (nodes.item(i).getNodeType() != 1) continue;
            Element e = (Element)nodes.item(i);
            NodeList childs = e.getChildNodes();
            for (int j = 0; j < childs.getLength(); ++j) {
                if (childs.item(j).getNodeType() != 1) continue;
                Element elem = (Element)childs.item(j);
                if (elem.getNodeName().equals("x")) {
                    x = new Double(elem.getTextContent());
                    continue;
                }
                if (!elem.getNodeName().equals("y")) continue;
                y = new Double(elem.getTextContent());
                points.add(new Point2D.Double(x, y));
            }
        }
        NodeList nodes2 = element.getElementsByTagName("lineDirection");
        Element e = (Element)nodes2.item(0);
        if (e.getNodeType() != 3) {
            System.out.printf("Illegal XML line specification for spread %s", this.spread);
            return null;
        }
        String lineDirectionType = e.getNodeValue();
        if (lineDirectionType.equals("Horizontal")) {
            lineDirection = LineDirection.HORIZONTAL;
        } else if (lineDirectionType.equals("Vertical")) {
            lineDirection = LineDirection.VERTICAL;
        } else {
            System.out.printf("Illegal XML line specification for spread %s: %s", this.spread, lineDirectionType);
            return null;
        }
        return new LineSegmentForEdit(points, lineDirection, index);
    }
}

