/*
 * Decompiled with CFR 0.152.
 */
package sml_editor.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SMLParser {
    public static Document parse(String source) throws SAXException {
        StringReader reader = new StringReader(source);
        InputSource in = new InputSource(reader);
        return SMLParser.parse(in);
    }

    public static Document parse(File file) throws SAXException, FileNotFoundException {
        FileInputStream input = new FileInputStream(file);
        InputSource in = new InputSource(input);
        return SMLParser.parse(in);
    }

    private static Document parse(InputSource in) throws SAXException {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
            if (document == null) {
                return null;
            }
            Element root = document.getDocumentElement();
            SMLParser.convert(root, document);
            return document;
        }
        catch (SAXException e) {
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void convert(Element elem, Document doc) {
        Node child = elem.getFirstChild();
        if (child == null) {
            elem.appendChild(doc.createTextNode(""));
            return;
        }
        while (child != null) {
            switch (child.getNodeType()) {
                case 1: {
                    if (((Element)child).getTagName().equalsIgnoreCase("br")) break;
                    SMLParser.convert((Element)child, doc);
                    break;
                }
                case 3: {
                    String str = child.getNodeValue();
                    str = str.replace('\n', ' ');
                    child.setNodeValue(str);
                }
            }
            child = child.getNextSibling();
        }
    }
}

