/*
 * Decompiled with CFR 0.152.
 */
package webdav;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import webdav.WebDavSyncData;
import webdav.WebDavSyncDownloadInfo;

public class WebDavSyncProgressBar
extends JDialog {
    private JPanel panel;
    private JLabel label;
    private JProgressBar pbar;
    private JDialog myJDialog;
    private AtomicInteger counter = new AtomicInteger();
    private boolean end = true;
    private int max;
    protected WebDavSyncData webDavSyncData;
    protected ArrayList downloadInfoList = new ArrayList();
    protected boolean cancel = false;

    public WebDavSyncProgressBar(JFrame jframe, WebDavSyncData webDavSyncData, String title, int min, final int max) {
        super(jframe, title, true);
        this.initialize();
        this.max = max;
        this.setLayout(new FlowLayout());
        Container container = this.getContentPane();
        container.setLayout(new FlowLayout());
        this.pbar = new JProgressBar(min, min, max);
        this.pbar.setStringPainted(true);
        this.pbar.setIndeterminate(false);
        this.label = new JLabel("");
        GridLayout gridLayout = new GridLayout();
        gridLayout.setRows(2);
        JPanel jContentPane = new JPanel();
        jContentPane.setLayout(gridLayout);
        jContentPane.add(this.pbar);
        jContentPane.add(this.label);
        this.setContentPane(jContentPane);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                while (WebDavSyncProgressBar.this.counter.intValue() <= max) {
                    WebDavSyncProgressBar.this.pbar.setValue(WebDavSyncProgressBar.this.counter.intValue());
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!WebDavSyncProgressBar.this.cancel) continue;
                }
                WebDavSyncProgressBar.this.label.setText("completed job");
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                WebDavSyncProgressBar.this.myJDialog.setVisible(false);
                if (WebDavSyncProgressBar.this.counter.intValue() != 0) {
                    String cancelMsg = "";
                    if (WebDavSyncProgressBar.this.cancel) {
                        cancelMsg = "It was canceled.\r\n";
                    }
                    JOptionPane.showMessageDialog(new JFrame(), cancelMsg + "Please reboot SMART-GS.");
                }
            }
        };
        new Thread(task).start();
        this.myJDialog = this;
        this.webDavSyncData = webDavSyncData;
    }

    public void countup() {
        this.counter.incrementAndGet();
    }

    public void setLabel(String str) {
        this.label.setText(str);
    }

    public void setDownloadInfoList(ArrayList downloadInfoList) {
        this.downloadInfoList = downloadInfoList;
    }

    public void sync() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                for (int n = 0; n < WebDavSyncProgressBar.this.downloadInfoList.size(); ++n) {
                    WebDavSyncDownloadInfo webDavSyncDownloadInfo = (WebDavSyncDownloadInfo)WebDavSyncProgressBar.this.downloadInfoList.get(n);
                    String path = webDavSyncDownloadInfo.getPath();
                    ArrayList downloadList = webDavSyncDownloadInfo.getDownloadList();
                    for (int i = 0; i < downloadList.size(); ++i) {
                        WebDavSyncData.DownLoadSyncInfo downLoadSyncInfo = (WebDavSyncData.DownLoadSyncInfo)downloadList.get(i);
                        WebDavSyncData.SyncInfo syncInfo = downLoadSyncInfo.getSyncInfo();
                        String downloadpath = syncInfo.getPropFindInfo().getPath();
                        String downloadfile = syncInfo.getPropFindInfo().getDisplayname();
                        if (!downLoadSyncInfo.getSyncInfo().getPropFindInfo().isDirectory()) {
                            WebDavSyncProgressBar.this.setLabel(downloadpath + downloadfile);
                        } else {
                            WebDavSyncProgressBar.this.setLabel(downloadpath);
                        }
                        WebDavSyncProgressBar.this.webDavSyncData.download(downLoadSyncInfo.getKey(), path, downLoadSyncInfo.getSyncInfo());
                        if (WebDavSyncProgressBar.this.cancel) {
                            WebDavSyncProgressBar.this.end = false;
                            return;
                        }
                        WebDavSyncProgressBar.this.countup();
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    WebDavSyncProgressBar.this.countup();
                }
                WebDavSyncProgressBar.this.end = false;
            }
        };
        new Thread(task).start();
    }

    public void join() {
        while (this.end) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void end() {
        this.counter = new AtomicInteger(this.max);
    }

    private void initialize() {
        this.setSize(new Dimension(361, 91));
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel = true;
            this.join();
            this.setVisible(false);
        }
    }
}

