/*
 * Decompiled with CFR 0.152.
 */
package webdav.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class PropFindRenderer
extends Box
implements TableCellRenderer {
    private static final Border noFocusBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private final ImageIcon foldericon1;
    private final ImageIcon foldericon2;
    private final ImageIcon file1icon1;
    private final ImageIcon file1icon2;
    private final ImageIcon file2icon1;
    private final ImageIcon file2icon2;
    private final ImageIcon nicon;
    private final ImageIcon sicon;
    private final JLabel textLabel = new JLabel("dummy");
    private final JLabel iconLabel;

    public PropFindRenderer(JTable table) {
        super(0);
        this.textLabel.setOpaque(true);
        this.textLabel.setBorder(noFocusBorder);
        this.nicon = new ImageIcon(this.getClass().getResource("folder.png"));
        this.foldericon1 = new ImageIcon(this.getClass().getResource("folder.png"));
        FilteredImageSource fis = new FilteredImageSource(this.foldericon1.getImage().getSource(), new SelectedImageFilter());
        this.foldericon2 = new ImageIcon(this.createImage(fis));
        this.file1icon1 = new ImageIcon(this.getClass().getResource("file.png"));
        fis = new FilteredImageSource(this.file1icon1.getImage().getSource(), new SelectedImageFilter());
        this.file1icon2 = new ImageIcon(this.createImage(fis));
        this.file2icon1 = new ImageIcon(this.getClass().getResource("file_alert.png"));
        fis = new FilteredImageSource(this.file2icon1.getImage().getSource(), new SelectedImageFilter());
        this.file2icon2 = new ImageIcon(this.createImage(fis));
        fis = new FilteredImageSource(this.nicon.getImage().getSource(), new SelectedImageFilter());
        this.sicon = new ImageIcon(this.createImage(fis));
        this.iconLabel = new JLabel(this.nicon);
        this.iconLabel.setBorder(BorderFactory.createEmptyBorder());
        table.setRowHeight(Math.max(this.textLabel.getPreferredSize().height, this.iconLabel.getPreferredSize().height));
        this.add(this.iconLabel);
        this.add(this.textLabel);
        this.add(Box.createHorizontalGlue());
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.textLabel.setText(value == null ? "" : value.toString());
        FontMetrics fm = table.getFontMetrics(table.getFont());
        int swidth = fm.stringWidth(this.textLabel.getText()) + this.textLabel.getInsets().left + this.textLabel.getInsets().right;
        int cwidth = table.getColumnModel().getColumn(column).getWidth() - this.iconLabel.getPreferredSize().width;
        this.textLabel.setPreferredSize(new Dimension(swidth > cwidth ? cwidth : swidth, 0));
        if (isSelected) {
            this.textLabel.setForeground(table.getSelectionForeground());
            this.textLabel.setBackground(table.getSelectionBackground());
        } else {
            this.textLabel.setForeground(table.getForeground());
            this.textLabel.setBackground(table.getBackground());
        }
        if (hasFocus) {
            this.textLabel.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.textLabel.setBorder(noFocusBorder);
        }
        this.textLabel.setFont(table.getFont());
        String size = (String)table.getValueAt(row, 3);
        String lock = (String)table.getValueAt(row, 4);
        if (size.equals("")) {
            this.iconLabel.setIcon(isSelected ? this.foldericon2 : this.foldericon1);
        } else if (lock.equals("")) {
            this.iconLabel.setIcon(isSelected ? this.file1icon2 : this.file1icon1);
        } else {
            this.iconLabel.setIcon(isSelected ? this.file2icon2 : this.file2icon1);
        }
        return this;
    }

    private static class SelectedImageFilter
    extends RGBImageFilter {
        public SelectedImageFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int x, int y, int argb) {
            Color color = new Color(argb, true);
            float[] array = new float[4];
            color.getComponents(array);
            return new Color(array[0] * 0.5f, array[1] * 0.5f, array[2], array[3]).getRGB();
        }
    }
}

