package smart_gs.drawing_tool;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;

import smart_gs.debugprint.Debugprint;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorDrawMode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.drawing_tool.view.MemoPadView;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.LineSegmentForEdit;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.logical.region.AnchorRegion;
import smart_gs.smleditor.swingui.IDATPanel;
import smart_gs.keyboard.action.SelectRegionAction;

@SuppressWarnings("serial")
public class LineSegEditorCanvas extends DrawableCanvas {
	
	private Spread spread;
	private LineSegEditorImageLabel lsgImageLabel;
	private ImageIcon imageIcon;
	
	public LineSegEditorCanvas(Spread spread) {
		super();
		this.getVerticalScrollBar().setUnitIncrement(20);
		this.getHorizontalScrollBar().setUnitIncrement(20);
		this.spread = spread;
		this.imageIcon = spread.getImageIcon();
		this.lsgImageLabel = new LineSegEditorImageLabel(this,imageIcon);
		this.setViewportView(this.lsgImageLabel);
	}
	
	public Point getCornerPoint(){
		return this.getCornerPoint();
	}

	public Spread getSpread(){
		return this.spread;
	}
	

	public LineSegEditorImageLabel getLineSegEditorImageLabel(){
		return this.lsgImageLabel;
	}

	public void addTempView(View view){
		this.lsgImageLabel.addTempView(view);
	}
	public void zoomIn() {
		this.lsgImageLabel.zoomIn();
	}
	public void zoomOut(){
		this.lsgImageLabel.zoomOut();
	}

	public void fullSize() {
		this.lsgImageLabel.fullSize();
	}

	public void fitWidth() {
		this.lsgImageLabel.fitWidth(this.getWidth());
	}

	public void fitHeight() {
		this.lsgImageLabel.fitHeight(this.getHeight());
	}

	
	public void setCenterLocation(Point point){
		this.lsgImageLabel.setCenterLocation(point);
	}

	public void clear() {
		this.getViewport().removeAll();	
		this.getCurrentSpread().release();
	}

	public void setCurrentSpread(Spread currentSpread) {
		this.spread = currentSpread;
	}
	public Spread getCurrentSpread() {
		return spread;
	}
	
	public List<LineSegmentForEdit> getLines() {
		return this.getLineSegEditorImageLabel().getLines();
	}


	/**
	 * @param lines the lines to set
	 */
	public void setLines(List<LineSegmentForEdit> lines) {
		this.getLineSegEditorImageLabel().setLines(lines);
	}

	public void rewriteLineSegIndexes() {
		this.getLineSegEditorImageLabel().rewriteLinesSegIndexes();
	}

	public void addLineSegmentForEdit(LineSegmentForEdit LineSegmentForEdit) {
		this.getLineSegEditorImageLabel().addLineSegmentForEdit(LineSegmentForEdit);
	}
	
}
