/* $Id: MemoPadMode.java 555 2012-09-04 09:08:39Z shayashi $ */
package smart_gs.drawing_tool.drawing_mode;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.view.MemoPadView;
import smart_gs.logical.region.MemoPadRegion;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.util.ImageToolBarSetModeByMouseEvent;

public class MemoPadMode extends DrawingModeAdapter{
	private Component startcomponent = null;
	private boolean out = false;
	private static Mode singleton = new MemoPadMode();
	
	private Point2D start;
	private Point2D end;
	
	public static Mode getInstance() {
		((MemoPadMode)singleton).reset();
		return singleton;
	}
	
	private void reset() {
		startcomponent = null;
		out = false;
		start = null;
		end = null;		
	}
	
	@Override
	public void mouseEntered(GSMouseEvent e, SpreadCanvas canvas) {
		if (startcomponent == null) startcomponent = e.getComponent();
		if (e.getComponent() == startcomponent) {
			out = false;
			setCursor(canvas);
		} else {
			out = true;
		}
		setCursor(canvas);
	}

	@Override
	public void mousePressed(GSMouseEvent e, SpreadCanvas canvas) {
		if (startcomponent == null) startcomponent = e.getComponent();
		super.mousePressed(e, canvas);
		this.start = e.getPoint();
		setCursor(canvas);
	}
	
	@Override
	public void mouseDragged(GSMouseEvent e,SpreadCanvas canvas) {
		if(e.getComponent() != startcomponent){
			return ;
		}
		super.mouseDragged(e,canvas);
		this.end = e.getPoint();
		setCursor(canvas);
	}
	
	@Override
	public void mouseMoved(GSMouseEvent e,SpreadCanvas canvas) {
		if (startcomponent == null) startcomponent = e.getComponent();
		if (e.getComponent() == startcomponent) {
			out = false;
		} else {
			out = true;
			setCursor(canvas);
			return;
		}
		setCursor(canvas);
	}
	
	@Override
	public void mouseReleased(GSMouseEvent e, SpreadCanvas canvas) {
		super.mouseReleased(e, canvas);
		if(start == null || end == null){
			setCursor(canvas);
			return ;
		}
		
		if (end.getX() - start.getX() > 30 && end.getY() - start.getY() > 30 ) {
			canvas.addRegion(new MemoPadRegion(canvas.getSpread(), 
					adjustRect(start.getX(), start.getY())));
		}
		this.start = null;
		this.end = null;
		DefaultState.getInstance().setMode(DefaultDrawingMode.getInstance());
		new ImageToolBarSetModeByMouseEvent().setMode(e,ImageToolBar.modeNone);
		setCursor(canvas);
	}
	@Override
	public void paint(Graphics g,SpreadCanvas canvas) {
		if (out) return;
		super.paint(g,canvas);
		if(this.start == null || this.end == null){
			setCursor(canvas);
			return;
		}
		double ratio = canvas.getImageLabel().getRatio();
		double gapX = canvas.getImageLabel().getGapWidth();
		double gapY = canvas.getImageLabel().getGapHeight();
		MemoPadView view = new MemoPadView(adjustRect(start.getX(), start.getY()), MemoPadView.defaultMemoPadText).enlargedView(ratio, gapX, gapY);
//		view.setMemoPadText("MemoPad"); // debug
		view.draw((Graphics2D)g);
		
	}
	private Rectangle2D.Double adjustRect(double sx, double sy){
		double width, height;
		double startX, startY;
		
		if(start.getX() > end.getX()){
			startX = end.getX();
			width = start.getX() - end.getX();
		}
		else{
			startX = start.getX();
			width = end.getX() - start.getX();
		}
		if(start.getY() > end.getY()){
			startY = end.getY();
			height = start.getY() - end.getY();
		}
		else{
			startY = start.getY();
			height= end.getY() - start.getY();
		}
		return new Rectangle2D.Double(startX,startY,width,height);
	}
}
