/* $Id: GSResourcePointer.java 373 2011-10-01 16:30:41Z shayashi $ */
package smart_gs.reasoning_web.logical;

import java.util.ArrayList;
import java.util.Hashtable;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import reasoning_web.logical.Connection;
import reasoning_web.logical.ExplanatoryNote;
import reasoning_web.logical.ResourcePointer;
import smart_gs.debugprint.Debugprint;
import smart_gs.logical.GSResource;
import smart_gs.logical.URISolver;
import smart_gs.logical.Zombie;
import smart_gs.reasoning_web.URIBearer;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.swingui.view.ResourcePointerView;
import smart_gs.reasoning_web.swingui.view.View;
import smart_gs.util.Quadruple;

public class GSResourcePointer extends ResourcePointer {

	protected View view;

//	Any GS_RWElement has an unique GSResourcePointer. See RWRepository.java. 
	protected GSResourcePointer(GS_RWElement element) {
		super(element);
		this.view = new ResourcePointerView(this);
	}

	public View getView() {
		return this.view;
	}
	public ArrayList<Quadruple<Connection,GS_RWElement, GSExplanatoryNote, Integer>> getLocalViewInfo() {
		ArrayList<Quadruple<Connection, GS_RWElement, GSExplanatoryNote, Integer>> elements = 
			new ArrayList<Quadruple<Connection, GS_RWElement, GSExplanatoryNote, Integer>>();
		for (int i = 0; i < this.connections.size(); i++) {
			Connection connection = this.connections.get(i);
			ExplanatoryNote note = connection.getExplanatoryNote();
			int this_edge_type = connection.typeOfPointerInConnection(this);
			int peer_edge_type;
			ResourcePointer peer_pointer;
			if (this_edge_type == Connection.SOURCE) {
				peer_pointer = connection.getTargetPointer();
				peer_edge_type = Connection.TARGET;
			} else if (this_edge_type == Connection.TARGET) {
				peer_pointer = connection.getSourcePointer();
				peer_edge_type = Connection.SOURCE;
			} else {
				// the edges are identical. 
				peer_pointer = connection.getTargetPointer();
				peer_edge_type = Connection.LOOP;
			}
			elements.add(
					new Quadruple<Connection,GS_RWElement, GSExplanatoryNote, Integer> (
							connection,
							(GS_RWElement) peer_pointer.getRwElement(),
							(GSExplanatoryNote) note,
							new Integer(peer_edge_type)
					)
			);
		}
		return elements;
	}

	public Element createXMLElement(Document document) {
		Element element = document.createElement("pointer");
		element.setAttribute("uri", ((GS_RWElement) this.rw_element).getURI());
		element.setAttribute(GSResource.ORIGINAL_URI, ((URIBearer) this.rw_element).getOriginalURI());
		// 2007/10/22 kazuhiro kobayashi

		element.setAttribute("x", String.valueOf(this.view.getRectangle()
				.getX()));
		element.setAttribute("y", String.valueOf(this.view.getRectangle()
				.getY()));
		element.setAttribute("width", String.valueOf(this.view.getRectangle()
				.getWidth()));
		element.setAttribute("height", String.valueOf(this.view.getRectangle()
				.getHeight()));

		// 2007/10/23
		if (this.name != "") {
			element.setAttribute("name", this.name);
		}

		return element;
	}

	public static GSResourcePointer restore(Element element) {
		String uri = element.getAttribute("uri");
		double x = 300;
		double y = 300;
		//
		String name = "";
		if (element.getAttribute("x") != "") {
			x = Double.parseDouble(element.getAttribute("x"));
		}
		if (element.getAttribute("y") != "") {
			y = Double.parseDouble(element.getAttribute("y"));
		}
		if (element.getAttribute("name") != "") {
			name = element.getAttribute("name");
		}
		//
		GS_RWElement resource = URISolver.getResource(uri);
		if (resource == null) {
			System.out.println(String.format("Error: resource %s is not found. Making a zombie for a resource pointer", uri));
			resource = new Zombie(uri); 
		}
		if (GS_RWRepository.getInstance().isRegistered(resource)) {
			// 2007/10/22 kazuhiro kobayashi
			GSResourcePointer pointer = GS_RWRepository.getInstance()
					.getResourcePointer(resource);
			pointer.view.setRectangle(x, y);
			// 10/23
			pointer.setName(name);
			// pointer.setNote(note);
			//
			return pointer;
		}

		GSResourcePointer pointer = new GSResourcePointer(resource);
		pointer.view.setRectangle(x, y);
		pointer.setName(name);
		return pointer;
	}

	public String getURI() {
		return ((GS_RWElement) this.rw_element).getURI();
	}


}
