package smart_gs.reasoning_web.swingui;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.border.TitledBorder;

import smart_gs.GSConstants;
import smart_gs.image_search.LineImageCropper;
import smart_gs.logical.FirstIDAT;
import smart_gs.logical.IDAT;
import smart_gs.logical.Preference;
import smart_gs.logical.Region;
import smart_gs.logical.SecondIDAT;
import smart_gs.logical.Spread;
import smart_gs.logical.TextSegment;
import smart_gs.logical.URIObject;
import smart_gs.logical.UsersNote;
import smart_gs.menu.action.SpreadJumpAction;
import smart_gs.menu.action.SpreadOpenAction;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.InConstruction;
import smart_gs.logical.SmartDocument;


public class elementViewPanelListener extends MouseAdapter {
	private GS_RWElement element;
	private JPanel panelOfLocalView;
	private JWindow window;
	private JPanel panelToDisplayInformation = new JPanel();

	public elementViewPanelListener(JPanel panel,GS_RWElement element) {
		this.element = element;
		this.panelOfLocalView = panel;
	}

	@Override
	public void mouseClicked(MouseEvent e) {
		super.mouseClicked(e);

		if (element instanceof Region) {
			Region region = (Region)element;
			if (e.getButton()==MouseEvent.BUTTON1) {
				if (WorkspaceWindow.getInstance().isAlt()) {
					/* alternative for right button click */
					SpreadJumpAction.jumpToMarkup(region);
				} else {
					SpreadOpenAction.openMarkup(region);
				}
			} if (e.getButton()==MouseEvent.BUTTON3)	{
				SpreadJumpAction.jumpToMarkup(region);
			}
		} else if (element instanceof TextSegment) {
			TextSegment segment= (TextSegment)element;
			if (e.getButton()==MouseEvent.BUTTON1) {
				if (WorkspaceWindow.getInstance().isAlt()) {
					/* alternative for right button click */
					SpreadJumpAction.jumpToMarkup(segment);
				} else {
					SpreadOpenAction.openMarkup(segment);
				}
			} if (e.getButton()==MouseEvent.BUTTON3)	{
				SpreadJumpAction.jumpToMarkup(segment);
			}
		} else {
			InConstruction.message();
		}
	}
	
	@Override
	public void mouseEntered(MouseEvent e) {
		super.mouseEntered(e);
		
		String uri = element.getURI();
		String[] token = (uri.substring(8)).split("/");
		TimeZone timeZone = TimeZone.getDefault();

		String toPrint = "";
		
		if (element instanceof Region) {
			String kind = ((Region)element).getTypeStringForDisplay();
			String userName = token[1];
			String creationTime = URIObject.localizeDate(timeZone, token[2]) 
									+ " ("+ timeZone.getID() +")";
			String locationKind = "Image";
			String locationName = token[4];
			String locationPath = ((Region)element).getSpread().getFolderPath();
			locationPath = "/root/" + locationPath + locationName;
			toPrint = String.format("<html>Kind: %s<br>User: %s<br>Time: %s<br>Location Kind: %s<br>Spread Name: %s<br>Path: %s<br></html>",
					kind,userName,creationTime,locationKind,locationName,locationPath);
		} else if (element instanceof TextSegment) {	
			String kind = "Text Segment";
			String userName = token[1];
			String creationTime = URIObject.localizeDate(timeZone, token[2]) 
									+ " ("+ timeZone.getID() +")";
			String locationKind = token[3];
			if (locationKind.equals("^usersNote")) {
				locationKind = "Users' Note";
			} else if (locationKind.equals("^firstIdat")) {
				locationKind = "first IDAT";
			} else if (locationKind.equals("^secondIdat")) {
				locationKind = "second IDAT";
			} else if (locationKind.equals("^thirdIdat")) {
				locationKind = "third IDAT";
			}


			if (locationKind.equals("Users' Note")) {
				String noteName = token[4];
				
				UsersNote note = (UsersNote)((TextSegment)element).getDocument();
				String notePath = "/root/" + note.getFolderPath() + noteName;
				toPrint = String.format("<html>Kind: %s<br>User: %s<br>Time: %s<br>Location Kind: %s<br>Note Name: %s<br>Path: %s<br></html>",
						kind,userName,creationTime,locationKind,noteName,notePath);
			} else {
				//IDAT case
				String spreadName;
				String idatName;
				spreadName = token[7];
				TextSegment seg = (TextSegment)element;
				IDAT idat = (IDAT)seg.getDocument();
				Spread spread = idat.getSpread();
				if (idat instanceof FirstIDAT) {
					idatName = spread.getFirstIDATName();
				} else if (idat instanceof SecondIDAT) {
					idatName = spread.getSecondIDATName();
				} else {
					idatName = spread.getThirdIDATName();
				}
				String spreadPath = spread.getFolderPath();
				spreadPath = "/root/" + spreadPath + spreadName;
				toPrint = String.format("<html>Kind: %s<br>User: %s<br>Time: %s<br>Location Kind: %s<br>IDAT Name: %s<br>Spread Name: %s<br>Spread Path: %s<br></html>",
						kind,userName,creationTime,locationKind,idatName,spreadName,spreadPath);
			}
		} else {
			InConstruction.message();
			toPrint = "";
		}
		
		JLabel label = new JLabel(toPrint);
		
		panelToDisplayInformation.add(label,BorderLayout.CENTER);
		
		if (window == null) window = new JWindow();
		
		window.getContentPane().setLayout(new BorderLayout());
		window.getContentPane().add(label,BorderLayout.CENTER);

		Point orig_p = panelOfLocalView.getLocationOnScreen();
		Point p = new Point(orig_p.x + GSConstants.ELEMENT_VIEW_PANEL_FOR_LOCAL_VIEW_SIZE + 10, orig_p.y);
		window.setLocation(p);

		window.pack();
		window.setVisible(true);
	}
	
	@Override
	public void mouseExited(MouseEvent e) {
		if(this.window != null){
			this.window.setVisible(false);
		}
	}
	

	
}