/* $Id: GSEditorToolBar.java 320 2011-08-25 14:13:37Z shayashi $ */
package smart_gs.swingui.toolbar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import smart_gs.smleditor.swingui.GSEditorTextPane;
import sml_editor.swingui.toolbar.EditorToolBar;
import sml_editor.swingui.toolbar.EditorToolBarPlan;

@SuppressWarnings("serial")
public class GSEditorToolBar extends EditorToolBar implements ActionListener{
	public GSEditorToolBar(GSEditorTextPane textPane) {
		this(textPane,new EditorToolBarPlan());
	}
	public GSEditorToolBar(GSEditorTextPane textPane,EditorToolBarPlan toolBarPlan) {
		super(textPane,toolBarPlan);
		this.markup.removeActionListener(this.markupAction);
		this.markupAction = new GSMarkupAction();
		this.markupAction.setEditorTextPane(textPane);
		this.markup.addActionListener(this.markupAction);
		
		this.removeTag.removeActionListener(this.removeTagAction);
		this.removeTagAction = new GSRemoveTagAction();
		
		browse.addActionListener(this);
		browse.setToolTipText("Browse");
		edit.addActionListener(this);
		edit.setToolTipText("Edit");
		source.addActionListener(this);
		source.setToolTipText("Source");
		if(toolBarPlan.isSource()){
			this.add(source,0);
		}
		if(toolBarPlan.isEdit()){
			this.add(edit,0);
		}
		if(toolBarPlan.isBrowse()){
			this.add(browse,0);
		}
	}

	public void actionPerformed(ActionEvent e) {
		if(e.getSource().equals(source)){
			onSourcemode();
		}else if(e.getSource().equals(browse)){
			onBrowseMode();
		}else if(e.getSource().equals(edit)){
			onEditMode();
		}
	}
	
	public void tabChanged(){
		if(edit_mode == EDIT_MODE_SOURCE){
			onSourcemode();
		}else if(edit_mode == EDIT_MODE_BROWSE){
			onBrowseMode();
		}else if(edit_mode == EDIT_MODE_EDIT){
			onEditMode();
		}
	}
		
	public void onSourcemode(){
		edit_mode = EDIT_MODE_SOURCE;
		browse.setSelected(false);
		edit.setSelected(false);
		source.setSelected(true);
		this.textPane.setMenuMode(true);
		this.textPane.setSourceMode(true);
		this.textPane.setEdit(false);
		this.textPane.updateUI();
	}
	public void onBrowseMode(){
		edit_mode = EDIT_MODE_BROWSE;

		this.textPane.setMenuMode(true);
		this.textPane.setSourceMode(false);
		this.textPane.setEdit(false);
		this.textPane.updateUI();
		browse.setSelected(true);
		edit.setSelected(false);
		source.setSelected(false);
	}
	public void onEditMode(){
		edit_mode = EDIT_MODE_EDIT;
		this.textPane.setMenuMode(false);
		this.textPane.setSourceMode(false);
		this.textPane.setEdit(true);
		this.textPane.updateUI();
		browse.setSelected(false);
		edit.setSelected(true);
		source.setSelected(false);

	}
	// ADD 2009/05/20 Northgrid
	/**
	 * @return 0 browse,1 edit,2 source
	 */
	public int getMode(){
		if(browse.isSelected()){
			return 0;
		}else if(edit.isSelected()){
			return 1;
		}else if(source.isSelected()){
			return 2;
		}
		return -1;
	}
	
}
