package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import javax.swing.JOptionPane;

import smart_gs.logical.LineSegmentForEdit;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.LineSegEditor;

public class LineSegEditorDeleteActionListener implements ActionListener {
	LineSegEditor editor;

	public LineSegEditorDeleteActionListener(LineSegEditor editor) {
		this.editor = editor;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		editor.pushLinestack();
		String input = JOptionPane.showInputDialog("Index of line segment to delete:", "");
		if(input == null){
			return;
		}
		int index = Integer.parseInt(input);
		Spread spread = editor.getSpread();
		List<LineSegmentForEdit> lines = editor.getLinesForEdit();
		lines.remove(index);
		editor.rewriteLineSegIndexes();
		editor.repaint();
	}
}

